/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.common.model.chart;

import com.arm.streamline.common.model.VariableReplacerConstants;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public final class SeriesAliasUtils {
    private static @NonNull String joinAlias(String ... names) {
        StringBuilder alias = new StringBuilder();
        String[] stringArray = names;
        int n = names.length;
        int n2 = 0;
        while (n2 < n) {
            String s = stringArray[n2];
            if (s != null) {
                String[] stringArray2 = s.split("[^_A-Za-z0-9]+");
                int n3 = stringArray2.length;
                int n4 = 0;
                while (n4 < n3) {
                    String next = stringArray2[n4];
                    if (!next.isEmpty()) {
                        char ch = Character.toUpperCase(next.charAt(0));
                        if (alias.length() == 0 && ch >= '0' && ch <= '9') {
                            alias.append('_');
                        }
                        alias.append(ch);
                        alias.append(next.substring(1));
                    }
                    ++n4;
                }
            }
            ++n2;
        }
        return alias.toString();
    }

    public static @NonNull String createAlias(String title, String name) {
        return SeriesAliasUtils.joinAlias(title, name);
    }

    public static @NonNull String createAlias(String title, String name, String deviceInstance) {
        return SeriesAliasUtils.joinAlias(title, name, deviceInstance);
    }

    public static @NonNull String createAlias(String title, String name, int clusterNo) {
        return String.format("%s%s", SeriesAliasUtils.createAlias(title, name), VariableReplacerConstants.clusterSuffixId(clusterNo));
    }

    public static @NonNull String createAlias(String title, String name, @Nullable Integer clusterNo) {
        if (clusterNo != null) {
            return SeriesAliasUtils.createAlias(title, name, (int)clusterNo);
        }
        return SeriesAliasUtils.createAlias(title, name);
    }
}

