/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.common.model.chart;

import java.util.regex.Pattern;
import org.eclipse.jdt.annotation.NonNull;

public final class ActivityChartUtils {
    public static final Pattern CLUSTER_TITLE_PATTERN = Pattern.compile(" (.*)");
    public static final @NonNull String CPU_ACTIVITY_SYSTEM = "System";
    public static final int CPU_ACTIVITY_SYSTEM_COLOR = -2132850878;
    public static final @NonNull String CPU_ACTIVITY_SYSTEM_DESCRIPTION = "System activity";
    public static final @NonNull String CPU_ACTIVITY_TITLE = "CPU Activity";
    public static final @NonNull String CPU_ACTIVITY_USER = "User";
    public static final int CPU_ACTIVITY_USER_COLOR = -2143625405;
    public static final @NonNull String CPU_ACTIVITY_USER_DESCRIPTION = "User activity";
    public static final int GPU_COMPUTE_COLOR = 15663663;
    public static final int GPU_FRAGMENT_COLOR = 28620;
    public static final int GPU_VERTEX_COLOR = 15572992;

    public static boolean isCPUActivity(String title) {
        return title.contentEquals(CPU_ACTIVITY_TITLE) || title.startsWith(CPU_ACTIVITY_TITLE) && CLUSTER_TITLE_PATTERN.matcher(title.substring(CPU_ACTIVITY_TITLE.length())).find();
    }

    public static boolean isCPUActivitySystem(String title, String name) {
        return ActivityChartUtils.isCPUActivity(title) && name.contentEquals(CPU_ACTIVITY_SYSTEM);
    }

    public static boolean isCPUActivityUser(String title, String name) {
        return ActivityChartUtils.isCPUActivity(title) && name.contentEquals(CPU_ACTIVITY_USER);
    }
}

