/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.common.model;

import com.arm.streamline.common.model.ZoomLevel;
import org.eclipse.jdt.annotation.NonNull;

public final class Position {
    private @NonNull ZoomLevel mDensestZoomLevel;
    private long mIndex;

    public static final long scale(long value, @NonNull ZoomLevel oldZoomLevel, @NonNull ZoomLevel newZoomLevel) {
        return oldZoomLevel.equals(newZoomLevel) ? value : value * (long)newZoomLevel.getBps() / (long)oldZoomLevel.getBps();
    }

    public Position(@NonNull ZoomLevel densestZoomLevel) {
        this.mDensestZoomLevel = densestZoomLevel;
        this.mIndex = -1L;
    }

    public Position(long index, @NonNull ZoomLevel zoomLevel, @NonNull ZoomLevel densestZoomLevel) {
        this.mDensestZoomLevel = densestZoomLevel;
        this.set(index, zoomLevel);
    }

    public final boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof Position) {
            Position other = (Position)obj;
            return this.mIndex == other.mIndex && this.mDensestZoomLevel.equals(other.mDensestZoomLevel);
        }
        return false;
    }

    public final long get(@NonNull ZoomLevel zoomLevel) {
        return this.mIndex < 0L ? -1L : Position.scale(this.mIndex, this.mDensestZoomLevel, zoomLevel);
    }

    public final int hashCode() {
        return 31 * (31 + this.mDensestZoomLevel.getBps()) + (int)(this.mIndex ^ this.mIndex >>> 32);
    }

    public final boolean isExact(@NonNull ZoomLevel zoomLevel) {
        long index = this.get(zoomLevel);
        return this.mIndex == Position.scale(index, zoomLevel, this.mDensestZoomLevel);
    }

    public final boolean isValid() {
        return this.mIndex >= 0L;
    }

    public final void set(long index, @NonNull ZoomLevel zoomLevel) {
        this.mIndex = Position.scale(index, zoomLevel, this.mDensestZoomLevel);
    }

    public final void set(Position other) {
        this.mDensestZoomLevel = other.mDensestZoomLevel;
        this.mIndex = other.mIndex;
    }

    public String toString() {
        return Long.toString(this.mIndex);
    }
}

