/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.barman.pass_two;

import com.arm.streamline.analysis.model.threads.IUniqueProcess;
import com.arm.streamline.analysis.model.threads.IUniqueThread;
import com.arm.streamline.barman.pass_two.BarmanUniqueChildThread;
import com.arm.streamline.barman.pass_two.BarmanUniqueProcessThread;
import com.arm.streamline.barman.pass_two.BarmanUniqueThread;
import com.arm.streamline.barman.pass_two.IBarmanUniqueThreadTracker;
import gnu.trove.TCollections;
import gnu.trove.map.TIntObjectMap;
import gnu.trove.map.hash.TIntObjectHashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.IntSupplier;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public final class BarmanUniqueThreadTracker
implements IBarmanUniqueThreadTracker {
    private final @Nullable BarmanUniqueProcessThread defaultProcessThread;
    private final @NonNull TIntObjectMap<BarmanUniqueThread> threads = new TIntObjectHashMap(10, 0.5f, Integer.MIN_VALUE);
    private final @NonNull IntSupplier uidSupplier;
    private final @NonNull Map<@NonNull IUniqueProcess, @NonNull Set<@NonNull IUniqueThread>> uniqueThreadsMap;
    private final long vmUID;

    public BarmanUniqueThreadTracker(@NonNull Map<@NonNull IUniqueProcess, @NonNull Set<@NonNull IUniqueThread>> uniqueThreadsMap, @NonNull IntSupplier uidSupplier, long vmUID, @NonNull Set<@NonNull BarmanUniqueThread> threads, @Nullable BarmanUniqueProcessThread defaultProcessThread) {
        if (defaultProcessThread != null && !defaultProcessThread.isProcessThread()) {
            throw new IllegalArgumentException();
        }
        this.uniqueThreadsMap = uniqueThreadsMap;
        this.uidSupplier = uidSupplier;
        this.vmUID = vmUID;
        this.defaultProcessThread = defaultProcessThread;
        threads.forEach(t -> this.track((BarmanUniqueThread)t));
        if (defaultProcessThread != null) {
            this.track(defaultProcessThread);
        }
    }

    public @NonNull TIntObjectMap<BarmanUniqueThread> getAllThreads() {
        return TCollections.unmodifiableMap(this.threads);
    }

    public @Nullable BarmanUniqueProcessThread getDefaultProcessThread() {
        return this.defaultProcessThread;
    }

    @Override
    public @NonNull BarmanUniqueThread map(long timestamp, int taskId) {
        BarmanUniqueThread result = (BarmanUniqueThread)this.threads.get(taskId);
        if (result == null) {
            @Nullable BarmanUniqueProcessThread defaultProcessThread = this.defaultProcessThread;
            result = defaultProcessThread == null ? new BarmanUniqueProcessThread(this.uidSupplier.getAsInt(), this.uidSupplier.getAsInt(), this.vmUID, timestamp, taskId, null, null, null, false) : new BarmanUniqueChildThread(this.uidSupplier.getAsInt(), timestamp, taskId, defaultProcessThread, null, false);
            this.track(result);
        }
        result.updateLastSeenTimestamp(timestamp);
        return result;
    }

    private void track(@NonNull BarmanUniqueThread thread) {
        this.threads.put(thread.getOriginalID(), (Object)thread);
        this.uniqueThreadsMap.computeIfAbsent(thread.getProcessThread().asUniqueProcess(), k -> new HashSet()).add(thread);
    }
}

