/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.barman.pass_two;

import com.arm.streamline.analysis.model.threads.ExecutablePathMapping;
import com.arm.streamline.analysis.model.threads.IExecutablePath;
import com.arm.streamline.barman.pass_two.BarmanUniqueProcessThread;
import com.arm.streamline.barman.pass_two.BarmanUniqueThread;
import java.util.List;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public final class BarmanUniqueChildThread
extends BarmanUniqueThread {
    private final @NonNull BarmanUniqueProcessThread processThread;

    public BarmanUniqueChildThread(int uid, long timestamp, int taskId, @NonNull BarmanUniqueProcessThread processThread, @Nullable String name, boolean idle) {
        super(uid, timestamp, taskId, name, idle);
        if (!processThread.isProcessThread() || processThread.getOriginalID() == taskId) {
            throw new IllegalArgumentException();
        }
        this.processThread = processThread;
    }

    public @Nullable ExecutablePathMapping findMMapping(long address) {
        return this.processThread.findMMapping(address);
    }

    public @Nullable IExecutablePath getExecutablePath() {
        return this.processThread.getExecutablePath();
    }

    @Override
    public @NonNull BarmanUniqueProcessThread getProcessThread() {
        return this.processThread;
    }

    public long getVmUID() {
        return this.processThread.getVmUID();
    }

    @Override
    public boolean hasMMaps() {
        return this.processThread.hasMMaps();
    }

    public boolean isKernel() {
        return this.processThread.isKernel();
    }

    public boolean isProcessThread() {
        return false;
    }

    @Override
    public String toString() {
        return String.format("BarmanUniqueChildThread [uid=%s, vmUID=%s, processThread=%s, taskId=%s, name=%s, earliestSeenTimestamp=%s, lastSeenTimestamp=%s]", this.getUID(), this.getVmUID(), this.processThread.getOriginalID(), this.getOriginalID(), this.getName(), this.getEarliestSeenTimestamp(), this.getLastSeenTimestamp());
    }

    @Override
    protected boolean equalsChild(@NonNull BarmanUniqueThread obj) {
        if (obj instanceof BarmanUniqueChildThread) {
            BarmanUniqueChildThread that = (BarmanUniqueChildThread)obj;
            return this.processThread.equals(that.processThread);
        }
        return false;
    }

    public @NonNull List<@NonNull ExecutablePathMapping> getMMaps() {
        return this.processThread.getMMaps();
    }
}

