/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.barman.pass_two;

import com.arm.streamline.analysis.database.api.IAnalysisWriterFactoryV2;
import com.arm.streamline.analysis.database.api.annotations.AnnotationTextGroupChannelIdentifier;
import com.arm.streamline.analysis.database.api.annotations.IAnalysisAnnotationsWriter;
import com.arm.streamline.analysis.database.api.counters.IAnalysisHardwareCounterWriter;
import com.arm.streamline.analysis.database.api.idle.IAnalysisIdleStateWriter;
import com.arm.streamline.analysis.database.api.idle.IdleState;
import com.arm.streamline.analysis.database.api.profiling.IAnalysisCodeProfilingWriter;
import com.arm.streamline.analysis.database.api.profiling.IBacktraceSource;
import com.arm.streamline.analysis.database.api.scheduler.IAnalysisSchedulerTraceWriter;
import com.arm.streamline.analysis.model.ICounterSeriesKey;
import com.arm.streamline.analysis.model.IVirtualMachineProperties;
import com.arm.streamline.analysis.model.StaticCounterSeriesKey;
import com.arm.streamline.analysis.model.threads.ExecutablePathMapping;
import com.arm.streamline.analysis.model.threads.IExecutablePath;
import com.arm.streamline.barman.pass_two.IBarmanUniqueThread;
import com.arm.streamline.barman.pass_two.IBarmanUniqueThreadTracker;
import com.arm.streamline.barman.recordstream.IBarmanEventStream;
import com.arm.streamline.common.model.counters.CounterClass;
import com.arm.streamline.common.model.counters.CounterRecord;
import com.arm.streamline.common.model.topology.DeviceType;
import com.arm.streamline.common.model.topology.ProcessingElementReferenceSet;
import com.arm.streamline.common.model.warnings.WarningItem;
import com.arm.streamline.common.utility.Ternary;
import com.arm.streamline.report.model.uids.IUniqueThreadID;
import com.arm.utils.collections.Pair;
import gnu.trove.map.TIntObjectMap;
import gnu.trove.map.hash.TIntObjectHashMap;
import java.io.IOException;
import java.util.List;
import java.util.function.Consumer;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public final class BarmanEventStream
implements IBarmanEventStream,
IVirtualMachineProperties {
    public static final @NonNull IBacktraceSource BACKTRACE_SOURCE = IBacktraceSource.PERIODIC_SAMPLES;
    private final @NonNull IAnalysisAnnotationsWriter annotationsWriter;
    private final @NonNull IAnalysisCodeProfilingWriter codeProfilingWriter;
    private final @NonNull TIntObjectMap<Pair<@NonNull DeviceType, @NonNull IAnalysisHardwareCounterWriter>> counterWritersByKey = new TIntObjectHashMap(10, 0.5f, -1);
    private boolean first = true;
    private long firstTimestamp = 0L;
    private final @NonNull IAnalysisIdleStateWriter idleStateWriter;
    private long lastTimestamp = 0L;
    private final @NonNull ProcessingElementReferenceSet peReferenceSet;
    private final @NonNull IAnalysisSchedulerTraceWriter schedulerTraceWriter;
    private final @NonNull IBarmanUniqueThreadTracker uniqueThreadTracker;
    private final long vmUID;
    private final @NonNull Consumer<@NonNull WarningItem> warningHandler;
    private final long earliestGlobalTimestamp;

    public BarmanEventStream(long vmUID, long earliestGlobalTimestamp, @NonNull ProcessingElementReferenceSet peReferenceSet, @NonNull IBarmanUniqueThreadTracker uniqueThreadTracker, @NonNull List<@NonNull StaticCounterSeriesKey> staticCounterSeriesKeys, @NonNull Consumer<@NonNull WarningItem> warningHandler, @NonNull IAnalysisWriterFactoryV2 analysisWriterFactory) throws IOException {
        this.vmUID = vmUID;
        this.peReferenceSet = peReferenceSet;
        this.uniqueThreadTracker = uniqueThreadTracker;
        this.warningHandler = warningHandler;
        this.earliestGlobalTimestamp = earliestGlobalTimestamp;
        this.codeProfilingWriter = analysisWriterFactory.createCodeProfilingWriter();
        this.annotationsWriter = analysisWriterFactory.createAnnotationsWriter();
        this.idleStateWriter = analysisWriterFactory.createIdleStateWriter();
        this.schedulerTraceWriter = analysisWriterFactory.createSchedulerTraceWriter();
        for (StaticCounterSeriesKey staticCounterSeriesKey : staticCounterSeriesKeys) {
            @NonNull CounterRecord counterRecord = staticCounterSeriesKey.getCounterRecord();
            if (counterRecord.ignore() || counterRecord.getCounterClass() == CounterClass.ACTIVITY) continue;
            if (counterRecord.isProc() == Ternary.TRUE) {
                throw new AssertionError();
            }
            int key = counterRecord.getKey();
            @NonNull DeviceType deviceType = staticCounterSeriesKey.getDeviceTypeOrDefault();
            @NonNull IAnalysisHardwareCounterWriter writer = analysisWriterFactory.createCounterWriter((ICounterSeriesKey)staticCounterSeriesKey);
            this.counterWritersByKey.put(key, (Object)new Pair((Object)deviceType, (Object)writer));
        }
    }

    @Override
    public void absoluteSample(long timestamp, int taskId, long @NonNull [] addresses) throws IOException {
        timestamp = this.checkTimestamp(timestamp);
        @NonNull IBarmanUniqueThread utid = this.uniqueThreadTracker.map(timestamp, taskId);
        @Nullable IExecutablePath @NonNull [] offsetExecutablePaths = new IExecutablePath[addresses.length];
        if (utid.hasMMaps()) {
            int i = 0;
            while (i < addresses.length) {
                @Nullable ExecutablePathMapping mapping = utid.findMMapping(addresses[i]);
                if (mapping != null) {
                    offsetExecutablePaths[i] = mapping.executablePath;
                    addresses[i] = mapping.mapAddressToOffset(addresses[i]);
                }
                ++i;
            }
        }
        this.codeProfilingWriter.consumeBacktrace(timestamp, BACKTRACE_SOURCE, (IUniqueThreadID)utid, offsetExecutablePaths, addresses);
    }

    @Override
    public void annotationMarker(long timestamp, int taskId, int color, @NonNull String text) throws IOException {
        timestamp = this.checkTimestamp(timestamp);
        @NonNull IBarmanUniqueThread utid = this.uniqueThreadTracker.map(timestamp, taskId);
        this.annotationsWriter.consumeAnnotationMarker((IUniqueThreadID)utid, timestamp, color, text);
    }

    @Override
    public void annotationText(long timestamp, int taskId, int channel, int colour, @NonNull String text) throws IOException {
        timestamp = this.checkTimestamp(timestamp);
        @NonNull IBarmanUniqueThread utid = this.uniqueThreadTracker.map(timestamp, taskId);
        this.annotationsWriter.consumeAnnotationText((IUniqueThreadID)utid, timestamp, AnnotationTextGroupChannelIdentifier.user((IUniqueThreadID)utid, (int)channel), colour, text);
    }

    @Override
    public void annotationTextNameChannel(long timestamp, int taskId, int channel, int group, @NonNull String name) throws IOException {
        timestamp = this.checkTimestamp(timestamp);
        @NonNull IBarmanUniqueThread utid = this.uniqueThreadTracker.map(timestamp, taskId);
        this.annotationsWriter.consumeAnnotationNameChannel((IUniqueThreadID)utid, timestamp, AnnotationTextGroupChannelIdentifier.user((IUniqueThreadID)utid, (int)channel), AnnotationTextGroupChannelIdentifier.user((IUniqueThreadID)utid, (int)group), name);
    }

    @Override
    public void annotationTextNameGroup(long timestamp, int taskId, int group, @NonNull String name) throws IOException {
        timestamp = this.checkTimestamp(timestamp);
        @NonNull IBarmanUniqueThread utid = this.uniqueThreadTracker.map(timestamp, taskId);
        this.annotationsWriter.consumeAnnotationNameGroup((IUniqueThreadID)utid, timestamp, AnnotationTextGroupChannelIdentifier.user((IUniqueThreadID)utid, (int)group), name);
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @Override
    public void counter(long timestamp, int core, int taskId, int key, long value) throws IOException {
        timestamp = this.checkTimestamp(timestamp);
        @NonNull IBarmanUniqueThread utid = this.uniqueThreadTracker.map(timestamp, taskId);
        @Nullable @NonNull @NonNull Pair pair = (Pair)this.counterWritersByKey.get(key);
        if (pair != null) {
            @NonNull DeviceType deviceType = (DeviceType)pair.first;
            @NonNull IAnalysisHardwareCounterWriter writer = (IAnalysisHardwareCounterWriter)pair.second;
            writer.consumerCounterValue(this.peReferenceSet.get(deviceType, this.vmUID, core), timestamp, (IUniqueThreadID)utid, value);
        }
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @Override
    public void counter(long timestamp, int core, int key, long value) throws IOException {
        timestamp = this.checkTimestamp(timestamp);
        @Nullable @NonNull @NonNull Pair pair = (Pair)this.counterWritersByKey.get(key);
        if (pair != null) {
            @NonNull DeviceType deviceType = (DeviceType)pair.first;
            @NonNull IAnalysisHardwareCounterWriter writer = (IAnalysisHardwareCounterWriter)pair.second;
            writer.consumerCounterValue(this.peReferenceSet.get(deviceType, this.vmUID, core), timestamp, null, value);
        }
    }

    public long getDuration() {
        return this.lastTimestamp - this.firstTimestamp;
    }

    public long getMonotonicRawBase() {
        return 0L;
    }

    public long getVmEndTimestamp() {
        return this.lastTimestamp;
    }

    public @Nullable String getVmName() {
        return null;
    }

    public long getVmStartTimestamp() {
        return this.firstTimestamp;
    }

    @Override
    public void idle(long timestamp, int core, boolean idle) throws IOException {
        timestamp = this.checkTimestamp(timestamp);
        this.idleStateWriter.consumeIdleEvent(this.peReferenceSet.get(DeviceType.CPU, this.vmUID, core), timestamp, idle ? IdleState.IDLE : IdleState.ONLINE);
    }

    public boolean isAnyTimesSeen() {
        return !this.first;
    }

    public boolean isApplicationTracingMode() {
        return false;
    }

    @Override
    public void schedSwitch(long timestamp, int core, int taskId, int reason) throws IOException {
        timestamp = this.checkTimestamp(timestamp);
        @NonNull IBarmanUniqueThread utid = this.uniqueThreadTracker.map(timestamp, taskId);
        this.schedulerTraceWriter.consumeSchedSwitch(this.peReferenceSet.get(DeviceType.CPU, this.vmUID, core), (IUniqueThreadID)utid, timestamp, reason);
    }

    @Override
    public void warning(long timestamp, int taskId, @NonNull WarningItem warningItem) throws IOException {
        timestamp = this.checkTimestamp(timestamp);
        @NonNull IBarmanUniqueThread utid = this.uniqueThreadTracker.map(timestamp, taskId);
        this.annotationsWriter.consumeAnnotationMarker((IUniqueThreadID)utid, timestamp, 0xFF0000, warningItem.getTitle() + ": " + warningItem.getDescription());
        this.warning(warningItem);
    }

    @Override
    public void warning(@NonNull WarningItem warningItem) throws IOException {
        this.warningHandler.accept(warningItem);
    }

    private long checkTimestamp(long timestamp) {
        long result = timestamp - this.earliestGlobalTimestamp;
        assert (this.first || this.lastTimestamp <= result);
        if (this.first) {
            this.firstTimestamp = result;
            this.first = false;
        }
        this.lastTimestamp = result;
        return result;
    }
}

