/*
 * Decompiled with CFR 0.152.
 */
package com.arm.util.tree;

import com.arm.util.HexNumberHelper;
import com.arm.util.Unsigned;
import com.arm.util.tree.IInterval;

public class UnsignedLongInterval
implements IInterval<Long> {
    private final long start;
    private final long end;

    public UnsignedLongInterval(long start, long end) {
        this.start = start;
        this.end = end;
        if (Unsigned.less64(this.end, this.start)) {
            String error = "end < start: " + end + " < " + start;
            throw new IllegalArgumentException(error);
        }
    }

    @Override
    public Long getStart() {
        return this.start;
    }

    @Override
    public Long getEnd() {
        return this.end;
    }

    @Override
    public boolean contains(Long point) {
        return Unsigned.lessOrEq64(this.start, point) && Unsigned.greaterOrEq64(this.end, point);
    }

    @Override
    public boolean overlaps(IInterval<Long> interval) {
        return !Unsigned.less64(interval.getEnd(), this.start) && !Unsigned.less64(this.getEnd(), interval.getStart());
    }

    @Override
    public int compareTo(IInterval<Long> interval) {
        long implStart = interval.getStart();
        long implEnd = interval.getEnd();
        int compareStart = Long.compareUnsigned(this.start, implStart);
        if (compareStart != 0) {
            return compareStart;
        }
        return Long.compareUnsigned(this.end, implEnd);
    }

    @Override
    public int compareComponents(Long c1, Long c2) {
        return Long.compareUnsigned(c1, c2);
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (int)(this.end ^ this.end >>> 32);
        result = 31 * result + (int)(this.start ^ this.start >>> 32);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        UnsignedLongInterval other = (UnsignedLongInterval)obj;
        if (this.end != other.end) {
            return false;
        }
        return this.start == other.start;
    }

    public String toString() {
        String hexStart = HexNumberHelper.longToHexString(this.start);
        String hexEnd = HexNumberHelper.longToHexString(this.end);
        return String.format("[%s; %s]", hexStart, hexEnd);
    }

    public UnsignedLongInterval intersect(IInterval<Long> a) {
        if (a.equals(this)) {
            return this;
        }
        if (!a.overlaps(this)) {
            return null;
        }
        long newStart = Unsigned.max64(a.getStart(), this.getStart());
        long newEnd = Unsigned.min64(a.getEnd(), this.getEnd());
        return new UnsignedLongInterval(newStart, newEnd);
    }
}

