/*
 * Decompiled with CFR 0.152.
 */
package com.arm.util.tree;

import com.arm.util.tree.IInterval;
import com.arm.util.tree.LLRBTree;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;

public class OverlappingIntervalTree<Point extends Comparable<Point>, Value> {
    private final OverlappingLLRBTree<Point> tree = new OverlappingLLRBTree();
    private int size;

    public void add(IInterval<Point> interval, Value value, boolean unique) {
        Object[] values = (Object[])this.tree.get(interval);
        if (values == null) {
            values = new Object[]{value};
            this.tree.put(interval, values);
            ++this.size;
        } else {
            this.update(interval, this.add(values, value, unique));
        }
    }

    protected LLRBTree.Node<IInterval<Point>, Object[]> createNode(IInterval<Point> interval, Object[] value) {
        return new LLRBTree.Node<IInterval<Point>, Object[]>(interval, value);
    }

    public void remove(IInterval<Point> interval, Value value) {
        Object[] values = (Object[])this.tree.get(interval);
        if (values != null) {
            this.update(interval, this.remove(values, value));
        }
    }

    public int size() {
        return this.size;
    }

    public Set<Value> find(Point point) {
        HashSet result = new HashSet();
        this.search(this.tree.getRoot(), point, result);
        return result;
    }

    public Collection<Entry<Value, Point>> findWithRange(Point point) {
        HashSet<LLRBTree.Node<IInterval<Point>, Object[]>> nodes = new HashSet<LLRBTree.Node<IInterval<Point>, Object[]>>();
        this.searchWithNode(this.tree.getRoot(), point, nodes);
        ArrayList<Entry<Value, Point>> result = new ArrayList<Entry<Value, Point>>(nodes.size());
        for (LLRBTree.Node node : nodes) {
            Object[] objectArray = (Object[])node.value;
            int n = objectArray.length;
            int n2 = 0;
            while (n2 < n) {
                Object v = objectArray[n2];
                result.add(new Entry(v, (IInterval)node.key));
                ++n2;
            }
        }
        return result;
    }

    public Set<Value> findNearestLeft(Point point) {
        HashSet result = new HashSet();
        LLRBTree.Node<IInterval<Point>, Object[]> foundNode = this.searchNearest(this.tree.getRoot(), point);
        if (foundNode != null) {
            this.searchStartsWith(this.tree.getRoot(), ((IInterval)foundNode.key).getStart(), result);
        }
        return result;
    }

    private void update(IInterval<Point> interval, Object[] newValues) {
        if (newValues != null) {
            if (newValues.length == 0) {
                this.tree.remove(interval);
            } else {
                this.tree.put(interval, newValues);
            }
        }
    }

    private void searchWithNode(LLRBTree.Node<IInterval<Point>, Object[]> node, Point point, Set<LLRBTree.Node<IInterval<Point>, Object[]>> result) {
        if (node == null) {
            return;
        }
        Object rightmost = ((OverlappingLLRBTree.OverlappingNode)node).getMaximumEnd();
        if (point.compareTo(rightmost) > 0) {
            return;
        }
        this.searchWithNode(node.left, point, result);
        if (((IInterval)node.key).contains(point)) {
            result.add(node);
        }
        if (point.compareTo(((IInterval)node.key).getStart()) < 0) {
            return;
        }
        this.searchWithNode(node.right, point, result);
    }

    private void search(LLRBTree.Node<IInterval<Point>, Object[]> node, Point point, Set<Value> result) {
        if (node == null) {
            return;
        }
        Object rightmost = ((OverlappingLLRBTree.OverlappingNode)node).getMaximumEnd();
        if (point.compareTo(rightmost) > 0) {
            return;
        }
        this.search(node.left, point, result);
        if (((IInterval)node.key).contains(point)) {
            Object[] objectArray = (Object[])node.value;
            int n = objectArray.length;
            int n2 = 0;
            while (n2 < n) {
                Object value = objectArray[n2];
                result.add(value);
                ++n2;
            }
        }
        if (point.compareTo(((IInterval)node.key).getStart()) < 0) {
            return;
        }
        this.search(node.right, point, result);
    }

    private LLRBTree.Node<IInterval<Point>, Object[]> searchNearest(LLRBTree.Node<IInterval<Point>, Object[]> node, Point point) {
        if (node == null) {
            return null;
        }
        LLRBTree.Node<IInterval<Point>, Object[]> found = null;
        if (point.compareTo(((IInterval)node.key).getStart()) == 0) {
            found = node;
        } else if (point.compareTo(((IInterval)node.key).getStart()) < 0) {
            found = this.searchNearest(node.left, point);
            if (found == null) {
                found = this.searchNearest(node.right, point);
            }
        } else {
            found = this.searchNearest(node.right, point);
            if (found == null) {
                found = this.searchNearest(node.left, point);
            }
            if (found == null || ((IInterval)found.key).getStart().compareTo(((IInterval)node.key).getStart()) < 0) {
                found = node;
            }
        }
        return found;
    }

    private void searchStartsWith(LLRBTree.Node<IInterval<Point>, Object[]> node, Point start, Set<Value> result) {
        if (node == null) {
            return;
        }
        if (start.compareTo(((IInterval)node.key).getStart()) == 0) {
            Object[] objectArray = (Object[])node.value;
            int n = objectArray.length;
            int n2 = 0;
            while (n2 < n) {
                Object value = objectArray[n2];
                result.add(value);
                ++n2;
            }
            this.searchStartsWith(node.left, start, result);
            this.searchStartsWith(node.right, start, result);
        } else if (start.compareTo(((IInterval)node.key).getStart()) < 0) {
            this.searchStartsWith(node.left, start, result);
        } else {
            this.searchStartsWith(node.right, start, result);
        }
    }

    private int indexOf(Object[] values, Object value) {
        int i = 0;
        while (i < values.length) {
            if (value.equals(values[i])) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    private Object[] add(Object[] values, Value value, boolean unique) {
        if (unique || this.indexOf(values, value) == -1) {
            int newLength = values.length + 1;
            Object[] newValues = new Object[newLength];
            System.arraycopy(values, 0, newValues, 0, values.length);
            newValues[values.length] = value;
            ++this.size;
            return newValues;
        }
        return null;
    }

    private Object[] remove(Object[] values, Value value) {
        int index = this.indexOf(values, value);
        if (index == -1) {
            return null;
        }
        int newLength = values.length - 1;
        values[index] = values[newLength];
        Object[] newValues = new Object[newLength];
        System.arraycopy(values, 0, newValues, 0, newLength);
        --this.size;
        return newValues;
    }

    void setChecked() {
        this.tree.checkTree(true);
    }

    public static final class Entry<Value, Point extends Comparable<Point>> {
        public final Value v;
        public final IInterval<Point> key;

        public Entry(Value v, IInterval<Point> key) {
            this.v = v;
            this.key = key;
        }
    }

    static class OverlappingLLRBTree<Point extends Comparable<Point>>
    extends LLRBTree<IInterval<Point>, Object[]> {
        OverlappingLLRBTree() {
        }

        @Override
        protected LLRBTree.Node<IInterval<Point>, Object[]> createNode(IInterval<Point> interval, Object[] value) {
            return new OverlappingNode<Point>(interval, value);
        }

        public static class OverlappingNode<Point extends Comparable<Point>>
        extends LLRBTree.Node<IInterval<Point>, Object[]> {
            private Point maxEnd = null;

            OverlappingNode(IInterval<Point> interval, Object[] value) {
                super(interval, value);
            }

            Point getMaximumEnd() {
                if (this.maxEnd == null) {
                    Point maxRight;
                    Point maxLeft;
                    Object end = ((IInterval)this.key).getEnd();
                    if (end == null) {
                        end = ((IInterval)this.key).getStart();
                    }
                    if (this.left != null && end.compareTo(maxLeft = ((OverlappingNode)this.left).getMaximumEnd()) < 0) {
                        end = maxLeft;
                    }
                    if (this.right != null && end.compareTo(maxRight = ((OverlappingNode)this.right).getMaximumEnd()) < 0) {
                        end = maxRight;
                    }
                    this.maxEnd = end;
                }
                return this.maxEnd;
            }

            @Override
            void changed() {
                this.maxEnd = null;
            }
        }
    }
}

