/*
 * Decompiled with CFR 0.152.
 */
package com.arm.util.tree;

public class LLRBUnsignedInt32IntervalTree<Value> {
    private Node<Value> root;
    private int size;
    private boolean checkTree;

    void checkTree(boolean checkTree) {
        this.checkTree = checkTree;
    }

    protected Node<Value> getRoot() {
        return this.root;
    }

    public int size() {
        return this.size;
    }

    public boolean isEmpty() {
        return this.root == null;
    }

    public boolean contains(long start, long end) {
        return this.get(this.root, start & 0xFFFFFFFFL, end & 0xFFFFFFFFL) != null;
    }

    public Value get(long start, long end) {
        return this.get(this.root, start & 0xFFFFFFFFL, end & 0xFFFFFFFFL);
    }

    private Value get(Node<Value> x, long start, long end) {
        return x == null ? null : (start == x.start && end == x.end ? (Value)x.value : (start <= x.start && (start != x.start || end < x.end) ? (Value)this.get(x.left, start, end) : (Value)this.get(x.right, start, end)));
    }

    public Node<Value> min() {
        return this.root == null ? null : this.min(this.root);
    }

    private Node<Value> min(Node<Value> x) {
        return x.left == null ? x : this.min(x.left);
    }

    public Node<Value> max() {
        return this.root == null ? null : this.max(this.root);
    }

    protected Node<Value> max(Node<Value> x) {
        return x.right == null ? x : this.max(x.right);
    }

    public void put(long start, long end, Value value) {
        this.root = this.insert(this.root, start & 0xFFFFFFFFL, end & 0xFFFFFFFFL, value);
        this.root.isRed = false;
        if (this.checkTree) {
            this.check();
        }
    }

    private Node<Value> insert(Node<Value> h, long start, long end, Value value) {
        if (h == null) {
            ++this.size;
            return this.createNode(start, end, value);
        }
        h.changed();
        if (start == h.start && end == h.end) {
            h.value = value;
        } else if (start <= h.start && (start != h.start || end < h.end)) {
            h.left = this.insert(h.left, start, end, value);
        } else {
            h.right = this.insert(h.right, start, end, value);
        }
        if (this.isRed(h.right)) {
            h = this.rotateLeft(h);
        }
        if (this.isRed(h.left) && this.isRed(h.left.left)) {
            h = this.rotateRight(h);
        }
        if (this.isRed(h.left) && this.isRed(h.right)) {
            this.colorFlip(h);
        }
        return h;
    }

    protected Node<Value> createNode(long start, long end, Value value) {
        return new Node<Value>(start & 0xFFFFFFFFL, end & 0xFFFFFFFFL, value);
    }

    public void removeMin() {
        if (this.root != null) {
            this.root = this.removeMin(this.root);
            if (this.root != null) {
                this.root.isRed = false;
            }
        }
    }

    private Node<Value> removeMin(Node<Value> h) {
        if (h.left == null) {
            --this.size;
            return null;
        }
        if (!this.isRed(h.left) && !this.isRed(h.left.left)) {
            h = this.moveRedLeft(h);
        }
        h.left = this.removeMin(h.left);
        return this.fixUp(h);
    }

    public void removeMax() {
        if (this.root != null) {
            this.root = this.removeMax(this.root);
            if (this.root != null) {
                this.root.isRed = false;
            }
        }
    }

    private Node<Value> removeMax(Node<Value> h) {
        if (this.isRed(h.left)) {
            h = this.rotateRight(h);
        }
        if (h.right == null) {
            --this.size;
            return null;
        }
        if (!this.isRed(h.right) && !this.isRed(h.right.left)) {
            h = this.moveRedRight(h);
        }
        h.right = this.removeMax(h.right);
        return this.fixUp(h);
    }

    public void remove(long start, long end) {
        if (this.root != null) {
            this.root = this.remove(this.root, start & 0xFFFFFFFFL, end & 0xFFFFFFFFL);
            if (this.root != null) {
                this.root.isRed = false;
            }
            if (this.checkTree) {
                this.check();
            }
        }
    }

    private Node<Value> remove(Node<Value> h, long start, long end) {
        if (h == null) {
            return null;
        }
        h.changed();
        if (start <= h.start && (start != h.start || end < h.end)) {
            if (!this.isRed(h.left) && h.left != null && !this.isRed(h.left.left)) {
                h = this.moveRedLeft(h);
            }
            h.left = this.remove(h.left, start, end);
        } else {
            if (this.isRed(h.left)) {
                h = this.rotateRight(h);
            }
            if (start == h.start && end == h.end && h.right == null) {
                --this.size;
                return null;
            }
            if (!this.isRed(h.right) && h.right != null && !this.isRed(h.right.left)) {
                h = this.moveRedRight(h);
            }
            if (start == h.start && end == h.end) {
                Node min = this.min(h.right);
                h.value = this.get(h.right, min.start, min.end);
                h.start = min.start;
                h.end = min.end;
                h.right = this.removeMin(h.right);
            } else {
                h.right = this.remove(h.right, start, end);
            }
        }
        return this.fixUp(h);
    }

    private boolean isRed(Node<Value> x) {
        return x == null ? false : x.isRed;
    }

    private void colorFlip(Node<Value> h) {
        h.isRed = !h.isRed;
        h.left.isRed = !h.left.isRed;
        h.right.isRed = !h.right.isRed;
    }

    private Node<Value> rotateLeft(Node<Value> h) {
        Node x = h.right;
        h.right = x.left;
        x.left = h;
        x.isRed = x.left.isRed;
        x.left.isRed = true;
        x.changed();
        h.changed();
        return x;
    }

    private Node<Value> rotateRight(Node<Value> h) {
        Node x = h.left;
        h.left = x.right;
        x.right = h;
        x.isRed = x.right.isRed;
        x.right.isRed = true;
        x.changed();
        h.changed();
        return x;
    }

    private Node<Value> moveRedLeft(Node<Value> h) {
        this.colorFlip(h);
        if (this.isRed(h.right.left)) {
            h.right = this.rotateRight(h.right);
            h = this.rotateLeft(h);
            this.colorFlip(h);
        }
        return h;
    }

    private Node<Value> moveRedRight(Node<Value> h) {
        this.colorFlip(h);
        if (this.isRed(h.left.left)) {
            h = this.rotateRight(h);
            this.colorFlip(h);
        }
        return h;
    }

    private Node<Value> fixUp(Node<Value> h) {
        if (this.isRed(h.right)) {
            h = this.rotateLeft(h);
        }
        if (this.isRed(h.left) && this.isRed(h.left.left)) {
            h = this.rotateRight(h);
        }
        if (this.isRed(h.left) && this.isRed(h.right)) {
            this.colorFlip(h);
        }
        return h;
    }

    void check() {
        if (!(this.isBST() && this.is234() && this.isBalanced())) {
            throw new RuntimeException("tree integrity checks failed");
        }
    }

    private boolean isBST() {
        return this.isBST(this.root, this.min(), this.max());
    }

    private boolean isBST(Node<Value> x, Node<Value> min, Node<Value> max) {
        if (x == null) {
            return true;
        }
        if (x.start <= min.start && (x.start != min.start || x.end < min.end) || max.start <= x.start && (max.start != x.start || max.end < x.end)) {
            return false;
        }
        return this.isBST(x.left, min, x) && this.isBST(x.right, x, max);
    }

    private boolean is234() {
        return this.is234(this.root);
    }

    private boolean is234(Node<Value> x) {
        if (x == null) {
            return true;
        }
        if (this.isRed(x.right)) {
            return false;
        }
        if (this.isRed(x) && this.isRed(x.left) && this.isRed(x.left.left)) {
            return false;
        }
        return this.is234(x.left) && this.is234(x.right);
    }

    private boolean isBalanced() {
        int black = 0;
        Node<Value> x = this.root;
        while (x != null) {
            if (!this.isRed(x)) {
                ++black;
            }
            x = x.left;
        }
        return this.isBalanced(this.root, black);
    }

    private boolean isBalanced(Node<Value> x, int black) {
        if (x == null && black == 0) {
            return true;
        }
        if (x == null && black != 0) {
            return false;
        }
        if (!this.isRed(x)) {
            --black;
        }
        return x != null && this.isBalanced(x.left, black) && this.isBalanced(x.right, black);
    }

    protected static class Node<Value> {
        long start;
        long end;
        Value value;
        Node<Value> left;
        Node<Value> right;
        boolean isRed = true;

        Node(long start, long end, Value value) {
            this.start = 0xFFFFFFFFL & start;
            this.end = 0xFFFFFFFFL & end;
            this.value = value;
        }

        void changed() {
        }
    }
}

