/*
 * Decompiled with CFR 0.152.
 */
package com.arm.util.tree;

public class LLRBTree<Key extends Comparable<Key>, Value> {
    private Node<Key, Value> root;
    private int size;
    private boolean checkTree;

    void checkTree(boolean checkTree) {
        this.checkTree = checkTree;
    }

    protected Node<Key, Value> getRoot() {
        return this.root;
    }

    public int size() {
        return this.size;
    }

    public boolean isEmpty() {
        return this.root == null;
    }

    public boolean contains(Key key) {
        return this.get(this.root, key) != null;
    }

    public Value get(Key key) {
        return this.get(this.root, key);
    }

    private Value get(Node<Key, Value> x, Key key) {
        return x == null ? null : (this.eq(key, (Comparable)x.key) ? (Value)x.value : (this.less(key, (Comparable)x.key) ? (Value)this.get(x.left, key) : (Value)this.get(x.right, key)));
    }

    public Node<Key, Value> min() {
        return this.root == null ? null : this.min(this.root);
    }

    private Node<Key, Value> min(Node<Key, Value> x) {
        return x.left == null ? x : this.min(x.left);
    }

    public Node<Key, Value> max() {
        return this.root == null ? null : this.max(this.root);
    }

    protected Node<Key, Value> max(Node<Key, Value> x) {
        return x.right == null ? x : this.max(x.right);
    }

    public void put(Key key, Value value) {
        this.root = this.insert(this.root, key, value);
        this.root.isRed = false;
        if (this.checkTree) {
            this.check();
        }
    }

    private Node<Key, Value> insert(Node<Key, Value> h, Key key, Value value) {
        if (h == null) {
            ++this.size;
            return this.createNode(key, value);
        }
        h.changed();
        if (this.eq(key, (Comparable)h.key)) {
            h.value = value;
        } else if (this.less(key, (Comparable)h.key)) {
            h.left = this.insert(h.left, key, value);
        } else {
            h.right = this.insert(h.right, key, value);
        }
        if (this.isRed(h.right)) {
            h = this.rotateLeft(h);
        }
        if (this.isRed(h.left) && this.isRed(h.left.left)) {
            h = this.rotateRight(h);
        }
        if (this.isRed(h.left) && this.isRed(h.right)) {
            this.colorFlip(h);
        }
        return h;
    }

    protected Node<Key, Value> createNode(Key key, Value value) {
        return new Node<Key, Value>(key, value);
    }

    public void removeMin() {
        if (this.root != null) {
            this.root = this.removeMin(this.root);
            if (this.root != null) {
                this.root.isRed = false;
            }
        }
    }

    private Node<Key, Value> removeMin(Node<Key, Value> h) {
        if (h.left == null) {
            --this.size;
            return null;
        }
        if (!this.isRed(h.left) && !this.isRed(h.left.left)) {
            h = this.moveRedLeft(h);
        }
        h.left = this.removeMin(h.left);
        return this.fixUp(h);
    }

    public void removeMax() {
        if (this.root != null) {
            this.root = this.removeMax(this.root);
            if (this.root != null) {
                this.root.isRed = false;
            }
        }
    }

    private Node<Key, Value> removeMax(Node<Key, Value> h) {
        if (this.isRed(h.left)) {
            h = this.rotateRight(h);
        }
        if (h.right == null) {
            --this.size;
            return null;
        }
        if (!this.isRed(h.right) && !this.isRed(h.right.left)) {
            h = this.moveRedRight(h);
        }
        h.right = this.removeMax(h.right);
        return this.fixUp(h);
    }

    public void remove(Key key) {
        if (this.root != null) {
            this.root = this.remove(this.root, key);
            if (this.root != null) {
                this.root.isRed = false;
            }
            if (this.checkTree) {
                this.check();
            }
        }
    }

    private Node<Key, Value> remove(Node<Key, Value> h, Key key) {
        if (h == null) {
            return null;
        }
        h.changed();
        if (this.less(key, (Comparable)h.key)) {
            if (!this.isRed(h.left) && h.left != null && !this.isRed(h.left.left)) {
                h = this.moveRedLeft(h);
            }
            h.left = this.remove(h.left, key);
        } else {
            if (this.isRed(h.left)) {
                h = this.rotateRight(h);
            }
            if (this.eq(key, (Comparable)h.key) && h.right == null) {
                --this.size;
                return null;
            }
            if (!this.isRed(h.right) && h.right != null && !this.isRed(h.right.left)) {
                h = this.moveRedRight(h);
            }
            if (this.eq(key, (Comparable)h.key)) {
                Node min = this.min(h.right);
                h.value = this.get(h.right, (Comparable)min.key);
                h.key = (Comparable)min.key;
                h.right = this.removeMin(h.right);
            } else {
                h.right = this.remove(h.right, key);
            }
        }
        return this.fixUp(h);
    }

    private boolean eq(Key a, Key b) {
        return a.compareTo(b) == 0;
    }

    private boolean less(Key a, Key b) {
        return a.compareTo(b) < 0;
    }

    private boolean isRed(Node<Key, Value> x) {
        return x == null ? false : x.isRed;
    }

    private void colorFlip(Node<Key, Value> h) {
        h.isRed = !h.isRed;
        h.left.isRed = !h.left.isRed;
        h.right.isRed = !h.right.isRed;
    }

    private Node<Key, Value> rotateLeft(Node<Key, Value> h) {
        Node x = h.right;
        h.right = x.left;
        x.left = h;
        x.isRed = x.left.isRed;
        x.left.isRed = true;
        x.changed();
        h.changed();
        return x;
    }

    private Node<Key, Value> rotateRight(Node<Key, Value> h) {
        Node x = h.left;
        h.left = x.right;
        x.right = h;
        x.isRed = x.right.isRed;
        x.right.isRed = true;
        x.changed();
        h.changed();
        return x;
    }

    private Node<Key, Value> moveRedLeft(Node<Key, Value> h) {
        this.colorFlip(h);
        if (this.isRed(h.right.left)) {
            h.right = this.rotateRight(h.right);
            h = this.rotateLeft(h);
            this.colorFlip(h);
        }
        return h;
    }

    private Node<Key, Value> moveRedRight(Node<Key, Value> h) {
        this.colorFlip(h);
        if (this.isRed(h.left.left)) {
            h = this.rotateRight(h);
            this.colorFlip(h);
        }
        return h;
    }

    private Node<Key, Value> fixUp(Node<Key, Value> h) {
        if (this.isRed(h.right)) {
            h = this.rotateLeft(h);
        }
        if (this.isRed(h.left) && this.isRed(h.left.left)) {
            h = this.rotateRight(h);
        }
        if (this.isRed(h.left) && this.isRed(h.right)) {
            this.colorFlip(h);
        }
        return h;
    }

    void check() {
        if (!(this.isBST() && this.is234() && this.isBalanced())) {
            throw new RuntimeException("tree integrity checks failed");
        }
    }

    private boolean isBST() {
        return this.isBST(this.root, this.min(), this.max());
    }

    private boolean isBST(Node<Key, Value> x, Node<Key, Value> min, Node<Key, Value> max) {
        if (x == null) {
            return true;
        }
        if (this.less((Comparable)x.key, (Comparable)min.key) || this.less((Comparable)max.key, (Comparable)x.key)) {
            return false;
        }
        return this.isBST(x.left, min, x) && this.isBST(x.right, x, max);
    }

    private boolean is234() {
        return this.is234(this.root);
    }

    private boolean is234(Node<Key, Value> x) {
        if (x == null) {
            return true;
        }
        if (this.isRed(x.right)) {
            return false;
        }
        if (this.isRed(x) && this.isRed(x.left) && this.isRed(x.left.left)) {
            return false;
        }
        return this.is234(x.left) && this.is234(x.right);
    }

    private boolean isBalanced() {
        int black = 0;
        Node<Key, Value> x = this.root;
        while (x != null) {
            if (!this.isRed(x)) {
                ++black;
            }
            x = x.left;
        }
        return this.isBalanced(this.root, black);
    }

    private boolean isBalanced(Node<Key, Value> x, int black) {
        if (x == null && black == 0) {
            return true;
        }
        if (x == null && black != 0) {
            return false;
        }
        if (!this.isRed(x)) {
            --black;
        }
        return x != null && this.isBalanced(x.left, black) && this.isBalanced(x.right, black);
    }

    protected static class Node<Key, Value> {
        Key key;
        Value value;
        Node<Key, Value> left;
        Node<Key, Value> right;
        boolean isRed = true;

        Node(Key key, Value value) {
            this.key = key;
            this.value = value;
        }

        void changed() {
        }
    }
}

