/*
 * Decompiled with CFR 0.152.
 */
package com.arm.util.tree;

import com.arm.util.tree.RedBlackTreeStorage;

public class BulkAllocationRedBlackTree<V> {
    public static final int INVALID_NODE = -1;
    private final RedBlackTreeStorage<V> storage;
    private int root;
    private int size;

    public BulkAllocationRedBlackTree() {
        this(new RedBlackTreeStorage());
    }

    public BulkAllocationRedBlackTree(RedBlackTreeStorage<V> storage) {
        this.storage = storage;
        this.root = -1;
        this.size = 0;
    }

    public int getRoot() {
        return this.root;
    }

    public int size() {
        return this.size;
    }

    public void put(int key, V value) {
        int node = this.allocateNewNode(key, value);
        int n = this.root;
        if (n == -1) {
            this.setRoot(node);
        } else {
            block6: {
                while (true) {
                    int nKey;
                    if (key < (nKey = this.storage.getKey(n))) {
                        int nLeft = this.storage.getLeft(n);
                        if (nLeft == -1) {
                            this.storage.setLeft(n, node);
                            break block6;
                        }
                        n = nLeft;
                        continue;
                    }
                    if (key <= nKey) break;
                    int nRight = this.storage.getRight(n);
                    if (nRight == -1) {
                        this.storage.setRight(n, node);
                        break block6;
                    }
                    n = nRight;
                }
                this.storage.setValue(n, value);
                ++this.size;
                return;
            }
            this.storage.setParent(node, n);
        }
        this.insertCase1(node);
        ++this.size;
    }

    public void remove(int key) {
        int child;
        int node = this.lookupNode(key);
        if (node == -1) {
            return;
        }
        if (this.storage.getLeft(node) != -1 && this.storage.getRight(node) != -1) {
            int pred = this.maximumNode(this.storage.getLeft(node));
            this.storage.setKey(node, this.storage.getKey(pred));
            this.storage.setValue(node, this.storage.getValue(pred));
            node = pred;
        }
        int n = child = this.storage.getRight(node) == -1 ? this.storage.getLeft(node) : this.storage.getRight(node);
        if (!this.storage.getRed(node)) {
            this.deleteCase1(node);
        }
        this.replaceNode(node, child);
        this.storage.deleteNode(node);
        --this.size;
    }

    protected int lookupNode(int key) {
        int node = this.root;
        while (node != -1) {
            int nodeRight;
            int nodeKey = this.storage.getKey(node);
            if (key == nodeKey) break;
            int nodeLeft = this.storage.getLeft(node);
            node = nodeLeft != -1 && key <= nodeKey ? nodeLeft : ((nodeRight = this.storage.getRight(node)) != -1 && key >= nodeKey ? nodeRight : -1);
        }
        return node;
    }

    public int lookupPreviousNode(int key) {
        int node = this.root;
        while (node != -1) {
            int nodeKey = this.storage.getKey(node);
            int nodeLeft = this.storage.getLeft(node);
            if (nodeLeft != -1 && key < nodeKey) {
                node = nodeLeft;
                continue;
            }
            int nodeRight = this.storage.getRight(node);
            if (nodeRight != -1 && key > nodeKey) {
                node = nodeRight;
                continue;
            }
            if (nodeKey < key) {
                return node;
            }
            return this.getPrevious(node);
        }
        return -1;
    }

    private int getPrevious(int node) {
        int predecessor = -1;
        if (this.storage.getLeft(node) == -1) {
            predecessor = this.storage.getParent(node);
            while (predecessor != -1 && this.storage.getKey(predecessor) > this.storage.getKey(node)) {
                predecessor = this.storage.getParent(predecessor);
            }
            return predecessor;
        }
        predecessor = this.storage.getLeft(node);
        while (this.storage.getRight(predecessor) != -1) {
            predecessor = this.storage.getRight(predecessor);
        }
        return predecessor;
    }

    public V get(int key) {
        int node = this.lookupNode(key);
        return node == -1 ? null : (V)this.storage.getValue(node);
    }

    private boolean nodeIsRed(int node) {
        return node == -1 ? false : this.storage.getRed(node);
    }

    private boolean nodeIsBlack(int node) {
        return node == -1 ? true : !this.storage.getRed(node);
    }

    private void insertCase1(int node) {
        if (this.storage.getParent(node) == -1) {
            this.storage.setRed(node, false);
        } else {
            this.insertCase2(node);
        }
    }

    private void insertCase2(int node) {
        if (this.storage.getParent(node) != -1 && this.nodeIsRed(this.storage.getParent(node))) {
            this.insertCase3(node);
        }
    }

    private void insertCase3(int node) {
        if (this.nodeIsRed(this.uncle(node))) {
            this.storage.setRed(this.storage.getParent(node), false);
            this.storage.setRed(this.uncle(node), false);
            this.storage.setRed(this.grandParent(node), true);
            this.insertCase1(this.grandParent(node));
        } else {
            this.insertCase4(node);
        }
    }

    private void insertCase4(int node) {
        int nodeParent = this.storage.getParent(node);
        if (node == this.storage.getRight(nodeParent) && nodeParent == this.storage.getLeft(this.grandParent(node))) {
            this.rotateLeft(nodeParent);
            node = this.storage.getLeft(node);
        } else if (node == this.storage.getLeft(nodeParent) && nodeParent == this.storage.getRight(this.grandParent(node))) {
            this.rotateRight(nodeParent);
            node = this.storage.getRight(node);
        }
        this.insertCase5(node);
    }

    private void insertCase5(int node) {
        int nodeParent = this.storage.getParent(node);
        int nodeGrandParent = this.grandParent(node);
        this.storage.setRed(nodeParent, false);
        this.storage.setRed(nodeGrandParent, true);
        if (node == this.storage.getLeft(nodeParent) && nodeParent == this.storage.getLeft(nodeGrandParent)) {
            this.rotateRight(nodeGrandParent);
        } else {
            this.rotateLeft(nodeGrandParent);
        }
    }

    private int maximumNode(int node) {
        while (this.storage.getRight(node) != -1) {
            node = this.storage.getRight(node);
        }
        return node;
    }

    private void deleteCase1(int node) {
        if (this.storage.getParent(node) != -1) {
            this.deleteCase2(node);
        }
    }

    private void deleteCase2(int node) {
        int nodeParent = this.storage.getParent(node);
        int nodeSibling = this.sibling(node);
        if (this.nodeIsRed(nodeSibling)) {
            this.storage.setRed(nodeParent, true);
            this.storage.setRed(nodeSibling, false);
            if (node == this.storage.getLeft(nodeParent)) {
                this.rotateLeft(nodeParent);
            } else {
                this.rotateRight(nodeParent);
            }
        }
        this.deleteCase3(node);
    }

    private void deleteCase3(int node) {
        int nodeParent = this.storage.getParent(node);
        int nodeSibling = this.sibling(node);
        if (this.nodeIsBlack(nodeParent) && this.nodeIsBlack(nodeSibling) && this.nodeIsBlack(this.storage.getLeft(nodeSibling)) && this.nodeIsBlack(this.storage.getRight(nodeSibling))) {
            this.storage.setRed(nodeSibling, true);
            this.deleteCase1(nodeParent);
        } else {
            this.deleteCase4(node);
        }
    }

    private void deleteCase4(int node) {
        int nodeParent = this.storage.getParent(node);
        int nodeSibling = this.sibling(node);
        if (this.nodeIsRed(nodeParent) && this.nodeIsBlack(this.sibling(node)) && this.nodeIsBlack(this.storage.getLeft(nodeSibling)) && this.nodeIsBlack(this.storage.getRight(nodeSibling))) {
            this.storage.setRed(nodeSibling, true);
            this.storage.setRed(nodeParent, false);
        } else {
            this.deleteCase5(node);
        }
    }

    private void deleteCase5(int node) {
        int nodeParent = this.storage.getParent(node);
        int nodeSibling = this.sibling(node);
        if (node == this.storage.getLeft(nodeParent) && this.nodeIsBlack(nodeSibling) && this.nodeIsRed(this.storage.getLeft(nodeSibling)) && this.nodeIsBlack(this.storage.getRight(nodeSibling))) {
            this.storage.setRed(nodeSibling, true);
            this.storage.setRed(this.storage.getLeft(nodeSibling), false);
            this.rotateRight(nodeSibling);
        } else if (node == this.storage.getRight(nodeParent) && this.nodeIsBlack(nodeSibling) && this.nodeIsRed(this.storage.getRight(nodeSibling)) && this.nodeIsBlack(this.storage.getLeft(nodeSibling))) {
            this.storage.setRed(nodeSibling, true);
            this.storage.setRed(this.storage.getRight(nodeSibling), false);
            this.rotateLeft(nodeSibling);
        }
        this.deleteCase6(node);
    }

    private void deleteCase6(int node) {
        int nodeParent = this.storage.getParent(node);
        int nodeSibling = this.sibling(node);
        this.storage.setRed(nodeSibling, this.nodeIsRed(nodeParent));
        this.storage.setRed(nodeParent, false);
        if (node == this.storage.getLeft(nodeParent)) {
            this.storage.setRed(this.storage.getRight(nodeSibling), false);
            this.rotateLeft(nodeParent);
        } else {
            this.storage.setRed(this.storage.getLeft(nodeSibling), false);
            this.rotateRight(nodeParent);
        }
    }

    private void rotateLeft(int node) {
        int nodeRight = this.storage.getRight(node);
        this.replaceNode(node, nodeRight);
        int nodeLeft = this.storage.getLeft(nodeRight);
        this.storage.setRight(node, nodeLeft);
        if (nodeLeft != -1) {
            this.storage.setParent(nodeLeft, node);
        }
        this.storage.setLeft(nodeRight, node);
        this.storage.setParent(node, nodeRight);
    }

    private void rotateRight(int node) {
        int nodeLeft = this.storage.getLeft(node);
        this.replaceNode(node, nodeLeft);
        int nodeRight = this.storage.getRight(nodeLeft);
        this.storage.setLeft(node, nodeRight);
        if (nodeRight != -1) {
            this.storage.setParent(nodeRight, node);
        }
        this.storage.setRight(nodeLeft, node);
        this.storage.setParent(node, nodeLeft);
    }

    private void replaceNode(int oldNode, int newNode) {
        int oldNodeParent = this.storage.getParent(oldNode);
        if (oldNodeParent == -1) {
            this.root = newNode;
        } else if (oldNode == this.storage.getLeft(oldNodeParent)) {
            this.storage.setLeft(oldNodeParent, newNode);
        } else {
            this.storage.setRight(oldNodeParent, newNode);
        }
        if (newNode != -1) {
            this.storage.setParent(newNode, oldNodeParent);
            if (oldNodeParent == -1) {
                this.storage.setRed(newNode, false);
            }
        }
    }

    private void setRoot(int root) {
        this.root = root;
    }

    public int allocateNewNode(int key, V value) {
        int node = this.storage.allocateNode(key, value);
        this.storage.setRed(node, true);
        return node;
    }

    protected boolean isRed(int node) {
        return this.storage.getRed(node);
    }

    public int getKey(int node) {
        return this.storage.getKey(node);
    }

    public V getValue(int node) {
        return this.storage.getValue(node);
    }

    protected int getLeft(int node) {
        return this.storage.getLeft(node);
    }

    protected int getRight(int node) {
        return this.storage.getRight(node);
    }

    private int grandParent(int node) {
        return this.storage.getParent(this.storage.getParent(node));
    }

    private int sibling(int node) {
        int parent = this.storage.getParent(node);
        if (parent == -1) {
            return -1;
        }
        if (node == this.storage.getLeft(parent)) {
            return this.storage.getRight(parent);
        }
        return this.storage.getLeft(parent);
    }

    private int uncle(int node) {
        int nodeParent = this.storage.getParent(node);
        if (nodeParent == -1) {
            return -1;
        }
        return this.sibling(nodeParent);
    }
}

