/*
 * Decompiled with CFR 0.152.
 */
package com.arm.util.preprocessor;

import com.arm.util.preprocessor.JavaTokenizer;
import com.arm.util.preprocessor.Token;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class PreProcessor {
    private static final Pattern EXP_PATTERN = Pattern.compile("([A-Za-z0-9_]+)(?:\\(([^)]*)\\))?");

    public static void main(String[] args) throws IOException {
        if (args.length < 2) {
            throw new IOException("Insufficient arguments supplied");
        }
        if (args.length % 2 != 0) {
            throw new IOException("Key without argument supplied");
        }
        File source = new File(args[0]);
        if (!source.exists()) {
            throw new IOException("File " + source + " does not exist");
        }
        File dest = new File(args[1]);
        HashMap<String, Expansion> defines = new HashMap<String, Expansion>();
        int i = 2;
        while (i < args.length - 1) {
            String key = args[i];
            String expansionDefinition = args[i + 1];
            Expansion exp = PreProcessor.getExpansion(key, expansionDefinition);
            defines.put(exp.name, exp);
            i += 2;
        }
        PreProcessor.applyChanges(source, dest, defines);
    }

    private static void applyChanges(File source, File dest, Map<String, Expansion> defines) throws IOException {
        BufferedReader reader = new BufferedReader(new FileReader(source));
        BufferedWriter writer = new BufferedWriter(new FileWriter(dest));
        try {
            PreProcessor.expand(reader, writer, defines, new HashSet<String>());
            writer.flush();
        }
        finally {
            try {
                writer.close();
            }
            finally {
                reader.close();
            }
        }
    }

    private static void expand(Reader reader, Writer writer, Map<String, Expansion> defines, Set<String> definesUsed) throws IOException {
        JavaTokenizer tokenizer = new JavaTokenizer(reader);
        while (tokenizer.hasNext()) {
            Token t = tokenizer.next();
            switch (t.type) {
                case -3: {
                    if (definesUsed.contains(t.val)) {
                        throw new IOException("Recurisve expansion of \"" + t.val + "\" detected");
                    }
                    if (defines.containsKey(t.val)) {
                        Expansion expander = defines.get(t.val);
                        String expanded = expander.expand(tokenizer);
                        definesUsed.add(t.val);
                        StringReader childReader = new StringReader(expanded);
                        StringWriter childWriter = new StringWriter();
                        PreProcessor.expand(childReader, childWriter, defines, definesUsed);
                        definesUsed.remove(t.val);
                        writer.write(childWriter.getBuffer().toString());
                        break;
                    }
                    writer.write(t.val);
                    break;
                }
                default: {
                    writer.write(t.val);
                }
            }
        }
    }

    private static Expansion getExpansion(String definition, String value) throws IOException {
        Matcher m = EXP_PATTERN.matcher(definition);
        if (!m.matches()) {
            throw new IOException("Malformed expansion name : " + definition);
        }
        String name = m.group(1);
        String paramsString = m.group(2);
        if (paramsString == null || paramsString.length() == 0) {
            return new LiteralExpansion(definition, value);
        }
        paramsString = paramsString.trim();
        List<String> params = Arrays.asList(paramsString.split("\\s*,\\s*"));
        HashMap<String, Integer> indexMap = new HashMap<String, Integer>();
        int i = 0;
        while (i < params.size()) {
            String param = params.get(i);
            if (!m.matches()) {
                throw new IOException("Malformed paramter: " + param);
            }
            indexMap.put(param, i);
            ++i;
        }
        return new ExpandingExpansion(name, indexMap, value);
    }

    private static class ExpandingExpansion
    extends Expansion {
        private final String expansion;
        private final Map<String, Integer> params;

        public ExpandingExpansion(String name, Map<String, Integer> params, String expansion) {
            super(name);
            this.expansion = expansion;
            this.params = params;
        }

        /*
         * Unable to fully structure code
         */
        @Override
        public String expand(JavaTokenizer tokenizer) throws IOException {
            suppliedSubstitutions = this.consumeSuppliedParameters(tokenizer);
            jtok = new JavaTokenizer(new StringReader(this.expansion));
            b = new StringBuilder();
            if (suppliedSubstitutions.size() == this.params.size()) ** GOTO lbl22
            throw new IOException("Incorrect number of parameters supplied to " + this.name);
lbl-1000:
            // 1 sources

            {
                token = jtok.next();
                switch (token.type) {
                    case -3: {
                        paramIndex = this.params.get(token.val);
                        if (paramIndex == null) {
                            b.append(token.val);
                            break;
                        }
                        b.append(suppliedSubstitutions.get(paramIndex));
                        break;
                    }
                    case -1: 
                    case 10: {
                        break;
                    }
                    default: {
                        b.append(Character.toString((char)token.type));
                    }
                }
lbl22:
                // 5 sources

                ** while (jtok.hasNext())
            }
lbl23:
            // 1 sources

            return b.toString();
        }

        /*
         * Unable to fully structure code
         */
        private List<String> consumeSuppliedParameters(JavaTokenizer tokenizer) throws IOException {
            parameters = new ArrayList<String>();
            b = new StringBuilder();
            bracketCount = 0;
            t = tokenizer.next();
            if (t != null && t.type == 40) ** GOTO lbl43
            throw new IOException("No parameters given to :" + this.name);
lbl-1000:
            // 1 sources

            {
                t = tokenizer.next();
                switch (t.type) {
                    case 40: {
                        ++bracketCount;
                        b.append("(");
                        break;
                    }
                    case 41: {
                        if (--bracketCount < 0) {
                            parameters.add(b.toString());
                            break block7;
                        }
                        b.append(")");
                        break;
                    }
                    case 44: {
                        if (bracketCount == 0) {
                            parameters.add(b.toString());
                            b.delete(0, b.length());
                            break;
                        }
                        b.append(",");
                        break;
                    }
                    case -3: {
                        b.append(t.val);
                        break;
                    }
                    case -1: 
                    case 10: {
                        parameters.add(b.toString());
                        break block7;
                    }
                    default: {
                        b.append(Character.toString((char)t.type));
                    }
                }
lbl43:
                // 7 sources

                ** while (tokenizer.hasNext())
            }
lbl44:
            // 3 sources

            return parameters;
        }
    }

    private static abstract class Expansion {
        protected final String name;

        private Expansion(String name) {
            this.name = name;
        }

        public abstract String expand(JavaTokenizer var1) throws IOException;
    }

    private static class LiteralExpansion
    extends Expansion {
        private final String expansion;

        public LiteralExpansion(String name, String expansion) {
            super(name);
            this.expansion = expansion;
        }

        @Override
        public String expand(JavaTokenizer tokenizer) {
            return this.expansion;
        }
    }
}

