/*
 * Decompiled with CFR 0.152.
 */
package com.arm.util.libs;

import com.arm.util.Platform;
import com.arm.util.ThrowableFormatter;
import com.arm.util.Tuple;
import com.arm.util.URLResolver;
import com.arm.util.UnsupportedProtocolException;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;

public class LibLoaderHelper {
    private static final Logger log = Logger.getLogger(LibLoaderHelper.class.getName());

    public static File resolve(String name, Class<?> fromClass) throws UnsupportedProtocolException, IOException {
        Tuple<String, String> platformId = Platform.getId();
        String fullLibName = System.mapLibraryName(name);
        String path = String.valueOf((String)platformId.ta) + '/' + (String)platformId.tb + '/' + fullLibName;
        URL location = fromClass.getResource(path);
        if (location == null) {
            throw new IOException("Failed to resolve path " + path + " relative to class " + fromClass);
        }
        return URLResolver.resolve(location);
    }

    public static void load(String name, URL fromLocation) throws IOException {
        LibLoaderHelper.load(name, URLResolver.resolve(fromLocation));
    }

    public static void load(String name, File fromFolder) {
        boolean trace = log.isLoggable(Level.FINER);
        try {
            if (trace) {
                log.finer("trying to load library " + name + " using System.loadLibrary()");
            }
            System.loadLibrary(name);
            if (trace) {
                log.finer("successfully loaded library " + name + " using System.loadLibrary()");
            }
        }
        catch (UnsatisfiedLinkError ule) {
            if (trace) {
                log.finer("failed to load library " + name + " using System.loadLibrary() because of: " + ule.getMessage());
                log.finer("will now try to load from " + fromFolder);
            }
            try {
                LibLoaderHelper.tryFromFolder(name, fromFolder);
            }
            catch (UnsatisfiedLinkError unsatisfiedLinkError) {
                if (trace) {
                    log.finer("failed to load library " + name + " by loading from " + fromFolder);
                    log.finer("re-throwing initial exception, which was: " + ThrowableFormatter.stringify(ule));
                }
                throw ule;
            }
        }
    }

    private static List<File> getAllLibraries(File folder) {
        if (!folder.isDirectory()) {
            throw new IllegalArgumentException(folder + " is not a directory");
        }
        if (!folder.isAbsolute()) {
            throw new IllegalArgumentException(folder + " is not an absolute path");
        }
        boolean trace = log.isLoggable(Level.FINER);
        if (trace) {
            log.finer("listing all files in " + folder);
        }
        File[] files = folder.listFiles(new FileFilter(){

            @Override
            public boolean accept(File file) {
                return file.isFile();
            }
        });
        ArrayList<File> libraries = new ArrayList<File>();
        if (files != null) {
            if (trace) {
                log.finer("adding " + Arrays.asList(files));
            }
            libraries.addAll(Arrays.asList(files));
        } else if (trace) {
            log.finer(folder + " doesn't contain any file");
        }
        return libraries;
    }

    private static Pattern getLibNamePattern(String fullLibraryName) {
        Pattern pattern;
        if (Platform.isWindows()) {
            StringTokenizer tokenizer = new StringTokenizer(fullLibraryName, ".");
            String prefix = tokenizer.nextToken();
            String suffix = tokenizer.nextToken();
            pattern = Pattern.compile(String.valueOf(Pattern.quote(prefix)) + "(_\\d+)?\\." + Pattern.quote(suffix));
        } else {
            pattern = Pattern.compile(String.valueOf(Pattern.quote(fullLibraryName)) + "(\\.\\d+)*");
        }
        return pattern;
    }

    private static void tryFromFolder(String name, File folder) throws UnsatisfiedLinkError {
        String fullLibraryName = System.mapLibraryName(name);
        boolean trace = log.isLoggable(Level.FINER);
        if (trace) {
            log.finer("ultimately looking at loading library file " + fullLibraryName + " from " + folder);
        }
        Pattern libNamePattern = LibLoaderHelper.getLibNamePattern(fullLibraryName);
        List<File> libraries = LibLoaderHelper.getAllLibraries(folder);
        boolean didIt = false;
        for (File library : libraries) {
            if (!libNamePattern.matcher(library.getName()).matches()) continue;
            try {
                System.load(library.getPath());
                didIt = true;
                break;
            }
            catch (UnsatisfiedLinkError ule) {
                if (!trace) continue;
                log.finer("failed to load " + library.getPath() + " because of: " + ule.getMessage());
            }
        }
        if (!didIt) {
            throw new UnsatisfiedLinkError("failed to load " + name);
        }
    }
}

