/*
 * Decompiled with CFR 0.152.
 */
package com.arm.util;

public class Unsigned {
    public static final long INT_MASK = 0xFFFFFFFFL;

    public static boolean less64(long a, long b) {
        return a < b ^ a < 0L ^ b < 0L;
    }

    public static boolean lessOrEq64(long a, long b) {
        return a <= b ^ a < 0L ^ b < 0L;
    }

    public static boolean greater64(long a, long b) {
        return a > b ^ a < 0L ^ b < 0L;
    }

    public static boolean greaterOrEq64(long a, long b) {
        return a >= b ^ a < 0L ^ b < 0L;
    }

    public static long max64(long a, long b) {
        return a > b ^ a < 0L ^ b < 0L ? a : b;
    }

    public static long min64(long a, long b) {
        return a < b ^ a < 0L ^ b < 0L ? a : b;
    }

    public static boolean lessEqLess(long x, long a, long b) {
        if (Unsigned.lessOrEq64(a, b)) {
            return Unsigned.lessOrEq64(b - x, b - a);
        }
        return Unsigned.lessOrEq64(a - x, a - b);
    }

    public static long modulo(long n, long d) {
        if (d == 0L) {
            throw new ArithmeticException("Division by 0");
        }
        if (d < 0L) {
            if (Unsigned.less64(n, d)) {
                return n;
            }
            return n - d;
        }
        if (n >= 0L) {
            return n % d;
        }
        long q = (n >>> 1) / d << 1;
        long r = n - q * d;
        if (Unsigned.greaterOrEq64(r, d)) {
            r -= d;
        }
        return r;
    }

    public static long divide(long op1, long op2) {
        if (op2 == 0L) {
            throw new ArithmeticException("Division by 0");
        }
        long t = op2 >> 31;
        long op1a = op1 & (t ^ 0xFFFFFFFFFFFFFFFFL);
        long q = (op1a >>> 1) / op2 << 1;
        long r = op1 - q * op2;
        long e = r >= op2 ^ r < 0L ^ op2 < 0L ? 1 : 0;
        return q + e;
    }

    public static long toLong(int uint32) {
        return (long)uint32 & 0xFFFFFFFFL;
    }
}

