/*
 * Decompiled with CFR 0.152.
 */
package com.arm.util;

import com.arm.text.IMessage;
import com.arm.util.Messages;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class Units {
    private static <T extends IUnit<T>> long convertUnitStringToBase(String unitString, T[] unitValues) {
        if (unitString.contains(".") || unitString.contains(",")) {
            throw new IllegalArgumentException("Cannot convert " + unitString + ": the value must be an integer");
        }
        String inputUnitString = unitString;
        unitString = unitString.replaceAll("\\s", "");
        unitString = unitString.toLowerCase();
        Pattern pattern = Pattern.compile("^\\d+$");
        Matcher matcher = pattern.matcher(unitString);
        if (matcher.find()) {
            return Long.parseLong(unitString);
        }
        pattern = Pattern.compile("\\d([a-z]+?)$");
        matcher = pattern.matcher(unitString);
        if (!matcher.find()) {
            throw new IllegalArgumentException(String.valueOf(inputUnitString) + " is not a valid unit string");
        }
        String unitStringSuffix = matcher.group(1);
        String valueStr = null;
        IUnit<Object> matchedUnit = null;
        T[] TArray = unitValues;
        int n = unitValues.length;
        int n2 = 0;
        block0: while (n2 < n) {
            T unit = TArray[n2];
            for (String suffix : unit.listSuffixes()) {
                if (!suffix.equals(unitStringSuffix)) continue;
                valueStr = unitString.substring(0, unitString.length() - suffix.length());
                matchedUnit = unit;
                break block0;
            }
            ++n2;
        }
        if (valueStr == null) {
            throw new IllegalArgumentException("Could not find a suffix to match " + inputUnitString);
        }
        long value = Long.parseLong(valueStr);
        return matchedUnit.toBase(value);
    }

    public static enum ByteUnit implements IUnit<ByteUnit>
    {
        B(1L, "b", "byte", "bytes"),
        KB(1024L, "k", "kb", "kilobyte", "kilobytes"),
        MB(0x100000L, "m", "mb", "megabyte", "megabytes"),
        GB(0x40000000L, "g", "gb", "gigabyte", "gigabytes"),
        TB(0x10000000000L, "t", "tb", "terabyte", "terabytes"),
        PB(0x4000000000000L, "p", "pb", "petabyte", "petabytes");

        private final long scale;
        private final List<String> suffixes;

        private ByteUnit(long scale, String ... suffixes) {
            this.scale = scale;
            this.suffixes = Collections.unmodifiableList(Arrays.asList(suffixes));
        }

        @Override
        public long toBase(long value) {
            return value * this.scale;
        }

        @Override
        public long fromBase(long value) {
            return value / this.scale;
        }

        @Override
        public List<String> listSuffixes() {
            return this.suffixes;
        }

        public static ByteUnit getFirstUnitSmallerThan(long value) {
            ByteUnit[] byteUnits = ByteUnit.values();
            ByteUnit unit = byteUnits[0];
            ByteUnit[] byteUnitArray = byteUnits;
            int n = byteUnits.length;
            int n2 = 0;
            while (n2 < n) {
                ByteUnit b = byteUnitArray[n2];
                long oneOfUnit = b.toBase(1L);
                if (value < oneOfUnit) break;
                unit = b;
                ++n2;
            }
            return unit;
        }

        public String formatValueInUnit(long baseValue) {
            return String.format("%d%s", this.fromBase(baseValue), this.toString());
        }

        public static long convertStringToBase(String byteString) {
            return Units.convertUnitStringToBase((String)byteString, (IUnit[])ByteUnit.values());
        }
    }

    public static enum HertzUnit implements IUnit<HertzUnit>
    {
        HZ(1L, "hz", "hertz"),
        KHZ(1000L, "khz", "kilohertz"),
        MHZ(1000000L, "mhz", "megahertz"),
        GHZ(1000000000L, "ghz", "gigahertz"),
        THZ(1000000000000L, "thz", "terahertz"),
        PHZ(1000000000000000L, "phz", "petahertz");

        private final long scale;
        private final List<String> suffixes;

        private HertzUnit(long scale, String ... suffixes) {
            this.scale = scale;
            this.suffixes = Collections.unmodifiableList(Arrays.asList(suffixes));
        }

        @Override
        public long toBase(long value) {
            return value * this.scale;
        }

        @Override
        public long fromBase(long value) {
            return value / this.scale;
        }

        @Override
        public List<String> listSuffixes() {
            return this.suffixes;
        }

        public static long convertStringToBase(String hertzString) {
            return Units.convertUnitStringToBase((String)hertzString, (IUnit[])HertzUnit.values());
        }
    }

    public static interface IUnit<UnitType extends IUnit<UnitType>> {
        public long toBase(long var1);

        public long fromBase(long var1);

        public List<String> listSuffixes();
    }

    public static enum TimeUnit implements IUnit<TimeUnit>
    {
        SECOND(1L, Messages.SECOND, Messages.SECONDS, "s", "second", "seconds"),
        MINUTE(SECOND.toBase(60L), Messages.MINUTE, Messages.MINUTES, "min", "minute", "minutes"),
        HOUR(MINUTE.toBase(60L), Messages.HOUR, Messages.HOURS, "hr", "hour", "hours"),
        DAY(HOUR.toBase(24L), Messages.DAY, Messages.DAYS, "day", "days");

        private final long scale;
        private final String singular;
        private final String plural;
        private final List<String> suffixes;

        private TimeUnit(long scale, IMessage singular, IMessage plural, String ... suffixes) {
            this.scale = scale;
            this.singular = singular.getLocalisedValue(new Object[0]);
            this.plural = plural.getLocalisedValue(new Object[0]);
            this.suffixes = Collections.unmodifiableList(Arrays.asList(suffixes));
        }

        @Override
        public List<String> listSuffixes() {
            return this.suffixes;
        }

        @Override
        public long toBase(long value) {
            return value * this.scale;
        }

        @Override
        public long fromBase(long value) {
            return value / this.scale;
        }

        public String getLocalisedSingular() {
            return this.singular;
        }

        public String getLocalisedPlural() {
            return this.plural;
        }

        public static long convertStringToBase(String timeString) {
            return Units.convertUnitStringToBase((String)timeString, (IUnit[])TimeUnit.values());
        }
    }
}

