/*
 * Decompiled with CFR 0.152.
 */
package com.arm.util;

import java.util.ListIterator;
import java.util.NoSuchElementException;

public class LimitedListIterator<E>
implements ListIterator<E> {
    private final ListIterator<E> iterator;
    private final int limit;
    private int next = 0;

    public LimitedListIterator(ListIterator<E> iterator, int limit) {
        if (limit <= 0) {
            throw new IllegalArgumentException();
        }
        this.iterator = iterator;
        this.limit = limit;
    }

    @Override
    public boolean hasNext() {
        return this.next < this.limit && this.iterator.hasNext();
    }

    @Override
    public E next() {
        if (this.next < this.limit) {
            ++this.next;
            return this.iterator.next();
        }
        throw new NoSuchElementException();
    }

    @Override
    public boolean hasPrevious() {
        return this.next > 0 && this.iterator.hasPrevious();
    }

    @Override
    public E previous() {
        if (this.next > 0) {
            --this.next;
            return this.iterator.previous();
        }
        throw new NoSuchElementException();
    }

    @Override
    public int nextIndex() {
        return this.next;
    }

    @Override
    public int previousIndex() {
        return this.next - 1;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void set(E e) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void add(E e) {
        throw new UnsupportedOperationException();
    }
}

