/*
 * Decompiled with CFR 0.152.
 */
package com.arm.util;

import com.arm.io.Files;
import com.arm.shell.ProcessHandler;
import com.arm.shell.ShellException;
import com.arm.util.Messages;
import com.arm.util.Platform;
import java.io.File;
import java.io.IOException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class HostInfo {
    static String osname = Platform.OS.toLowerCase();
    static String osver = System.getProperty("os.version").toLowerCase();
    static String osarch = Platform.ARCH.toLowerCase();
    private static boolean gotDist = false;
    private static String dist;
    private static boolean gotDistVersion;
    private static String distVersion;

    static {
        gotDistVersion = false;
        distVersion = null;
    }

    public static String getNativeLineEnding() {
        return HostInfo.getLineEnding("native");
    }

    public static String getLineEnding(String eol) {
        String result;
        String input = eol.trim().toLowerCase();
        if (input.equals("cr")) {
            result = "\r";
        } else if (input.equals("lf")) {
            result = "\n";
        } else if (input.equals("crlf")) {
            result = "\r\n";
        } else if (input.equals("native")) {
            result = HostInfo.isWindows() ? "\r\n" : "\n";
        } else {
            throw new IllegalArgumentException(Messages.UNRECOGNISED_EOL.getLocalisedValue(eol));
        }
        return result;
    }

    public static String getArchitectureDirectoryName() {
        if (HostInfo.isWindows()) {
            return "win_32-pentium";
        }
        if (HostInfo.isLinux()) {
            return "linux-pentium";
        }
        if (HostInfo.isSolaris()) {
            return "solaris-sparc";
        }
        if (HostInfo.isHPUX()) {
            return "hpux-hppa";
        }
        return null;
    }

    public static String getPlatformFamily() {
        Messages result = Messages.WINDOWS;
        if (HostInfo.isSolaris()) {
            result = Messages.SOLARIS;
        } else if (HostInfo.isHPUX()) {
            result = Messages.HPUX;
        } else if (HostInfo.isLinux()) {
            result = Messages.LINUX;
        }
        return result.getLocalisedValue(new Object[0]);
    }

    public static boolean isMacOSClassic() {
        return osname.indexOf("mac os") != -1 && !HostInfo.isMacOSX();
    }

    public static boolean isMacOSX() {
        return osname.indexOf("mac os x") != -1;
    }

    public static boolean isWindows() {
        return Platform.isWindows();
    }

    public static boolean isHPUX() {
        return osname.indexOf("hp-ux") != -1;
    }

    public static boolean isSolaris() {
        return osname.indexOf("solaris") != -1 || osname.indexOf("sun") != -1;
    }

    public static boolean isLinux() {
        return Platform.isLinux();
    }

    public static boolean isUnix() {
        return !HostInfo.isWindows();
    }

    public static boolean isWindows9x() {
        return HostInfo.isWindows95() || HostInfo.isWindows98() || HostInfo.isWindowsME();
    }

    public static boolean isWindows95() {
        return HostInfo.isWindows() && osname.indexOf("95") != -1;
    }

    public static boolean isWindows98() {
        return HostInfo.isWindows() && osname.indexOf("98") != -1;
    }

    public static boolean isWindowsME() {
        return HostInfo.isWindows() && osname.indexOf("me") != -1;
    }

    public static boolean isWindowsNTFamily() {
        return HostInfo.isWindows2k() || HostInfo.isWindowsXP() || HostInfo.isWindowsNT() || HostInfo.isWindows2003() || HostInfo.isWindowsVista();
    }

    public static boolean isWindowsNT() {
        return HostInfo.isWindows() && osname.indexOf("nt") != -1 && !osname.equals("windows nt (unknown)");
    }

    public static boolean isWindows2k() {
        return HostInfo.isWindows() && osname.indexOf("2000") != -1 && osver.equals("5.0");
    }

    public static boolean isWindowsXP() {
        return HostInfo.isWindows() && (osname.indexOf("xp") != -1 || osname.indexOf("2000") != -1 && osver.equals("5.1"));
    }

    public static boolean isWindows2003() {
        return HostInfo.isWindows() && osname.indexOf("2003") != -1;
    }

    public static boolean isWindowsVista() {
        if (HostInfo.isWindows()) {
            if (osname.indexOf("vista") != -1) {
                return true;
            }
            if (osname.equals("windows nt (unknown)") && osver.equals("6.0")) {
                return true;
            }
        }
        return false;
    }

    public static String getShell() {
        String shell = null;
        if (HostInfo.isWindows()) {
            shell = System.getenv("ComSpec");
            if (!HostInfo.validateShell(shell) && (shell = Files.which("cmd.exe")) == null) {
                shell = Files.which("command.exe");
            }
            if (shell == null) {
                throw new RuntimeException("Cannot locate shell - please set %ComSpec% to point at command.exe\n");
            }
        }
        if ((HostInfo.isUnix() || HostInfo.isMacOSX()) && !HostInfo.validateShell(shell = System.getenv("SHELL"))) {
            shell = Files.which("bash");
            if (shell == null) {
                shell = Files.which("tcsh");
            }
            if (shell == null) {
                shell = Files.which("sh");
            }
            if (shell == null) {
                throw new RuntimeException("Cannot locate shell - please set $SHELL to point at your shell\n");
            }
        }
        return shell;
    }

    private static boolean validateShell(String p) {
        if (p == null) {
            return false;
        }
        File f = new File(p);
        if (!f.exists()) {
            return false;
        }
        return f.isFile();
    }

    public static long getPid() throws ShellException {
        if (!HostInfo.isUnix()) {
            throw new IllegalArgumentException("cannot determine PID on non-UNIX platforms");
        }
        ProcessHandler pw = new ProcessHandler(null, new String[]{Files.which2("sh"), "-c", "echo $PPID"});
        if (pw.executeAndWait() == 0) {
            try {
                return Long.parseLong(pw.getStdout().trim());
            }
            catch (NumberFormatException numberFormatException) {
                throw new ShellException("failed to parse output of 'sh -c echo $PPID': " + pw.getStdout());
            }
        }
        throw new ShellException("failed to get pid: " + pw.getStderr());
    }

    public static String getLinuxDistribution() {
        if (!gotDist) {
            File lf;
            gotDist = true;
            if (!HostInfo.isLinux()) {
                return null;
            }
            String lsbRelease = Files.which2("lsb_release");
            if (lsbRelease != null && (lf = new File(lsbRelease)).canExecute()) {
                try {
                    ProcessHandler pw = new ProcessHandler(null, new String[]{lsbRelease, "--id", "--short"});
                    if (pw.executeAndWait() == 0) {
                        String id = pw.getStdout();
                        if (id.startsWith("RedHat")) {
                            dist = "redhat";
                        }
                        if (id.startsWith("Ubuntu")) {
                            dist = "ubuntu";
                        }
                    }
                }
                catch (ShellException shellException) {}
            }
            if (dist == null) {
                if (new File("/etc/redhat-release").exists()) {
                    dist = "redhat";
                } else if (new File("/etc/fedora-release").exists()) {
                    dist = "redhat";
                } else if (new File("/etc/redhat_version").exists()) {
                    dist = "redhat";
                } else if (new File("/etc/debian_version").exists()) {
                    dist = "debian";
                } else if (new File("/etc/debian_release").exists()) {
                    dist = "debian";
                } else if (new File("/etc/gentoo-release").exists()) {
                    dist = "gentoo";
                } else if (new File("/etc/SuSE-release").exists()) {
                    dist = "suse";
                } else if (new File("/etc/slackware-release").exists()) {
                    dist = "slackware";
                } else if (new File("/etc/slackware-version").exists()) {
                    dist = "slackware";
                } else if (new File("/etc/mandrake-release").exists()) {
                    dist = "mandrake";
                } else if (new File("/etc/yellowdog-release").exists()) {
                    dist = "yellowdog";
                } else if (new File("/etc/sun-release").exists()) {
                    dist = "jds";
                } else {
                    File issue = new File("/etc/issue");
                    if (issue.exists()) {
                        try {
                            String i = Files.getContent(issue, "UTF-8");
                            if (i.contains("Red Hat")) {
                                dist = "redhat";
                            }
                        }
                        catch (IOException iOException) {}
                    }
                }
            }
            return dist;
        }
        return dist;
    }

    public static String getLinuxDistributionVersion() {
        if (!gotDistVersion) {
            File lf;
            gotDistVersion = true;
            String lsbRelease = Files.which2("lsb_release");
            if (lsbRelease != null && (lf = new File(lsbRelease)).canExecute()) {
                try {
                    ProcessHandler pw = new ProcessHandler(null, new String[]{lsbRelease, "--release", "--short"});
                    if (pw.executeAndWait() == 0) {
                        distVersion = pw.getStdout().trim();
                    }
                }
                catch (ShellException shellException) {}
            }
            if (distVersion == null && HostInfo.getLinuxDistribution().equals("redhat")) {
                Pattern p;
                Matcher m;
                String content = null;
                String[] stringArray = new String[]{"redhat-release", "redhat_version", "fedora-release", "issue"};
                int n = stringArray.length;
                int n2 = 0;
                while (n2 < n) {
                    String s = stringArray[n2];
                    try {
                        content = Files.getContent(new File("/etc/" + s), "UTF-8");
                        break;
                    }
                    catch (IOException iOException) {
                        ++n2;
                    }
                }
                if (content != null && (m = (p = Pattern.compile("Red Hat Enterprise Linux.+ release ([\\d\\.]+)")).matcher(content)).find()) {
                    distVersion = m.group(1);
                }
            }
        }
        return distVersion;
    }

    public static File getHome() {
        String home = System.getProperty("user.home");
        if (home == null && HostInfo.isUnix()) {
            home = System.getenv("HOME");
        }
        if (home == null && HostInfo.isWindows()) {
            home = new File(System.getenv("HOMEDRIVE"), System.getenv("HOMEPATH")).getPath();
        }
        return home == null ? null : new File(home);
    }
}

