/*
 * Decompiled with CFR 0.152.
 */
package com.arm.util;

import java.math.BigInteger;

public class HexNumberHelper {
    private static final String HEX_CHARS = "abcdef0123456789";
    private static final String HEX_PREFIX = "0x";

    public static boolean validAddress(String value) {
        return HexNumberHelper.validAddress(value, 32);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static boolean validAddress(String value, int numberOfBits) {
        BigInteger numberValue;
        if (value.length() <= 0) return false;
        if ((value = value.toLowerCase()).startsWith(HEX_PREFIX)) {
            if (value.length() <= 2) return false;
            int i = 2;
            while (i < value.length()) {
                if (HEX_CHARS.indexOf(value.charAt(i)) == -1) {
                    return false;
                }
                ++i;
            }
            numberValue = new BigInteger(value.substring(2), 16);
            return numberValue.compareTo(BigInteger.ZERO) >= 0 && numberValue.compareTo(BigInteger.valueOf(2L).pow(numberOfBits)) < 0;
        } else {
            int i = 0;
            while (i < value.length()) {
                if (!Character.isDigit(value.charAt(i))) {
                    return false;
                }
                ++i;
            }
            numberValue = new BigInteger(value);
        }
        return numberValue.compareTo(BigInteger.ZERO) >= 0 && numberValue.compareTo(BigInteger.valueOf(2L).pow(numberOfBits)) < 0;
    }

    public static long parseAddressToLong(String value) {
        if (value != null && value.length() > 0) {
            if ((value = value.toLowerCase()).startsWith(HEX_PREFIX)) {
                if (value.length() > 2) {
                    int i = 2;
                    while (i < value.length()) {
                        if (HEX_CHARS.indexOf(value.charAt(i)) == -1) {
                            throw new NumberFormatException("Unable to parse the address: " + value);
                        }
                        ++i;
                    }
                    return Long.parseLong(value.substring(2), 16);
                }
            } else {
                int i = 0;
                while (i < value.length()) {
                    if (!Character.isDigit(value.charAt(i))) {
                        throw new NumberFormatException("Unable to parse the address: " + value);
                    }
                    ++i;
                }
                return Long.parseLong(value);
            }
        }
        throw new NumberFormatException("Unable to parse the address: " + value);
    }

    public static int parseAddressToInt(String address) {
        if (address != null && address.length() > 0) {
            if ((address = address.toLowerCase()).startsWith(HEX_PREFIX)) {
                if (address.length() > 2) {
                    int i = 2;
                    while (i < address.length()) {
                        if (HEX_CHARS.indexOf(address.charAt(i)) == -1) {
                            throw new NumberFormatException("Unable to parse the address: " + address);
                        }
                        ++i;
                    }
                    return Integer.parseUnsignedInt(address.substring(2), 16);
                }
            } else {
                int i = 0;
                while (i < address.length()) {
                    if (!Character.isDigit(address.charAt(i))) {
                        throw new NumberFormatException("Unable to parse the address: " + address);
                    }
                    ++i;
                }
                return Integer.parseInt(address);
            }
        }
        throw new NumberFormatException("Unable to parse the address: " + address);
    }

    public static String longToHexString(long value) {
        return HexNumberHelper.longToHexString(value, 0);
    }

    public static final String longToHexString(long value, int minLength) {
        return HexNumberHelper.longToHexString(value, minLength, true);
    }

    public static final String longToHexString(long value, int minLength, boolean addPrefix) {
        String hexStr = Long.toHexString(value).toUpperCase();
        StringBuilder result = new StringBuilder();
        if (addPrefix) {
            result.append(HEX_PREFIX);
        }
        int i = minLength - hexStr.length();
        while (i > 0) {
            result.append("0");
            --i;
        }
        result.append(hexStr);
        return result.toString();
    }

    public static String toHexString(byte value) {
        return HexNumberHelper.longToHexString((long)value & 0xFFL, 2);
    }

    public static String toHexString(short value) {
        return HexNumberHelper.longToHexString((long)value & 0xFFFFL, 4);
    }

    public static String toHexString(int value) {
        return HexNumberHelper.longToHexString((long)value & 0xFFFFFFFFL, 8);
    }

    public static String toHexString(long value) {
        return HexNumberHelper.longToHexString(value, 16);
    }

    public static String bytesToHexString(byte[] bytes) {
        StringBuilder hexString = new StringBuilder();
        byte[] byArray = bytes;
        int n = bytes.length;
        int n2 = 0;
        while (n2 < n) {
            byte h = byArray[n2];
            hexString.append(HexNumberHelper.longToHexString((long)h & 0xFFL, 2, false));
            ++n2;
        }
        return hexString.toString();
    }
}

