/*
 * Decompiled with CFR 0.152.
 */
package com.arm.util;

import java.io.IOException;
import java.io.Reader;
import java.util.HashMap;
import java.util.Map;
import java.util.Stack;

public class HTMLDetagger
extends Reader {
    private static final char TAG_END = '>';
    private static final char SPECIAL_END = ';';
    private static final Map<String, String> TAGS = new HashMap<String, String>();
    private static final Map<String, String> SPECIALS = new HashMap<String, String>();
    private final Reader in;
    private final Map<String, String> tags;
    private final Map<String, String> specials;
    private boolean eos;
    private Stack<Character> buffer = new Stack();

    static {
        TAGS.put("p", "\n");
        TAGS.put("/p", "\n");
        TAGS.put("br", "\n");
        TAGS.put("br/", "\n");
        TAGS.put("ul", "\n");
        TAGS.put("li", "\t- ");
        SPECIALS.put("amp", "&");
        SPECIALS.put("#38", "&");
        SPECIALS.put("lt", "<");
        SPECIALS.put("#60", "<");
        SPECIALS.put("gt", ">");
        SPECIALS.put("#62", ">");
        SPECIALS.put("quot", "\"");
        SPECIALS.put("#34", "\"");
        SPECIALS.put("apos", "'");
        SPECIALS.put("#39", "'");
        SPECIALS.put("nbsp", " ");
        SPECIALS.put("reg", "(R)");
        SPECIALS.put("#174", "(R)");
        SPECIALS.put("copy", "(C)");
        SPECIALS.put("#159", "(C)");
        SPECIALS.put("trade", "(TM)");
        SPECIALS.put("#153", "(TM)");
        SPECIALS.put("lsquo", "'");
        SPECIALS.put("#8216", "'");
        SPECIALS.put("rsquo", "'");
        SPECIALS.put("#8217", "'");
        SPECIALS.put("sbquo", ",");
        SPECIALS.put("#8218", ",");
        SPECIALS.put("ldquo", "\"");
        SPECIALS.put("#8220", "\"");
        SPECIALS.put("rdquo", "\"");
        SPECIALS.put("#8221", "\"");
    }

    public HTMLDetagger(Reader in) {
        this(in, TAGS, SPECIALS);
    }

    public HTMLDetagger(Reader in, Map<String, String> tags, Map<String, String> specials) {
        if (in == null) {
            throw new NullPointerException("in can't be null");
        }
        this.in = in;
        this.tags = new HashMap<String, String>(TAGS);
        this.specials = new HashMap<String, String>(SPECIALS);
        tags.putAll(tags);
        tags.putAll(specials);
    }

    public static Map<String, String> getDefaultTagsMapping() {
        return new HashMap<String, String>(TAGS);
    }

    public static Map<String, String> getDefaultSpecialsMapping() {
        return new HashMap<String, String>(SPECIALS);
    }

    @Override
    public void close() throws IOException {
        this.in.close();
    }

    private void fillStack(String str) {
        if (str != null) {
            int i = str.length() - 1;
            while (i > -1) {
                this.buffer.add(Character.valueOf(str.charAt(i)));
                --i;
            }
        }
    }

    @Override
    public int read(char[] cbuf, int off, int len) throws IOException {
        int read = this.eos ? -1 : 0;
        while (read < len && !this.eos) {
            if (this.buffer.size() > 0) {
                cbuf[off + read++] = this.buffer.pop().charValue();
                continue;
            }
            int c = this.in.read();
            if (c == -1) {
                this.eos = true;
                continue;
            }
            if (c == 60) {
                String tag = this.readUntil('>');
                this.fillStack(this.tags.get(tag));
                continue;
            }
            if (c == 38) {
                String special = this.readUntil(';');
                this.fillStack(this.specials.get(special));
                continue;
            }
            cbuf[off + read++] = (char)c;
        }
        return read;
    }

    private String readUntil(char ch) throws IOException {
        StringBuilder sb = new StringBuilder();
        int c = this.in.read();
        while (c != -1 && c != ch) {
            sb.append((char)c);
            c = this.in.read();
        }
        return sb.toString().toLowerCase();
    }
}

