/*
 * Decompiled with CFR 0.152.
 */
package com.arm.util;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;

public class Glob {
    private static final Set<Character> specialChars;

    static {
        HashSet<Character> s = new HashSet<Character>();
        s.add(Character.valueOf('^'));
        s.add(Character.valueOf('$'));
        s.add(Character.valueOf('{'));
        s.add(Character.valueOf('}'));
        s.add(Character.valueOf('('));
        s.add(Character.valueOf(')'));
        s.add(Character.valueOf('+'));
        s.add(Character.valueOf('|'));
        specialChars = Collections.unmodifiableSet(s);
    }

    public static Pattern compile(String pattern) throws PatternSyntaxException {
        return Glob.compile(pattern, 0);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static Pattern compile(String pattern, int flags) throws PatternSyntaxException {
        StringBuilder regex = new StringBuilder();
        boolean inCC = false;
        boolean inEscape = false;
        int i = 0;
        while (i < pattern.length()) {
            char c = pattern.charAt(i);
            if (inCC) {
                if (c == '[') {
                    regex.append("\\");
                }
                if (c != '&' || regex.charAt(regex.length() - 1) != '&') {
                    regex.append(c);
                    if (c == '\\') {
                        boolean bl = inEscape = !inEscape;
                    }
                    if (c == ']' && !inEscape) {
                        inCC = false;
                    }
                }
            } else if (inEscape) {
                if (c != '[' && c != '\\' && c != '?' && c != '*') throw new PatternSyntaxException("illegal escape character " + c, pattern, i);
                regex.append("\\" + c);
                inEscape = false;
            } else {
                switch (c) {
                    case '*': {
                        regex.append(".*");
                        break;
                    }
                    case '?': {
                        regex.append(".");
                        break;
                    }
                    case '[': {
                        regex.append("[");
                        if (i + 1 == pattern.length()) {
                            throw new PatternSyntaxException("pattern ends inside character class", pattern, i);
                        }
                        if (pattern.charAt(i + 1) == ']') {
                            ++i;
                            regex.append("\\]");
                        } else if (pattern.charAt(i + 1) == '!') {
                            ++i;
                            regex.append("^");
                        }
                        inCC = true;
                        break;
                    }
                    case '\\': {
                        inEscape = true;
                        break;
                    }
                    default: {
                        if (specialChars.contains(Character.valueOf(c))) {
                            regex.append("\\");
                        }
                        regex.append(c);
                    }
                }
            }
            ++i;
        }
        if (inCC) {
            throw new PatternSyntaxException("incomplete character class", pattern, pattern.length());
        }
        if (!inEscape) return Pattern.compile(regex.toString(), flags);
        throw new PatternSyntaxException("incomplete escape", pattern, pattern.length());
    }
}

