/*
 * Decompiled with CFR 0.152.
 */
package com.arm.util;

import java.util.Timer;
import java.util.TimerTask;

public class CountingLock {
    private int count;

    public CountingLock() {
        this(0);
    }

    public CountingLock(int initialCount) {
        this.count = initialCount;
    }

    public synchronized void increment() {
        ++this.count;
        this.notify();
    }

    public synchronized void decrement() {
        --this.count;
        this.notify();
    }

    public void waitUntilZero() {
        this.waitUntilZero(0L);
    }

    /*
     * Handled impossible loop by duplicating code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public synchronized void waitUntilZero(long timeout) {
        if (timeout < 0L) {
            throw new IllegalArgumentException("timeout must be non-negative");
        }
        Timer t = null;
        try {
            final boolean[] timerExpired = new boolean[1];
            if (timeout == 0L) {
                if (this.count == 0) return;
                if (timerExpired[0]) {
                    return;
                }
            } else {
                t = new Timer(true);
                t.schedule(new TimerTask(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run() {
                        timerExpired[0] = true;
                        CountingLock countingLock = CountingLock.this;
                        synchronized (countingLock) {
                            CountingLock.this.notify();
                        }
                    }
                }, timeout);
                if (true) {
                    if (this.count == 0) return;
                    if (timerExpired[0]) return;
                }
            }
            do {
                try {
                    this.wait();
                }
                catch (InterruptedException interruptedException) {}
                if (this.count == 0) return;
            } while (!timerExpired[0]);
            return;
        }
        finally {
            if (t != null) {
                t.cancel();
            }
        }
    }
}

