/*
 * Decompiled with CFR 0.152.
 */
package com.arm.util;

import java.util.Iterator;
import java.util.NoSuchElementException;

public class ConcatenatingIterator<T>
implements Iterator<T> {
    private final Iterator<T>[] iterators;
    private int currentIterator = 0;

    @SafeVarargs
    public ConcatenatingIterator(Iterator<T> ... iterators) {
        this.iterators = iterators;
    }

    @Override
    public boolean hasNext() {
        int i = this.currentIterator;
        while (i < this.iterators.length) {
            if (this.iterators[i].hasNext()) {
                return true;
            }
            ++i;
        }
        return false;
    }

    @Override
    public T next() {
        int i = this.currentIterator;
        while (i < this.iterators.length) {
            if (this.iterators[i].hasNext()) {
                this.currentIterator = i;
                return this.iterators[i].next();
            }
            ++i;
        }
        throw new NoSuchElementException();
    }
}

