/*
 * Decompiled with CFR 0.152.
 */
package com.arm.timestamp;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Properties;

public class TimestampProperties {
    private static final String PROPERTIES_FILENAME = "properties";
    private static final String LAST_CHECKED_TOOLKIT = "last.checked.toolkit";
    private final File propertiesFile;
    private final Properties properties = new Properties();

    public TimestampProperties(File base) {
        this.propertiesFile = new File(base, PROPERTIES_FILENAME);
        this.read();
    }

    protected void read() {
        if (!this.propertiesFile.exists()) {
            return;
        }
        try (BufferedReader reader = new BufferedReader(new FileReader(this.propertiesFile));){
            this.properties.load(reader);
        }
        catch (IOException iOException) {}
    }

    public boolean save() {
        try (PrintWriter writer = new PrintWriter(this.propertiesFile);){
            this.properties.store(writer, "");
            writer.flush();
        }
        catch (IOException iOException) {
            return false;
        }
    }

    public String getLastCheckedToolkit(String defultValue) {
        return this.properties.getProperty(LAST_CHECKED_TOOLKIT, defultValue);
    }

    public boolean setLastCheckedToolkit(String value, boolean save) {
        this.properties.setProperty(LAST_CHECKED_TOOLKIT, value == null ? "" : value);
        if (save) {
            return this.save();
        }
        return save;
    }
}

