/*
 * Decompiled with CFR 0.152.
 */
package com.arm.text;

import java.net.URL;
import java.net.URLClassLoader;
import java.text.MessageFormat;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;

public class Localiser {
    private static final String BASE_NAME = "messages";
    public static final String FORMAT_SEPARATOR = ";;";
    private final ResourceBundle bundle;

    public Localiser(URL url, Locale locale) {
        URLClassLoader loader = URLClassLoader.newInstance(new URL[]{url}, null);
        this.bundle = Localiser.getBundle("", loader, locale);
    }

    public Localiser(Class<?> anchor, Locale locale) {
        if (anchor != null) {
            Package p = anchor.getPackage();
            String path = p != null ? String.valueOf(p.getName().replace('.', '/')) + '/' : "";
            ClassLoader loader = anchor.getClassLoader();
            if (loader == null) {
                loader = ClassLoader.getSystemClassLoader();
            }
            this.bundle = Localiser.getBundle(path, loader, locale);
        } else {
            this.bundle = null;
        }
    }

    public Localiser(URL url) {
        this(url, Locale.getDefault());
    }

    public Localiser(Class<?> anchor) {
        this(anchor, Locale.getDefault());
    }

    private static ResourceBundle getBundle(String path, ClassLoader loader, Locale locale) {
        ResourceBundle bundle;
        String baseName = String.valueOf(path) + BASE_NAME;
        try {
            bundle = ResourceBundle.getBundle(baseName, locale, loader);
        }
        catch (MissingResourceException missingResourceException) {
            bundle = null;
        }
        return bundle;
    }

    public String localise(String key, Object ... args) {
        String localised;
        if (key == null) {
            return null;
        }
        if ((args == null || args.length == 0) && key.contains(FORMAT_SEPARATOR)) {
            String[] keySplit = key.split(FORMAT_SEPARATOR);
            args = new String[keySplit.length - 1];
            System.arraycopy(keySplit, 1, args, 0, keySplit.length - 1);
            key = keySplit[0];
        }
        try {
            localised = this.bundle == null || key == null ? key : MessageFormat.format(this.bundle.getString(key), args);
        }
        catch (MissingResourceException missingResourceException) {
            localised = key;
        }
        return localised;
    }
}

