/*
 * Decompiled with CFR 0.152.
 */
package com.arm.text;

import com.arm.text.IFormattedMessage;
import com.arm.text.ILayer;
import com.arm.text.IMessage;
import jakarta.annotation.Nullable;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.util.Collections;
import java.util.List;

public class FormattedException
extends Exception {
    private static final String ASYNC_CALLER_MESSAGE = "Asynchronously called from thread ";
    private final ILayer callingLayer;
    private final IFormattedMessage message;
    private String callerThreadName;
    private List<StackTraceElement> asyncCallerStack;

    public IFormattedMessage getFormattedMessage() {
        return this.message;
    }

    public FormattedException(IFormattedMessage message) {
        this(null, message.getLayer(), message);
    }

    public FormattedException(IFormattedMessage message, Throwable cause) {
        this(cause, message.getLayer(), message);
    }

    public FormattedException(IMessage message) {
        this(null, message.getLayer(), message.format(new Object[0]));
    }

    public FormattedException(IMessage message, Throwable cause) {
        this(cause, message.getLayer(), message.format(new Object[0]));
    }

    private FormattedException(@Nullable Throwable cause, ILayer caller, IFormattedMessage message) {
        super(cause);
        this.callingLayer = caller;
        this.message = message;
    }

    @Override
    public String getLocalizedMessage() {
        return this.message.getLocalisedValue();
    }

    @Override
    public String getMessage() {
        return this.message.getEnglishValue();
    }

    public ILayer getLayer() {
        return this.callingLayer;
    }

    public void setAsyncCallerStack(Thread thread, List<StackTraceElement> asyncCallerStack) {
        this.callerThreadName = thread.getName();
        this.asyncCallerStack = Collections.unmodifiableList(asyncCallerStack);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void printStackTrace(PrintStream s) {
        PrintStream printStream = s;
        synchronized (printStream) {
            super.printStackTrace(s);
            if (this.asyncCallerStack != null) {
                s.println(ASYNC_CALLER_MESSAGE + this.callerThreadName);
                for (StackTraceElement element : this.asyncCallerStack) {
                    s.println("\tat " + element);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void printStackTrace(PrintWriter s) {
        PrintWriter printWriter = s;
        synchronized (printWriter) {
            super.printStackTrace(s);
            if (this.asyncCallerStack != null) {
                s.println(ASYNC_CALLER_MESSAGE + this.callerThreadName);
                for (StackTraceElement element : this.asyncCallerStack) {
                    s.println("\tat " + element);
                }
            }
        }
    }

    public String getErrorCode() {
        String codeSegment;
        String layerSegment;
        ILayer layer = this.getFormattedMessage().getLayer();
        if (layer == null) {
            layerSegment = "?";
            codeSegment = "";
        } else {
            layerSegment = layer.getCode();
            int msgErrorCode = this.getFormattedMessage().getCode();
            codeSegment = msgErrorCode > -1 ? String.valueOf(msgErrorCode) : "?";
        }
        return String.valueOf(layerSegment) + codeSegment;
    }

    public boolean isReportable() {
        return false;
    }
}

