/*
 * Decompiled with CFR 0.152.
 */
package com.arm.text;

import com.arm.text.ILayer;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Pattern;

public abstract class AbstractLayer
implements ILayer {
    private static Map<Pattern, AbstractLayer> layers = new HashMap<Pattern, AbstractLayer>();
    private final String code;

    public AbstractLayer(String code, Package pack) {
        if (pack == null) {
            throw new NullPointerException("pack can't be null");
        }
        for (ILayer iLayer : layers.values()) {
            if (!iLayer.getCode().equals(code)) continue;
            throw new IllegalArgumentException("attempted to initialise two layers with code " + code);
        }
        if (code.length() < 3 || !code.equals(code.toUpperCase())) {
            throw new IllegalArgumentException("code must be at least three capital letters");
        }
        this.code = code;
        String string = String.valueOf(pack.getName().replaceAll("\\.", "\\\\.")) + "(\\..*)?";
        layers.put(Pattern.compile(string), this);
    }

    @Override
    public String getCode() {
        return this.code;
    }
}

