/*
 * Decompiled with CFR 0.152.
 */
package com.arm.shell;

import java.util.ArrayList;

public class ArgumentParser {
    public String[] parse(CharSequence sequence) {
        ArrayList<String> arguments = new ArrayList<String>();
        Input input = new Input(sequence);
        while (input.hasMore()) {
            if (Character.isWhitespace(input.peek())) {
                input.consume();
                continue;
            }
            arguments.add(this.parseArgument(input));
        }
        return arguments.toArray(new String[arguments.size()]);
    }

    private String parseArgument(Input input) {
        StringBuilder arg = new StringBuilder();
        while (input.hasMore()) {
            if (Character.isWhitespace(input.peek())) break;
            int c = input.consume();
            switch (c) {
                case 39: {
                    this.parseSingleQuotes(input, arg);
                    break;
                }
                case 34: {
                    this.parseDoubleQuotes(input, arg);
                    break;
                }
                default: {
                    arg.append((char)c);
                }
            }
        }
        return arg.toString();
    }

    private void parseSingleQuotes(Input input, StringBuilder arg) {
        while (input.hasMore()) {
            int c = input.consume();
            if (c == 39) {
                return;
            }
            arg.append((char)c);
        }
        throw new IllegalStateException("Unclosed single quote");
    }

    private void parseDoubleQuotes(Input input, StringBuilder arg) {
        while (input.hasMore()) {
            int c = input.consume();
            switch (c) {
                case 34: {
                    return;
                }
                case 92: {
                    if (input.peek() == 34) {
                        arg.append((char)input.consume());
                        break;
                    }
                    arg.append((char)c);
                    break;
                }
                default: {
                    arg.append((char)c);
                }
            }
        }
        throw new IllegalStateException("Unclosed double quote");
    }

    private static class Input {
        private final CharSequence input;
        private final int max;
        private int next;

        Input(CharSequence input) {
            this.input = input;
            this.max = input.length();
        }

        boolean hasMore() {
            return this.next < this.max;
        }

        int peek() {
            return this.input.charAt(this.next);
        }

        int consume() {
            return this.input.charAt(this.next++);
        }
    }
}

