/*
 * Decompiled with CFR 0.152.
 */
package com.arm.io;

import com.arm.io.EndOfStreamListener;

public final class ProcessEndOfStreamListener
implements EndOfStreamListener {
    private final Process process;
    private final Thread listenerThread;
    private volatile boolean hasExited;

    public ProcessEndOfStreamListener(Process process) {
        if (process == null) {
            throw new NullPointerException("process can't be null");
        }
        this.process = process;
        this.listenerThread = new EndOfStreamListenerThread();
        this.listenerThread.start();
    }

    Thread getListenerThread() {
        return this.listenerThread;
    }

    @Override
    public boolean isDepleted() {
        return this.hasExited;
    }

    private class EndOfStreamListenerThread
    extends Thread {
        private EndOfStreamListenerThread() {
            super(String.valueOf(ProcessEndOfStreamListener.this.getClass().getName()) + " deamon thread");
            this.setDaemon(true);
        }

        @Override
        public void run() {
            try {
                ProcessEndOfStreamListener.this.process.waitFor();
            }
            catch (InterruptedException interruptedException) {}
            ProcessEndOfStreamListener.this.hasExited = true;
        }
    }
}

