/*
 * Decompiled with CFR 0.152.
 */
package com.arm.io;

import com.arm.io.IExtractListener;
import com.arm.io.JVMTempFolder;
import com.arm.io.Messages;
import com.arm.shell.ProcessHandler;
import com.arm.shell.ShellException;
import com.arm.util.HostInfo;
import com.arm.util.ICancelable;
import com.arm.util.Platform;
import com.arm.util.Ref;
import jakarta.annotation.Nonnull;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLConnection;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.nio.channels.OverlappingFileLockException;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.CodingErrorAction;
import java.nio.charset.MalformedInputException;
import java.nio.charset.UnmappableCharacterException;
import java.nio.charset.UnsupportedCharsetException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.Future;
import java.util.concurrent.TimeoutException;
import java.util.regex.Pattern;
import java.util.zip.Adler32;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;

public class Files {
    static MessageDigest md = null;
    public static final int TRIES_TO_CREATE_LOCK_FILE = 5;
    public static final long DEFAULT_LOCK_FILE_TIMEOUT = 120000L;
    public static final long DEFAULT_THREAD_SLEEP_TIME = 500L;
    private static volatile Pattern matchAbsoluteFilenames = null;
    private static Copier nioCopier = new NioCopier();
    public static final int FIND_FILESANDDIRECTORIES = 0;
    public static final int FIND_FILESONLY = 1;
    public static final int FIND_DIRECTORIESONLY = 2;

    public static byte[] getContent(File f) throws IOException {
        if (f.length() > Integer.MAX_VALUE) {
            throw new IOException("File too big");
        }
        return Files.getContent(f, 0, (int)f.length());
    }

    public static byte[] getContent(File f, int offset, int length) throws IOException {
        byte[] byArray;
        byte[] result = new byte[length];
        FileInputStream fis = null;
        DataInputStream dis = null;
        try {
            fis = new FileInputStream(f);
            dis = new DataInputStream(fis);
            dis.readFully(result);
            byArray = result;
        }
        catch (Throwable throwable) {
            Files.closeAll(dis, fis);
            throw throwable;
        }
        Files.closeAll(dis, fis);
        return byArray;
    }

    public static void writeContent(File f, byte[] data) throws IOException {
        try (FileOutputStream os = new FileOutputStream(f);){
            ((OutputStream)os).write(data);
        }
    }

    public static File getResource(Class<?> clazz, String name) throws IOException {
        File file;
        Class<?> originalClazz = clazz;
        URL resource = null;
        while (resource == null & clazz != null) {
            resource = clazz.getResource(name);
            clazz = clazz.getSuperclass();
        }
        if (resource == null) {
            throw new FileNotFoundException(String.valueOf(originalClazz.getCanonicalName()) + "/../" + name);
        }
        if (resource.getProtocol().equalsIgnoreCase("file")) {
            try {
                return new File(resource.toURI());
            }
            catch (URISyntaxException use) {
                throw new IOException(use);
            }
        }
        InputStream inputStream = null;
        try {
            URLConnection connection = resource.openConnection();
            inputStream = connection.getInputStream();
            byte[] ba = Files.getContent(inputStream);
            String ext = "tmp";
            String leaf = new File(name).getName();
            if (leaf.contains(".") && (ext = leaf.substring(leaf.indexOf(".") + 1)).isEmpty()) {
                ext = "tmp";
            }
            File f = Files.getTempFile(leaf, ext);
            f.deleteOnExit();
            Files.writeContent(f, ba);
            file = f;
        }
        catch (Throwable throwable) {
            Files.closeAll(inputStream);
            throw throwable;
        }
        Files.closeAll(inputStream);
        return file;
    }

    public static void writeContent(File f, String s) throws IOException, UnsupportedCharsetException, MalformedInputException, UnmappableCharacterException {
        Files.writeContent(f, s, "UTF-8");
    }

    public static void writeContent(File f, String s, String encoding) throws IOException, UnsupportedCharsetException, MalformedInputException, UnmappableCharacterException {
        try (FileOutputStream os = new FileOutputStream(f);){
            CharsetEncoder ce = Charset.forName(encoding).newEncoder().onMalformedInput(CodingErrorAction.REPORT).onUnmappableCharacter(CodingErrorAction.REPORT);
            ByteBuffer bb = ce.encode(CharBuffer.wrap(s));
            ((OutputStream)os).write(bb.array(), 0, bb.limit());
        }
    }

    public static void writeContent(File f, InputStream in) throws IOException {
        try (FileOutputStream os = new FileOutputStream(f);
             BufferedInputStream is = new BufferedInputStream(in);){
            int n = 0;
            byte[] buffer = new byte[0x400000];
            while ((n = ((InputStream)is).read(buffer)) != -1) {
                ((OutputStream)os).write(buffer, 0, n);
            }
        }
    }

    public static byte[] getContent(InputStream input) throws IOException {
        byte[] byArray;
        ByteArrayOutputStream baos = null;
        try {
            baos = new ByteArrayOutputStream();
            byte[] buffer = new byte[0x100000];
            int n = 0;
            while (-1 != (n = input.read(buffer))) {
                baos.write(buffer, 0, n);
            }
            byArray = baos.toByteArray();
        }
        catch (Throwable throwable) {
            Files.closeAll(baos);
            throw throwable;
        }
        Files.closeAll(baos);
        return byArray;
    }

    public static String getContent(File f, String encoding) throws IOException, UnsupportedEncodingException {
        CharsetDecoder cd = Charset.forName(encoding).newDecoder().onMalformedInput(CodingErrorAction.REPORT).onUnmappableCharacter(CodingErrorAction.REPORT);
        CharBuffer cb = cd.decode(ByteBuffer.wrap(Files.getContent(f)));
        return cb.toString();
    }

    public static String getContent(InputStream inputStream, String encoding) throws IOException, UnsupportedEncodingException {
        CharsetDecoder cd = Charset.forName(encoding).newDecoder().onMalformedInput(CodingErrorAction.REPORT).onUnmappableCharacter(CodingErrorAction.REPORT);
        CharBuffer cb = cd.decode(ByteBuffer.wrap(Files.getContent(inputStream)));
        return cb.toString();
    }

    static void enumerate(File root, List<? super File> result) {
        File[] child;
        result.add(root);
        if (root.isDirectory() && (child = root.listFiles()) != null && child.length > 0) {
            int i = 0;
            while (i < child.length) {
                Files.enumerate(child[i], result);
                ++i;
            }
        }
    }

    public static boolean isAbsolute(File path) {
        if (matchAbsoluteFilenames == null) {
            matchAbsoluteFilenames = Pattern.compile("([a-zA-Z]:)?(/|\\\\).*");
        }
        return matchAbsoluteFilenames.matcher(path.getPath()).matches();
    }

    private static void delete(File file, List<File> survivors) throws IOException {
        if (file != null && file.exists()) {
            File[] child;
            if (file.isDirectory() && (child = file.listFiles()) != null && child.length > 0) {
                int i = 0;
                while (i < child.length) {
                    Files.delete(child[i], survivors);
                    ++i;
                }
            }
            if (!file.delete() && file.exists()) {
                survivors.add(file);
            }
        }
    }

    public static List<File> delete(File file) throws IOException {
        ArrayList<File> survivors = new ArrayList<File>();
        Files.delete(file, survivors);
        return survivors;
    }

    public static List<File> delete(File file, boolean wipeEmptyParents) throws IOException {
        List<File> survivors = Files.delete(file);
        if (file != null && wipeEmptyParents) {
            File parent = file.getParentFile();
            while (parent != null && parent.delete()) {
                parent = parent.getParentFile();
            }
        }
        return survivors;
    }

    public static File freshFile(String leaf, String extension) {
        return Files.freshDir(new File(Platform.TMP), leaf, extension);
    }

    public static File freshDir() {
        return Files.freshDir("");
    }

    public static File freshDir(String leaf) {
        return Files.freshDir(new File(Platform.TMP), leaf);
    }

    public static File freshDir(File parent, String leaf) {
        return Files.freshDir(parent, leaf, null);
    }

    private static File freshDir(File parent, String leaf, String extension) {
        if (parent.exists() && !parent.isDirectory()) {
            throw new IllegalArgumentException(Messages.IS_NOT_DIRECTORY.getLocalisedValue(parent));
        }
        if (!parent.exists() && !parent.mkdirs()) {
            throw new RuntimeException("Failed to create parent of temporary file: " + parent);
        }
        File candidate = null;
        if ("".equals(leaf)) {
            candidate = new File(parent, String.valueOf(leaf) + (extension == null ? "" : "." + extension));
        }
        int smallestfree = 0;
        while (candidate == null || candidate.exists()) {
            candidate = new File(parent, String.valueOf(leaf) + "_" + smallestfree + (extension == null ? "" : "." + extension));
            ++smallestfree;
        }
        if (!candidate.getParentFile().exists() && !candidate.getParentFile().mkdirs()) {
            throw new RuntimeException("Failed to create candidate's parent");
        }
        if (candidate.exists()) {
            throw new RuntimeException("Error in File.freshDir(): candidate " + candidate + " already exists");
        }
        if (extension == null && !candidate.mkdirs()) {
            throw new RuntimeException("Failed to create candidate");
        }
        return candidate;
    }

    public static long checksum(File f) throws IOException {
        return Files.checksum(new FileInputStream(f));
    }

    public static long checksum(InputStream in) throws IOException {
        Adler32 ad = new Adler32();
        byte[] buffer = new byte[32768];
        int n = 0;
        while (n != -1) {
            n = in.read(buffer);
            if (n == -1) continue;
            ad.update(buffer);
        }
        in.close();
        return ad.getValue();
    }

    public static boolean isDirectoryWritable(File candidate) {
        boolean result = false;
        try {
            int existedCount = 0;
            File existing = candidate;
            while (existing != null && !existing.exists()) {
                ++existedCount;
                existing = existing.getParentFile();
            }
            if (!candidate.mkdirs()) {
                throw new IOException("Failed to create candidate");
            }
            File testFile = new File(candidate, "testWrite");
            if (!testFile.createNewFile()) {
                throw new IOException("Failed to create test file " + testFile);
            }
            result = testFile.canWrite();
            if (!testFile.delete()) {
                throw new IOException("Failed to delete test file " + testFile);
            }
            File temp = candidate;
            int i = 0;
            while (i < existedCount) {
                if (!temp.delete()) {
                    throw new IOException("Failed to delete temp file " + temp);
                }
                temp = temp.getParentFile();
                ++i;
            }
        }
        catch (IOException iOException) {}
        return result;
    }

    public static File cloneDir(File src) throws IOException {
        File tgt = Files.freshDir();
        Files.recursiveCopy(src, tgt);
        return tgt;
    }

    public static void recursiveCopy(File src, File tgt) throws IOException {
        if (src.exists() && tgt.exists() && src.isDirectory() != tgt.isDirectory()) {
            String message = Messages.SOURCE_TARGET_INCONSISTENT.getLocalisedValue(String.valueOf(src.getAbsolutePath()) + "\n   " + tgt.getAbsolutePath());
            throw new IllegalArgumentException(message);
        }
        if (src.isDirectory() && !tgt.exists() && !tgt.mkdirs()) {
            throw new IOException("Failed to create target " + tgt);
        }
        Files.simpleCopy(src, "", tgt, null);
    }

    public static Set<File> getDescendants(File f) {
        HashSet<File> result = new HashSet<File>();
        result.add(f);
        File[] child = f.listFiles();
        if (child != null) {
            int i = 0;
            while (i < child.length) {
                result.addAll(Files.getDescendants(child[i]));
                ++i;
            }
        }
        return result;
    }

    public static void simpleCopy(File srcbase, String relativePath, File tgtbase, FileFilter filter) throws IOException {
        File src = new File(srcbase, relativePath);
        File tgt = new File(tgtbase, relativePath);
        if (filter == null || filter.accept(src)) {
            if (src.isDirectory()) {
                File[] children = src.listFiles();
                int j = 0;
                while (children != null && j < children.length) {
                    int rellen = children[j].getAbsolutePath().length();
                    String rel = children[j].getAbsolutePath().substring(srcbase.getAbsolutePath().length(), rellen);
                    Files.simpleCopy(srcbase, rel, tgtbase, filter);
                    ++j;
                }
            } else {
                if (!tgt.getParentFile().mkdirs() && !tgt.getParentFile().exists()) {
                    throw new IOException("Failed to create target " + tgt);
                }
                nioCopier.copy(src, tgt);
            }
        }
    }

    public static void assertWritableDirectory(File candidate) throws IOException {
        String message = null;
        if (!candidate.isAbsolute()) {
            message = Messages.ENTER_ABSOLUTE_PATH.getLocalisedValue(new Object[0]);
        }
        if (candidate.exists() && !candidate.isDirectory()) {
            message = Messages.PLEASE_ENTER_DIRECTORY.getLocalisedValue(candidate.getAbsolutePath());
        }
        if (!Files.isDirectoryWritable(candidate)) {
            message = Messages.IS_NOT_WRITEABLE.getLocalisedValue(candidate.getAbsolutePath());
        }
        if (message != null) {
            throw new IOException(message);
        }
    }

    public static boolean contentEquals(File a, File b) throws IOException {
        try (FileInputStream isa = new FileInputStream(a);){
            boolean bl;
            FileInputStream isb = new FileInputStream(a);
            try {
                bl = Files.contentEquals(isa, isb);
            }
            catch (Throwable throwable) {
                isb.close();
                throw throwable;
            }
            isb.close();
            return bl;
        }
    }

    /*
     * Exception decompiling
     */
    public static boolean contentEquals(InputStream inA, InputStream inB) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [9[WHILELOOP]], but top level block is 3[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static String computeHash(File f) throws IOException {
        String string;
        FileInputStream is = null;
        try {
            is = new FileInputStream(f);
            string = Files.computeHash(is);
        }
        catch (Throwable throwable) {
            Files.closeAll(is);
            throw throwable;
        }
        Files.closeAll(is);
        return string;
    }

    public static synchronized String computeHash(InputStream is) throws IOException {
        if (md == null) {
            try {
                md = MessageDigest.getInstance("MD5");
            }
            catch (NoSuchAlgorithmException nsae) {
                throw new IOException(nsae.toString());
            }
        }
        byte[] block = new byte[32768];
        int read = is.read(block);
        while (read != -1) {
            md.update(block, 0, read);
            read = is.read(block);
        }
        byte[] digest = md.digest();
        StringBuilder result = new StringBuilder();
        int i = 0;
        while (i < digest.length) {
            int nibble = (0xFF & digest[i]) >> 4;
            result.append(Integer.toString(nibble, 16));
            nibble = 0xFF & digest[i] & 0xF;
            result.append(Integer.toString(nibble, 16));
            ++i;
        }
        return result.toString();
    }

    @Nonnull
    public static String[] getPlatformExecutableExtensions() {
        if (!Platform.isWindows()) {
            return new String[0];
        }
        String pathext = System.getenv("PATHEXT");
        if (pathext == null && (pathext = System.getenv("PathExt")) == null) {
            return new String[0];
        }
        return pathext.split(File.pathSeparator);
    }

    public static String which(String name) {
        String p;
        if (HostInfo.isWindows()) {
            p = System.getenv("Path");
            if (p == null) {
                p = System.getenv("PATH");
            }
        } else {
            p = System.getenv("PATH");
        }
        return Files.which(p, name);
    }

    public static String which(String path, String name) {
        if (HostInfo.isWindows()) {
            String e = Files.findOnPath(path, name);
            if (e == null) {
                String[] stringArray = Files.getPlatformExecutableExtensions();
                int n = stringArray.length;
                int n2 = 0;
                while (n2 < n) {
                    String ext = stringArray[n2];
                    e = Files.findOnPath(path, String.valueOf(name) + ext);
                    if (e != null) break;
                    ++n2;
                }
            }
            return e;
        }
        return Files.findOnPath(path, name);
    }

    private static String findOnPath(String env, String name) {
        if (env == null) {
            return null;
        }
        String[] path = env.split(File.pathSeparator);
        int i = 0;
        while (i < path.length) {
            File f = new File(path[i], name);
            if (f.exists() && f.isFile()) {
                return f.getAbsolutePath();
            }
            ++i;
        }
        return null;
    }

    public static String which2(String name) {
        String p = HostInfo.isWindows() ? System.getenv("Path") : System.getenv("PATH");
        if (p == null) {
            return null;
        }
        String[] path = p.split(File.pathSeparator);
        int i = 0;
        while (i < path.length) {
            File f = new File(path[i], name);
            if (f.exists() && f.isFile()) {
                return f.getAbsolutePath();
            }
            ++i;
        }
        String[] common = new String[]{"/usr/bin", "/usr/sbin", "/sbin", "/bin", "/usr/local/bin", "/usr/local/sbin"};
        int i2 = 0;
        while (i2 < common.length) {
            File f = new File(String.valueOf(common[i2]) + File.separator + name);
            if (f.exists() && f.isFile()) {
                return f.getAbsolutePath();
            }
            ++i2;
        }
        return null;
    }

    public static void copy(File src, File target) throws IOException {
        Files.copy(src, target, false);
    }

    public static void copy(File src, File target, boolean preservePermissions) throws IOException {
        Files.copy(src, target, preservePermissions, false);
    }

    public static void copy(File src, File target, boolean preservePermissions, boolean overwrite) throws IOException {
        if (src.isDirectory() && target.exists() && target.isDirectory()) {
            target = new File(target, src.getName());
        }
        Files.copyImpl(src, target, preservePermissions, overwrite);
    }

    public static void copy(List<File> srcs, File targetDir) throws IOException {
        Files.copy(srcs.toArray(new File[srcs.size()]), targetDir);
    }

    public static void copy(File[] srcs, File targetDir) throws IOException {
        Files.copy(srcs, targetDir, false);
    }

    public static void copy(File[] srcs, File targetDir, boolean preservePermissions) throws IOException {
        if (targetDir.exists()) {
            if (!targetDir.isDirectory()) {
                throw new IOException("Target directory '" + targetDir.getPath() + "' exists and is not a directory.");
            }
        } else if (!targetDir.mkdirs()) {
            throw new IOException("Could not create target directory.");
        }
        File[] fileArray = srcs;
        int n = srcs.length;
        int n2 = 0;
        while (n2 < n) {
            File src = fileArray[n2];
            if (src.isDirectory()) {
                Files.copy(src, targetDir, preservePermissions);
            } else {
                Files.copy(src, new File(targetDir, src.getName()), preservePermissions);
            }
            ++n2;
        }
    }

    private static void copyImpl(File src, File target, boolean preservePermissions, boolean overwrite) throws IOException {
        if (!overwrite && target.exists()) {
            throw new IOException("target '" + target.getPath() + "' already exists");
        }
        if (src.isDirectory()) {
            Files.mkdirs(target);
            File[] fileArray = Files.listFiles(src);
            int n = fileArray.length;
            int n2 = 0;
            while (n2 < n) {
                File child = fileArray[n2];
                Files.copyImpl(child, new File(target, child.getName()), preservePermissions, overwrite);
                ++n2;
            }
        } else {
            Files.mkdirs(target.getParentFile());
            FileInputStream is = null;
            try {
                is = new FileInputStream(src);
                Files.copy(is, target);
                if (preservePermissions) {
                    target.setExecutable(src.canExecute());
                    target.setReadable(src.canRead());
                    target.setWritable(src.canWrite());
                }
            }
            catch (Throwable throwable) {
                Files.closeAll(is);
                throw throwable;
            }
            Files.closeAll(is);
        }
    }

    public static void copy(InputStream src, File target) throws IOException {
        Files.copy(src, target, false);
    }

    public static void copy(InputStream src, File target, boolean lock) throws IOException {
        BufferedOutputStream out = null;
        BufferedInputStream in = null;
        FileOutputStream fos = null;
        try {
            FileLock lockFile;
            in = new BufferedInputStream(src);
            fos = new FileOutputStream(target);
            FileLock fileLock = lockFile = lock ? fos.getChannel().tryLock() : null;
            if (lockFile == null && lock) {
                throw new IOException("Unable to acquire lock");
            }
            try {
                out = new BufferedOutputStream(fos);
                byte[] buffer = new byte[0x100000];
                int n = 1;
                while (n > 0) {
                    n = ((InputStream)in).read(buffer);
                    if (n <= 0) continue;
                    ((OutputStream)out).write(buffer, 0, n);
                }
            }
            finally {
                if (lockFile != null) {
                    lockFile.close();
                }
            }
        }
        catch (Throwable throwable) {
            Files.closeAll(out, fos, in);
            throw throwable;
        }
        Files.closeAll(out, fos, in);
    }

    public static File find(String file, File directory, int type) throws IOException {
        if (!directory.isAbsolute()) {
            throw new IOException("relative directory path \"" + directory + "\" passed to Files.find");
        }
        if (!directory.exists()) {
            throw new FileNotFoundException("non-existent directory \"" + directory + "\" passed to Files.find");
        }
        if (!directory.isDirectory()) {
            throw new IOException("directory is really a file: \"" + directory + "\" passed to Files.find");
        }
        if (type != 0 && type != 1 && type != 2) {
            throw new IllegalArgumentException("bad type passed to Files.find");
        }
        File[] children = Files.listFiles(directory);
        String fileWithSlashPrefix = file.startsWith(File.separator) ? file : String.valueOf(File.separator) + file;
        int i = 0;
        while (i < children.length) {
            File result;
            File child = children[i];
            if (type == 0 || type == 2 && child.isDirectory() || type == 1 && child.isFile()) {
                if (!file.startsWith(File.separator) && child.getPath().endsWith(fileWithSlashPrefix)) {
                    return child;
                }
                if (file.startsWith(File.separator) && child.getPath().equals(file)) {
                    return child;
                }
            }
            if (child.isDirectory() && (result = Files.find(file, child, type)) != null) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static List<File> findFiles(File directory) throws IOException {
        return Files.findFiles(directory, true);
    }

    public static List<File> findFiles(File directory, boolean recursive) throws IOException {
        if (!directory.isAbsolute()) {
            throw new IOException("relative directory path \"" + directory + "\" passed to Files.find");
        }
        if (!directory.exists()) {
            throw new FileNotFoundException("non-existent directory \"" + directory + "\" passed to Files.find");
        }
        if (!directory.isDirectory()) {
            throw new IOException("directory is really a file: \"" + directory + "\" passed to Files.find");
        }
        ArrayList<File> result = new ArrayList<File>();
        Files.findImpl(directory, result, recursive);
        return result;
    }

    private static void findImpl(File directory, List<File> result, boolean recursive) {
        File[] fileArray = Files.listFiles(directory);
        int n = fileArray.length;
        int n2 = 0;
        while (n2 < n) {
            File f = fileArray[n2];
            if (recursive && f.isDirectory()) {
                Files.findImpl(f, result, recursive);
            } else {
                result.add(f);
            }
            ++n2;
        }
    }

    public static File getTempFile(String name, String extension) throws IOException {
        File temp = File.createTempFile(name, "." + extension);
        temp.deleteOnExit();
        return temp;
    }

    public static File createTempDir(String prefix) throws IOException {
        final File tempFile = File.createTempFile(prefix, "");
        if (!tempFile.delete() || tempFile.exists()) {
            throw new IOException("Unable to delete file: " + tempFile.getAbsolutePath());
        }
        if (!tempFile.mkdir() || !tempFile.exists()) {
            throw new IOException("Unable to create temp directory: " + tempFile.getAbsolutePath());
        }
        Runtime.getRuntime().addShutdownHook(new Thread(){

            @Override
            public void run() {
                if (tempFile.exists()) {
                    try {
                        Files.delete(tempFile);
                    }
                    catch (IOException iOException) {}
                }
            }
        });
        return tempFile;
    }

    public static void addOrReplace(File file, String key, String newValue, String separator, boolean prepend) throws IOException {
        Files.addOrReplace(file.getParentFile(), file.getName(), key, newValue, separator, prepend);
    }

    public static void addOrReplace(File parent, String file, String key, String newValue, String separator, boolean prepend) throws IOException {
        boolean separatorIsNewLine = separator.equals("\n") || separator.equals("\r") || separator.equals("\n\r") || separator.equals("\r\n");
        File src = new File(parent, file);
        if (!src.exists() && !src.createNewFile()) {
            throw new IOException("Failed to create source " + src);
        }
        FileInputStream fis = new FileInputStream(src);
        InputStreamReader reader = new InputStreamReader(fis);
        BufferedReader lineReader = new BufferedReader(reader);
        File tmp = File.createTempFile("~" + file, null, parent);
        FileOutputStream fos = new FileOutputStream(tmp);
        OutputStreamWriter writer = new OutputStreamWriter(fos);
        BufferedWriter lineWriter = new BufferedWriter(writer);
        if (prepend) {
            lineWriter.append(key);
            if (separatorIsNewLine) {
                lineWriter.newLine();
            } else {
                lineWriter.append(separator);
            }
            lineWriter.append(newValue);
            lineWriter.newLine();
        }
        boolean skipNextLine = false;
        String line = lineReader.readLine();
        while (line != null) {
            if (separatorIsNewLine && line.equalsIgnoreCase(key) || !separatorIsNewLine && line.toLowerCase().startsWith(String.valueOf(key) + separator)) {
                skipNextLine = separatorIsNewLine;
            } else if (skipNextLine) {
                skipNextLine = false;
            } else {
                lineWriter.append(line);
                lineWriter.newLine();
            }
            line = lineReader.readLine();
        }
        if (!prepend) {
            lineWriter.append(key);
            if (separatorIsNewLine) {
                lineWriter.newLine();
            } else {
                lineWriter.append(separator);
            }
            lineWriter.append(newValue);
            lineWriter.newLine();
        }
        Files.closeAll(lineWriter, lineReader);
        if (!src.delete()) {
            throw new IOException("Failed to delete source " + src);
        }
        if (!tmp.renameTo(src)) {
            throw new IOException("Failed to rename temp " + tmp + " to " + src);
        }
    }

    public static File getTempDir() {
        return new File(Platform.TMP);
    }

    public static File writeTempFile(String content) throws IOException {
        File f = File.createTempFile("tmp", null);
        f.deleteOnExit();
        Files.writeContent(f, content);
        return f;
    }

    public static void extractArchive(File archive, File destDir) throws IOException {
        Files.extractArchive(archive, destDir, (src, dst) -> {});
    }

    public static void extractZip(InputStream is, File destDir, IExtractListener listener) throws IOException {
        ZipInputStream zis = null;
        try {
            zis = new ZipInputStream(is);
            ZipEntry ze = null;
            while ((ze = zis.getNextEntry()) != null) {
                File file = new File(destDir, ze.getName());
                if (ze.isDirectory()) {
                    if (file.mkdir() || !file.exists()) continue;
                    throw new IOException("Unable to create directory: " + file);
                }
                Files.writeContent(file, Files.getContent(zis));
                listener.extractFile(ze.getName(), file);
            }
        }
        catch (Throwable throwable) {
            Files.closeAll(zis);
            throw throwable;
        }
        Files.closeAll(zis);
    }

    public static void extractZip(InputStream is, File destDir) throws IOException {
        Files.extractZip(is, destDir, (src, dst) -> {});
    }

    public static void extractArchive(File archive, File destDir, IExtractListener listener) throws IOException {
        block10: {
            if (destDir == null) {
                throw new IOException("Dest dir is null");
            }
            if (archive.getName().endsWith(".gz") || archive.getName().endsWith(".tar")) {
                try {
                    String tar;
                    ProcessHandler pw;
                    String zxf = "-xf";
                    if (archive.getName().endsWith(".gz")) {
                        zxf = "-zxf";
                    }
                    if ((pw = new ProcessHandler(destDir, new String[]{tar = HostInfo.isUnix() ? "tar" : "tar.exe", zxf, archive.getPath()})).executeAndWait() != 0) {
                        throw new IOException("Untar failed");
                    }
                    break block10;
                }
                catch (ShellException e) {
                    throw new IOException("Unable to extract archive: " + e.getMessage(), e);
                }
            }
            if (archive.getName().endsWith(".zip")) {
                FileInputStream fis = null;
                try {
                    fis = new FileInputStream(archive);
                    Files.extractZip(fis, destDir, listener);
                }
                catch (Throwable throwable) {
                    Files.closeAll(fis);
                    throw throwable;
                }
                Files.closeAll(fis);
            } else {
                throw new IOException("unrecognised archive type: " + archive);
            }
        }
    }

    public static void createFile(File dir, File file) throws IOException {
        Files.mkdirs(dir);
        Files.createFile(file);
    }

    public static void createFile(File file) throws IOException {
        if (!file.createNewFile() && !file.exists()) {
            throw new IOException("could not create file " + file);
        }
    }

    public static void mkdirs(File dir) throws IOException {
        if (!(dir.exists() && dir.isDirectory() || dir.mkdirs())) {
            throw new IOException("could not create folder " + dir);
        }
    }

    public static File createTempFile(String prefix, String suffix) throws IOException {
        return File.createTempFile(prefix, suffix, JVMTempFolder.getJVMTempFolder());
    }

    public static <T> Future<T> runWithLock(Callable<T> callable, File lockFile, long lockFileTimeout, long threadSleepTime) {
        return ForkJoinPool.commonPool().submit(() -> {
            Ref exception = new Ref();
            Ref result = new Ref();
            Files.runWithLock(() -> {
                try {
                    ref.v = callable.call();
                }
                catch (Exception e) {
                    ref2.v = e;
                }
            }, null, lockFile, lockFileTimeout, threadSleepTime);
            if (exception.v != null) {
                throw (Exception)exception.v;
            }
            return result.v;
        });
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void runWithLock(Runnable runnable, ICancelable cancelalbe, File lockFile, long lockFileTimeout, long threadSleepTime) throws TimeoutException {
        FileLock fileLock;
        FileOutputStream fos;
        block29: {
            if (runnable == null) {
                return;
            }
            if (lockFile == null) {
                runnable.run();
                return;
            }
            lockFileTimeout = lockFileTimeout < 0L ? 120000L : lockFileTimeout;
            threadSleepTime = threadSleepTime < 0L ? 500L : threadSleepTime;
            long count = 5L;
            while (!(cancelalbe != null && cancelalbe.isCancelled() || lockFile.exists() || count <= 0L)) {
                try {
                    Files.createFile(lockFile.getParentFile(), lockFile);
                }
                catch (IOException iOException) {}
                --count;
                try {
                    Thread.sleep(500L);
                }
                catch (InterruptedException interruptedException) {}
            }
            if (cancelalbe != null && cancelalbe.isCancelled()) {
                return;
            }
            if (!lockFile.exists()) {
                throw new TimeoutException(Messages.UNABLE_TO_CREATE_LOCK_FILE.getLocalisedValue(new Object[0]));
            }
            fos = null;
            fileLock = null;
            count = threadSleepTime == 0L ? 1L : lockFileTimeout / threadSleepTime;
            fos = new FileOutputStream(lockFile);
            do {
                try {
                    fileLock = fos.getChannel().tryLock();
                }
                catch (IOException | OverlappingFileLockException exception) {}
                if (fileLock != null) break;
                try {
                    Thread.sleep(threadSleepTime);
                }
                catch (InterruptedException interruptedException) {}
            } while (--count > 0L && (cancelalbe == null || !cancelalbe.isCancelled()));
            if (cancelalbe == null || !cancelalbe.isCancelled()) break block29;
            Files.closeIgnoringExceptions(fos);
            if (fileLock == null) return;
            try {
                fileLock.close();
                return;
            }
            catch (IOException iOException) {}
            return;
        }
        try {
            try {
                if (fileLock == null) {
                    throw new TimeoutException(Messages.UNABLE_TO_LOCK_FILE.getLocalisedValue(new Object[0]));
                }
                runnable.run();
            }
            catch (FileNotFoundException fileNotFoundException) {
                Files.closeIgnoringExceptions(fos);
                if (fileLock == null) return;
                try {
                    fileLock.close();
                    return;
                }
                catch (IOException iOException) {}
                return;
            }
        }
        catch (Throwable throwable) {
            Files.closeIgnoringExceptions(fos);
            if (fileLock == null) throw throwable;
            try {
                fileLock.close();
                throw throwable;
            }
            catch (IOException iOException) {}
            throw throwable;
        }
        Files.closeIgnoringExceptions(fos);
        if (fileLock == null) return;
        try {
            fileLock.close();
            return;
        }
        catch (IOException iOException) {}
    }

    public static File[] listFiles(File dir) {
        if (dir == null || dir.listFiles() == null) {
            return new File[0];
        }
        return dir.listFiles();
    }

    public static String[] list(File dir) {
        if (dir == null || dir.list() == null) {
            return new String[0];
        }
        return dir.list();
    }

    public static void closeIgnoringExceptions(Closeable c) {
        try {
            if (c != null) {
                c.close();
            }
        }
        catch (IOException iOException) {}
    }

    public static void closeAll(Closeable ... closeables) throws IOException {
        IOException firstIoe = null;
        Closeable[] closeableArray = closeables;
        int n = closeables.length;
        int n2 = 0;
        while (n2 < n) {
            block5: {
                Closeable c = closeableArray[n2];
                try {
                    if (c != null) {
                        c.close();
                    }
                }
                catch (IOException ioe) {
                    if (firstIoe != null) break block5;
                    firstIoe = ioe;
                }
            }
            ++n2;
        }
        if (firstIoe != null) {
            throw firstIoe;
        }
    }

    public static interface Copier {
        public void copy(File var1, File var2) throws IOException;
    }

    public static class NioCopier
    implements Copier {
        @Override
        public void copy(File s, File t) throws IOException {
            FileInputStream fis = null;
            FileOutputStream fos = null;
            FileChannel in = null;
            FileChannel out = null;
            try {
                fis = new FileInputStream(s);
                fos = new FileOutputStream(t);
                in = fis.getChannel();
                out = fos.getChannel();
                in.transferTo(0L, s.length(), out);
            }
            catch (Throwable throwable) {
                Files.closeAll(out, in, fos, fis);
                throw throwable;
            }
            Files.closeAll(out, in, fos, fis);
        }
    }
}

