/*
 * Decompiled with CFR 0.152.
 */
package com.arm.html;

import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public abstract class EntityReferences {
    private static final Map<String, Character> nameToChar = new HashMap<String, Character>();
    private static final Map<Character, String> charToName = new HashMap<Character, String>();
    private static final Pattern entityReferencePattern;
    private static final Pattern entityHexPattern;
    private static final Pattern entityDecimalPattern;

    static {
        nameToChar.put("&AElig;", Character.valueOf('\u00c6'));
        nameToChar.put("&Aacute;", Character.valueOf('\u00c1'));
        nameToChar.put("&Acirc;", Character.valueOf('\u00c2'));
        nameToChar.put("&Agrave;", Character.valueOf('\u00c0'));
        nameToChar.put("&Alpha;", Character.valueOf('\u0391'));
        nameToChar.put("&Aring;", Character.valueOf('\u00c5'));
        nameToChar.put("&Atilde;", Character.valueOf('\u00c3'));
        nameToChar.put("&Auml;", Character.valueOf('\u00c4'));
        nameToChar.put("&Beta;", Character.valueOf('\u0392'));
        nameToChar.put("&Ccedil;", Character.valueOf('\u00c7'));
        nameToChar.put("&Chi;", Character.valueOf('\u03a7'));
        nameToChar.put("&Dagger;", Character.valueOf('\u2021'));
        nameToChar.put("&Delta;", Character.valueOf('\u0394'));
        nameToChar.put("&ETH;", Character.valueOf('\u00d0'));
        nameToChar.put("&Eacute;", Character.valueOf('\u00c9'));
        nameToChar.put("&Ecirc;", Character.valueOf('\u00ca'));
        nameToChar.put("&Egrave;", Character.valueOf('\u00c8'));
        nameToChar.put("&Epsilon;", Character.valueOf('\u0395'));
        nameToChar.put("&Eta;", Character.valueOf('\u0397'));
        nameToChar.put("&Euml;", Character.valueOf('\u00cb'));
        nameToChar.put("&Gamma;", Character.valueOf('\u0393'));
        nameToChar.put("&Iacute;", Character.valueOf('\u00cd'));
        nameToChar.put("&Icirc;", Character.valueOf('\u00ce'));
        nameToChar.put("&Igrave;", Character.valueOf('\u00cc'));
        nameToChar.put("&Iota;", Character.valueOf('\u0399'));
        nameToChar.put("&Iuml;", Character.valueOf('\u00cf'));
        nameToChar.put("&Kappa;", Character.valueOf('\u039a'));
        nameToChar.put("&Lambda;", Character.valueOf('\u039b'));
        nameToChar.put("&Mu;", Character.valueOf('\u039c'));
        nameToChar.put("&Ntilde;", Character.valueOf('\u00d1'));
        nameToChar.put("&Nu;", Character.valueOf('\u039d'));
        nameToChar.put("&OElig;", Character.valueOf('\u0152'));
        nameToChar.put("&Oacute;", Character.valueOf('\u00d3'));
        nameToChar.put("&Ocirc;", Character.valueOf('\u00d4'));
        nameToChar.put("&Ograve;", Character.valueOf('\u00d2'));
        nameToChar.put("&Omega;", Character.valueOf('\u03a9'));
        nameToChar.put("&Omicron;", Character.valueOf('\u039f'));
        nameToChar.put("&Oslash;", Character.valueOf('\u00d8'));
        nameToChar.put("&Otilde;", Character.valueOf('\u00d5'));
        nameToChar.put("&Ouml;", Character.valueOf('\u00d6'));
        nameToChar.put("&Phi;", Character.valueOf('\u03a6'));
        nameToChar.put("&Pi;", Character.valueOf('\u03a0'));
        nameToChar.put("&Prime;", Character.valueOf('\u2033'));
        nameToChar.put("&Psi;", Character.valueOf('\u03a8'));
        nameToChar.put("&Rho;", Character.valueOf('\u03a1'));
        nameToChar.put("&Scaron;", Character.valueOf('\u0160'));
        nameToChar.put("&Sigma;", Character.valueOf('\u03a3'));
        nameToChar.put("&THORN;", Character.valueOf('\u00de'));
        nameToChar.put("&Tau;", Character.valueOf('\u03a4'));
        nameToChar.put("&Theta;", Character.valueOf('\u0398'));
        nameToChar.put("&Uacute;", Character.valueOf('\u00da'));
        nameToChar.put("&Ucirc;", Character.valueOf('\u00db'));
        nameToChar.put("&Ugrave;", Character.valueOf('\u00d9'));
        nameToChar.put("&Upsilon;", Character.valueOf('\u03a5'));
        nameToChar.put("&Uuml;", Character.valueOf('\u00dc'));
        nameToChar.put("&Xi;", Character.valueOf('\u039e'));
        nameToChar.put("&Yacute;", Character.valueOf('\u00dd'));
        nameToChar.put("&Yuml;", Character.valueOf('\u0178'));
        nameToChar.put("&Zeta;", Character.valueOf('\u0396'));
        nameToChar.put("&aacute;", Character.valueOf('\u00e1'));
        nameToChar.put("&acirc;", Character.valueOf('\u00e2'));
        nameToChar.put("&acute;", Character.valueOf('\u00b4'));
        nameToChar.put("&aelig;", Character.valueOf('\u00e6'));
        nameToChar.put("&agrave;", Character.valueOf('\u00e0'));
        nameToChar.put("&alefsym;", Character.valueOf('\u2135'));
        nameToChar.put("&alpha;", Character.valueOf('\u03b1'));
        nameToChar.put("&amp;", Character.valueOf('&'));
        nameToChar.put("&and;", Character.valueOf('\u2227'));
        nameToChar.put("&ang;", Character.valueOf('\u2220'));
        nameToChar.put("&aring;", Character.valueOf('\u00e5'));
        nameToChar.put("&asymp;", Character.valueOf('\u2248'));
        nameToChar.put("&atilde;", Character.valueOf('\u00e3'));
        nameToChar.put("&auml;", Character.valueOf('\u00e4'));
        nameToChar.put("&bdquo;", Character.valueOf('\u201e'));
        nameToChar.put("&beta;", Character.valueOf('\u03b2'));
        nameToChar.put("&brvbar;", Character.valueOf('\u00a6'));
        nameToChar.put("&bull;", Character.valueOf('\u2022'));
        nameToChar.put("&cap;", Character.valueOf('\u2229'));
        nameToChar.put("&ccedil;", Character.valueOf('\u00e7'));
        nameToChar.put("&cedil;", Character.valueOf('\u00b8'));
        nameToChar.put("&cent;", Character.valueOf('\u00a2'));
        nameToChar.put("&chi;", Character.valueOf('\u03c7'));
        nameToChar.put("&circ;", Character.valueOf('\u02c6'));
        nameToChar.put("&clubs;", Character.valueOf('\u2663'));
        nameToChar.put("&cong;", Character.valueOf('\u2245'));
        nameToChar.put("&copy;", Character.valueOf('\u00a9'));
        nameToChar.put("&crarr;", Character.valueOf('\u21b5'));
        nameToChar.put("&cup;", Character.valueOf('\u222a'));
        nameToChar.put("&curren;", Character.valueOf('\u00a4'));
        nameToChar.put("&dArr;", Character.valueOf('\u21d3'));
        nameToChar.put("&dagger;", Character.valueOf('\u2020'));
        nameToChar.put("&darr;", Character.valueOf('\u2193'));
        nameToChar.put("&deg;", Character.valueOf('\u00b0'));
        nameToChar.put("&delta;", Character.valueOf('\u03b4'));
        nameToChar.put("&diams;", Character.valueOf('\u2666'));
        nameToChar.put("&divide;", Character.valueOf('\u00f7'));
        nameToChar.put("&eacute;", Character.valueOf('\u00e9'));
        nameToChar.put("&ecirc;", Character.valueOf('\u00ea'));
        nameToChar.put("&egrave;", Character.valueOf('\u00e8'));
        nameToChar.put("&empty;", Character.valueOf('\u2205'));
        nameToChar.put("&emsp;", Character.valueOf('\u2003'));
        nameToChar.put("&ensp;", Character.valueOf('\u2002'));
        nameToChar.put("&epsilon;", Character.valueOf('\u03b5'));
        nameToChar.put("&equiv;", Character.valueOf('\u2261'));
        nameToChar.put("&eta;", Character.valueOf('\u03b7'));
        nameToChar.put("&eth;", Character.valueOf('\u00f0'));
        nameToChar.put("&euml;", Character.valueOf('\u00eb'));
        nameToChar.put("&euro;", Character.valueOf('\u20ac'));
        nameToChar.put("&exist;", Character.valueOf('\u2203'));
        nameToChar.put("&fnof;", Character.valueOf('\u0192'));
        nameToChar.put("&forall;", Character.valueOf('\u2200'));
        nameToChar.put("&frac12;", Character.valueOf('\u00bd'));
        nameToChar.put("&frac14;", Character.valueOf('\u00bc'));
        nameToChar.put("&frac34;", Character.valueOf('\u00be'));
        nameToChar.put("&frasl;", Character.valueOf('\u2044'));
        nameToChar.put("&gamma;", Character.valueOf('\u03b3'));
        nameToChar.put("&ge;", Character.valueOf('\u2265'));
        nameToChar.put("&gt;", Character.valueOf('>'));
        nameToChar.put("&hArr;", Character.valueOf('\u21d4'));
        nameToChar.put("&harr;", Character.valueOf('\u2194'));
        nameToChar.put("&hearts;", Character.valueOf('\u2665'));
        nameToChar.put("&hellip;", Character.valueOf('\u2026'));
        nameToChar.put("&iacute;", Character.valueOf('\u00ed'));
        nameToChar.put("&icirc;", Character.valueOf('\u00ee'));
        nameToChar.put("&iexcl;", Character.valueOf('\u00a1'));
        nameToChar.put("&igrave;", Character.valueOf('\u00ec'));
        nameToChar.put("&image;", Character.valueOf('\u2111'));
        nameToChar.put("&infin;", Character.valueOf('\u221e'));
        nameToChar.put("&int;", Character.valueOf('\u222b'));
        nameToChar.put("&iota;", Character.valueOf('\u03b9'));
        nameToChar.put("&iquest;", Character.valueOf('\u00bf'));
        nameToChar.put("&isin;", Character.valueOf('\u2208'));
        nameToChar.put("&iuml;", Character.valueOf('\u00ef'));
        nameToChar.put("&kappa;", Character.valueOf('\u03ba'));
        nameToChar.put("&lArr;", Character.valueOf('\u21d0'));
        nameToChar.put("&lambda;", Character.valueOf('\u03bb'));
        nameToChar.put("&lang;", Character.valueOf('\u2329'));
        nameToChar.put("&laquo;", Character.valueOf('\u00ab'));
        nameToChar.put("&larr;", Character.valueOf('\u2190'));
        nameToChar.put("&lceil;", Character.valueOf('\u2308'));
        nameToChar.put("&ldquo;", Character.valueOf('\u201c'));
        nameToChar.put("&le;", Character.valueOf('\u2264'));
        nameToChar.put("&lfloor;", Character.valueOf('\u230a'));
        nameToChar.put("&lowast;", Character.valueOf('\u2217'));
        nameToChar.put("&loz;", Character.valueOf('\u25ca'));
        nameToChar.put("&lrm;", Character.valueOf('\u200e'));
        nameToChar.put("&lsaquo;", Character.valueOf('\u2039'));
        nameToChar.put("&lsquo;", Character.valueOf('\u2018'));
        nameToChar.put("&lt;", Character.valueOf('<'));
        nameToChar.put("&macr;", Character.valueOf('\u00af'));
        nameToChar.put("&mdash;", Character.valueOf('\u2014'));
        nameToChar.put("&micro;", Character.valueOf('\u00b5'));
        nameToChar.put("&middot;", Character.valueOf('\u00b7'));
        nameToChar.put("&minus;", Character.valueOf('\u2212'));
        nameToChar.put("&mu;", Character.valueOf('\u03bc'));
        nameToChar.put("&nabla;", Character.valueOf('\u2207'));
        nameToChar.put("&nbsp;", Character.valueOf('\u00a0'));
        nameToChar.put("&ndash;", Character.valueOf('\u2013'));
        nameToChar.put("&ne;", Character.valueOf('\u2260'));
        nameToChar.put("&ni;", Character.valueOf('\u220b'));
        nameToChar.put("&not;", Character.valueOf('\u00ac'));
        nameToChar.put("&notin;", Character.valueOf('\u2209'));
        nameToChar.put("&nsub;", Character.valueOf('\u2284'));
        nameToChar.put("&ntilde;", Character.valueOf('\u00f1'));
        nameToChar.put("&nu;", Character.valueOf('\u03bd'));
        nameToChar.put("&oacute;", Character.valueOf('\u00f3'));
        nameToChar.put("&ocirc;", Character.valueOf('\u00f4'));
        nameToChar.put("&oelig;", Character.valueOf('\u0153'));
        nameToChar.put("&ograve;", Character.valueOf('\u00f2'));
        nameToChar.put("&oline;", Character.valueOf('\u203e'));
        nameToChar.put("&omega;", Character.valueOf('\u03c9'));
        nameToChar.put("&omicron;", Character.valueOf('\u03bf'));
        nameToChar.put("&oplus;", Character.valueOf('\u2295'));
        nameToChar.put("&or;", Character.valueOf('\u2228'));
        nameToChar.put("&ordf;", Character.valueOf('\u00aa'));
        nameToChar.put("&ordm;", Character.valueOf('\u00ba'));
        nameToChar.put("&oslash;", Character.valueOf('\u00f8'));
        nameToChar.put("&otilde;", Character.valueOf('\u00f5'));
        nameToChar.put("&otimes;", Character.valueOf('\u2297'));
        nameToChar.put("&ouml;", Character.valueOf('\u00f6'));
        nameToChar.put("&para;", Character.valueOf('\u00b6'));
        nameToChar.put("&part;", Character.valueOf('\u2202'));
        nameToChar.put("&permil;", Character.valueOf('\u2030'));
        nameToChar.put("&perp;", Character.valueOf('\u22a5'));
        nameToChar.put("&phi;", Character.valueOf('\u03c6'));
        nameToChar.put("&pi;", Character.valueOf('\u03c0'));
        nameToChar.put("&piv;", Character.valueOf('\u03d6'));
        nameToChar.put("&plusmn;", Character.valueOf('\u00b1'));
        nameToChar.put("&pound;", Character.valueOf('\u00a3'));
        nameToChar.put("&prime;", Character.valueOf('\u2032'));
        nameToChar.put("&prod;", Character.valueOf('\u220f'));
        nameToChar.put("&prop;", Character.valueOf('\u221d'));
        nameToChar.put("&psi;", Character.valueOf('\u03c8'));
        nameToChar.put("&quot;", Character.valueOf('\"'));
        nameToChar.put("&rArr;", Character.valueOf('\u21d2'));
        nameToChar.put("&radic;", Character.valueOf('\u221a'));
        nameToChar.put("&rang;", Character.valueOf('\u232a'));
        nameToChar.put("&raquo;", Character.valueOf('\u00bb'));
        nameToChar.put("&rarr;", Character.valueOf('\u2192'));
        nameToChar.put("&rceil;", Character.valueOf('\u2309'));
        nameToChar.put("&rdquo;", Character.valueOf('\u201d'));
        nameToChar.put("&real;", Character.valueOf('\u211c'));
        nameToChar.put("&reg;", Character.valueOf('\u00ae'));
        nameToChar.put("&rfloor;", Character.valueOf('\u230b'));
        nameToChar.put("&rho;", Character.valueOf('\u03c1'));
        nameToChar.put("&rlm;", Character.valueOf('\u200f'));
        nameToChar.put("&rsaquo;", Character.valueOf('\u203a'));
        nameToChar.put("&rsquo;", Character.valueOf('\u2019'));
        nameToChar.put("&sbquo;", Character.valueOf('\u201a'));
        nameToChar.put("&scaron;", Character.valueOf('\u0161'));
        nameToChar.put("&sdot;", Character.valueOf('\u22c5'));
        nameToChar.put("&sect;", Character.valueOf('\u00a7'));
        nameToChar.put("&shy;", Character.valueOf('\u00ad'));
        nameToChar.put("&sigma;", Character.valueOf('\u03c3'));
        nameToChar.put("&sigmaf;", Character.valueOf('\u03c2'));
        nameToChar.put("&sim;", Character.valueOf('\u223c'));
        nameToChar.put("&spades;", Character.valueOf('\u2660'));
        nameToChar.put("&sub;", Character.valueOf('\u2282'));
        nameToChar.put("&sube;", Character.valueOf('\u2286'));
        nameToChar.put("&sum;", Character.valueOf('\u2211'));
        nameToChar.put("&sup;", Character.valueOf('\u2283'));
        nameToChar.put("&sup1;", Character.valueOf('\u00b9'));
        nameToChar.put("&sup2;", Character.valueOf('\u00b2'));
        nameToChar.put("&sup3;", Character.valueOf('\u00b3'));
        nameToChar.put("&supe;", Character.valueOf('\u2287'));
        nameToChar.put("&szlig;", Character.valueOf('\u00df'));
        nameToChar.put("&tau;", Character.valueOf('\u03c4'));
        nameToChar.put("&there4;", Character.valueOf('\u2234'));
        nameToChar.put("&theta;", Character.valueOf('\u03b8'));
        nameToChar.put("&thetasym;", Character.valueOf('\u03d1'));
        nameToChar.put("&thinsp;", Character.valueOf('\u2009'));
        nameToChar.put("&thorn;", Character.valueOf('\u00fe'));
        nameToChar.put("&tilde;", Character.valueOf('\u02dc'));
        nameToChar.put("&times;", Character.valueOf('\u00d7'));
        nameToChar.put("&trade;", Character.valueOf('\u2122'));
        nameToChar.put("&uArr;", Character.valueOf('\u21d1'));
        nameToChar.put("&uacute;", Character.valueOf('\u00fa'));
        nameToChar.put("&uarr;", Character.valueOf('\u2191'));
        nameToChar.put("&ucirc;", Character.valueOf('\u00fb'));
        nameToChar.put("&ugrave;", Character.valueOf('\u00f9'));
        nameToChar.put("&uml;", Character.valueOf('\u00a8'));
        nameToChar.put("&upsih;", Character.valueOf('\u03d2'));
        nameToChar.put("&upsilon;", Character.valueOf('\u03c5'));
        nameToChar.put("&uuml;", Character.valueOf('\u00fc'));
        nameToChar.put("&weierp;", Character.valueOf('\u2118'));
        nameToChar.put("&xi;", Character.valueOf('\u03be'));
        nameToChar.put("&yacute;", Character.valueOf('\u00fd'));
        nameToChar.put("&yen;", Character.valueOf('\u00a5'));
        nameToChar.put("&yuml;", Character.valueOf('\u00ff'));
        nameToChar.put("&zeta;", Character.valueOf('\u03b6'));
        nameToChar.put("&zwj;", Character.valueOf('\u200d'));
        nameToChar.put("&zwnj;", Character.valueOf('\u200c'));
        for (Map.Entry<String, Character> entry : nameToChar.entrySet()) {
            charToName.put(entry.getValue(), entry.getKey());
        }
        entityReferencePattern = Pattern.compile("(&(?:[A-Za-z]{2,8}|#[0-9]+|#[Xx][A-Fa-f0-9]+);)");
        entityHexPattern = Pattern.compile("&#[Xx]([A-Fa-f0-9]+);");
        entityDecimalPattern = Pattern.compile("&#([0-9]+);");
    }

    public static Character nameToChar(String name) {
        return nameToChar.get(name);
    }

    public static String charToName(Character ch) {
        return charToName.get(ch);
    }

    public static String encode(String s) {
        StringBuilder r = new StringBuilder(s.length());
        int n = 0;
        while (n < s.length()) {
            char c = s.charAt(n);
            String encoded = EntityReferences.charToName(Character.valueOf(c));
            if (encoded != null) {
                r.append(encoded);
            } else {
                r.append(c);
            }
            ++n;
        }
        return r.toString();
    }

    public static String decode(String s) {
        StringBuffer result = new StringBuffer();
        Matcher matcher = entityReferencePattern.matcher(s);
        while (matcher.find()) {
            Matcher decMatcher;
            Character c;
            String match = matcher.group(1);
            Matcher hexMatcher = entityHexPattern.matcher(match);
            if (hexMatcher.matches()) {
                String hexNum = hexMatcher.group(1);
                try {
                    c = Character.valueOf((char)Integer.parseInt(hexNum, 16));
                    matcher.appendReplacement(result, c.toString());
                    continue;
                }
                catch (NumberFormatException numberFormatException) {}
            }
            if ((decMatcher = entityDecimalPattern.matcher(match)).matches()) {
                String decNum = decMatcher.group(1);
                try {
                    Character c2 = Character.valueOf((char)Integer.parseInt(decNum, 10));
                    matcher.appendReplacement(result, c2.toString());
                    continue;
                }
                catch (NumberFormatException numberFormatException) {}
            }
            if ((c = EntityReferences.nameToChar(match)) == null) continue;
            matcher.appendReplacement(result, c.toString());
        }
        matcher.appendTail(result);
        return result.toString();
    }
}

