/*
 * Decompiled with CFR 0.152.
 */
package com.arm.licensing.toolkits;

import com.arm.licensing.manager.LicensingConfiguration;
import com.arm.licensing.toolkits.EnvVariable;
import com.arm.licensing.toolkits.EnvVariableToolkitSetting;
import com.arm.licensing.toolkits.IToolkitDatabase;
import com.arm.licensing.toolkits.IToolkitFilter;
import com.arm.licensing.toolkits.IToolkitSelector;
import com.arm.licensing.toolkits.IToolkitSetting;
import com.arm.licensing.toolkits.ToolkitSelector;
import java.io.File;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.function.Function;

public class ToolkitSelectorManager {
    public static final String LICMAP_ENVIRONMENT_VARIABLE = "ARM_PRODUCT_DEF";
    private static final EnvVariable LICMAP_ENV_VAR = new EnvVariable("ARM_PRODUCT_DEF", "%1$s", EnvVariable.Action.SET);
    private static final String ENVIRONMENT_FILE_NAME = "env.ini";
    private static final ToolkitSelectorManager INSTANCE = new ToolkitSelectorManager();
    private IToolkitSelector current;
    private ArrayList<IToolkitSelectorListener> listeners = new ArrayList();

    public static ToolkitSelectorManager getInstance() {
        return INSTANCE;
    }

    private ToolkitSelectorManager() {
    }

    public void addListener(IToolkitSelectorListener listener) {
        if (listener == null || this.listeners.contains(listener)) {
            return;
        }
        this.listeners.add(listener);
    }

    public void removeListener(IToolkitSelectorListener listener) {
        this.listeners.remove(listener);
    }

    public IToolkitSelector getCurrent() {
        return this.current;
    }

    private void notifyListeners(IToolkitSelector oldObject, IToolkitSelector newObject) {
        IToolkitSelectorListener[] iToolkitSelectorListenerArray = this.listeners.toArray(new IToolkitSelectorListener[0]);
        int n = iToolkitSelectorListenerArray.length;
        int n2 = 0;
        while (n2 < n) {
            IToolkitSelectorListener l = iToolkitSelectorListenerArray[n2];
            l.toolkitSelectorChanged(oldObject, newObject);
            ++n2;
        }
    }

    public IToolkitSelector createToolkitSelector(Function<File, ? extends LicensingConfiguration> configFactory, IToolkitDatabase database, IToolkitFilter filter, File dir) {
        EnvVariableToolkitSetting setting = new EnvVariableToolkitSetting(Paths.get(dir.getAbsolutePath(), ENVIRONMENT_FILE_NAME), LICMAP_ENV_VAR, new EnvVariable[0]);
        return this.createToolkitSelector(configFactory, database, filter, setting);
    }

    public synchronized IToolkitSelector createToolkitSelector(Function<File, ? extends LicensingConfiguration> configFactory, IToolkitDatabase database, IToolkitFilter filter, IToolkitSetting setting) {
        IToolkitSelector oldObject = this.current;
        this.current = new ToolkitSelector(configFactory, database, filter, setting);
        this.notifyListeners(oldObject, this.current);
        return this.current;
    }

    public static interface IToolkitSelectorListener {
        public void toolkitSelectorChanged(IToolkitSelector var1, IToolkitSelector var2);
    }
}

