/*
 * Decompiled with CFR 0.152.
 */
package com.arm.licensing.toolkits;

import com.arm.licensing.manager.LicenseException;
import com.arm.licensing.manager.LicensingConfiguration;
import com.arm.licensing.manager.LicensingManager;
import com.arm.licensing.toolkits.DatabaseException;
import com.arm.licensing.toolkits.IToolkitDatabase;
import com.arm.licensing.toolkits.IToolkitFilter;
import com.arm.licensing.toolkits.IToolkitSelectionChangedListener;
import com.arm.licensing.toolkits.IToolkitSelector;
import com.arm.licensing.toolkits.IToolkitSetting;
import com.arm.licensing.toolkits.Messages;
import com.arm.licensing.toolkits.Toolkit;
import com.arm.licensing.toolkits.ToolkitSelection;
import com.arm.licensing.toolkits.ToolkitSelectorException;
import com.arm.util.Objects;
import java.io.File;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import javax.annotation.Nonnull;

public class ToolkitSelector
implements IToolkitSelector {
    private final Function<File, ? extends LicensingConfiguration> configFactory;
    private final IToolkitDatabase database;
    private final IToolkitFilter filter;
    private final IToolkitSetting setting;
    private Set<Toolkit> availableToolkits = null;
    private Toolkit selectedToolkit = null;
    private Set<IToolkitSelectionChangedListener> listeners = new HashSet<IToolkitSelectionChangedListener>();

    ToolkitSelector(@Nonnull Function<File, ? extends LicensingConfiguration> configFactory, @Nonnull IToolkitDatabase database, @Nonnull IToolkitFilter filter, @Nonnull IToolkitSetting setting) {
        this.configFactory = configFactory;
        this.database = database;
        this.filter = filter;
        this.setting = setting;
    }

    @Override
    public Toolkit getSelectedToolkit() throws ToolkitSelectorException {
        this.loadSelectedToolkit();
        return this.selectedToolkit;
    }

    @Override
    public ToolkitSelection getToolkitSelection() throws ToolkitSelectorException {
        this.loadAvailableToolkits();
        this.loadSelectedToolkit();
        if (this.selectedToolkit != null) {
            return new ToolkitSelection(this.selectedToolkit, this.availableToolkits, true);
        }
        Toolkit selected = this.autoSelectToolkit(this.availableToolkits);
        if (selected != null) {
            boolean applied = this.setSelectedToolkit(selected);
            return new ToolkitSelection(this.selectedToolkit, this.availableToolkits, applied);
        }
        return new ToolkitSelection(this.selectedToolkit, this.availableToolkits, true);
    }

    @Override
    public ToolkitSelection selectToolkit(Toolkit toolkit) throws ToolkitSelectorException {
        this.loadAvailableToolkits();
        boolean applied = this.setSelectedToolkit(toolkit);
        return new ToolkitSelection(this.selectedToolkit, this.availableToolkits, applied);
    }

    private Toolkit findEquivalentToolkitInDatabase(File licmap) throws ToolkitSelectorException {
        File toolkitLicmap;
        this.loadAvailableToolkits();
        for (Toolkit toolkit : this.availableToolkits) {
            toolkitLicmap = toolkit.getLicenseMappingFile();
            if (!licmap.equals(toolkitLicmap)) continue;
            return toolkit;
        }
        try {
            for (Toolkit toolkit : this.database.getToolkits()) {
                toolkitLicmap = toolkit.getLicenseMappingFile();
                if (!toolkitLicmap.equals(licmap)) continue;
                return toolkit;
            }
        }
        catch (DatabaseException e) {
            throw new ToolkitSelectorException(e.getLocalizedMessage(), e);
        }
        return null;
    }

    @Override
    public Set<Toolkit> getAllToolkits() throws ToolkitSelectorException {
        try {
            return this.database.getToolkits();
        }
        catch (DatabaseException de) {
            throw new ToolkitSelectorException(de.getLocalizedMessage(), de);
        }
    }

    @Override
    public boolean isValid(Toolkit toolkit) throws ToolkitSelectorException {
        if (toolkit == null) {
            return false;
        }
        this.loadAvailableToolkits();
        return this.availableToolkits.contains(toolkit);
    }

    private void loadAvailableToolkits() throws ToolkitSelectorException {
        if (this.availableToolkits == null) {
            try {
                this.availableToolkits = this.filter.filter(this.database.getToolkits());
            }
            catch (DatabaseException e) {
                throw new ToolkitSelectorException(e.getLocalizedMessage(), e);
            }
        }
    }

    private void loadSelectedToolkit() throws ToolkitSelectorException {
        Optional<File> settingValue = this.setting.get();
        if (!settingValue.isPresent()) {
            this.selectedToolkit = null;
            return;
        }
        File licmap = settingValue.get();
        if (this.selectedToolkit != null && licmap.equals(this.selectedToolkit.getLicenseMappingFile())) {
            return;
        }
        this.selectedToolkit = this.findEquivalentToolkitInDatabase(licmap);
        if (this.selectedToolkit == null) {
            try {
                this.selectedToolkit = new Toolkit(licmap);
            }
            catch (LicenseException licenseException) {}
        }
        this.fireToolkitSelectionChangedEvent();
    }

    private boolean setSelectedToolkit(Toolkit selected) throws ToolkitSelectorException {
        Toolkit oldSelection = this.selectedToolkit;
        this.selectedToolkit = selected;
        if (selected != null) {
            try {
                LicensingManager.setConfiguration(this.configFactory.apply(selected.getLicenseMappingFile()));
            }
            catch (LicensingManager.LicensingManagerInitialisationFailedException e) {
                throw new ToolkitSelectorException(Messages.ERROR_FAILED_TO_LOAD_TOOLKIT_SELECTION.getLocalisedValue(selected.getProductName(), e.getLocalizedMessage()), e);
            }
        }
        boolean applied = this.setting.set(selected == null ? null : selected.getLicenseMappingFile());
        if (!Objects.equals((Object)oldSelection, (Object)selected)) {
            this.fireToolkitSelectionChangedEvent();
        }
        return applied;
    }

    private Toolkit autoSelectToolkit(Set<Toolkit> toolkits) {
        return toolkits.size() == 1 ? toolkits.iterator().next() : null;
    }

    @Override
    public void flushToolkitsCache() {
        this.availableToolkits = null;
    }

    private void fireToolkitSelectionChangedEvent() {
        for (IToolkitSelectionChangedListener listener : this.listeners) {
            listener.toolkitSelectionChanged(this.selectedToolkit);
        }
    }

    @Override
    public void addToolkitSelectionChangedListener(@Nonnull IToolkitSelectionChangedListener listener) {
        this.listeners.add(listener);
    }

    @Override
    public void removeToolkitSelectionChangedListener(@Nonnull IToolkitSelectionChangedListener listener) {
        this.listeners.remove(listener);
    }
}

