/*
 * Decompiled with CFR 0.152.
 */
package com.arm.licensing.toolkits;

import com.arm.licensing.manager.ILicensingInterface;
import com.arm.licensing.manager.LicenseException;
import com.arm.licensing.manager.LicensingConfiguration;
import com.arm.licensing.manager.LicensingManager;
import com.arm.licensing.toolkits.Messages;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Nonnull;

public class Toolkit
implements Comparable<Toolkit> {
    private static final int DEFAULT_EDITION_ORDER = 50;
    private final File licenseMappingFile;
    private final String productName;
    private final String name;
    private final String key;
    private final int order;
    private final Type type;
    private final Map<String, String> customInfos;

    public Toolkit(@Nonnull File licmap) throws LicenseException {
        try {
            this.licenseMappingFile = licmap.getCanonicalFile();
        }
        catch (IOException e) {
            throw new LicenseException(Messages.ERROR_FAILED_TO_LOAD_TOOLKIT.getLocalisedValue(licmap.getAbsolutePath(), e.getLocalizedMessage()));
        }
        if (!(this.licenseMappingFile.isFile() && this.licenseMappingFile.canRead() && this.licenseMappingFile.getName().endsWith("elmap"))) {
            throw new LicenseException(Messages.ERROR_INVALID_TOOLKIT_FOUND.getLocalisedValue(this.licenseMappingFile.getAbsolutePath()));
        }
        ILicensingInterface toolkitInterface = LicensingManager.createNonGlobalInstance(new LicensingConfiguration(this.licenseMappingFile, null));
        try {
            Optional<String> productName = toolkitInterface.getInfo("product.name");
            Optional<String> editionName = toolkitInterface.getInfo("product.edition.name");
            Optional<String> editionKey = toolkitInterface.getInfo("product.edition.key");
            Optional<String> editionOrder = toolkitInterface.getInfo("product.edition.order");
            Optional<String> editionType = toolkitInterface.getInfo("product.edition.type");
            if (!editionKey.isPresent() || editionKey.get().isEmpty() || !editionName.isPresent() || editionName.get().isEmpty() || !productName.isPresent() || productName.get().isEmpty()) {
                throw new LicenseException(Messages.ERROR_INVALID_TOOLKIT_FOUND.getLocalisedValue(this.licenseMappingFile.getAbsolutePath()));
            }
            this.productName = productName.get();
            this.name = editionName.get();
            this.key = editionKey.get();
            this.order = editionOrder.map(Integer::valueOf).orElse(50);
            this.type = editionType.map(s -> Type.valueOf(s.toUpperCase())).orElse(Type.UNKNOWN);
            this.customInfos = new HashMap<String, String>(toolkitInterface.getInfos());
        }
        finally {
            toolkitInterface.dispose();
        }
    }

    @Nonnull
    public File getLicenseMappingFile() {
        return this.licenseMappingFile;
    }

    @Nonnull
    public String getKey() {
        return this.key;
    }

    @Nonnull
    public String getName() {
        return this.name;
    }

    @Nonnull
    public Type getType() {
        return this.type;
    }

    public Optional<String> getCustomInfo(String key) {
        return Optional.ofNullable(this.customInfos.get(key));
    }

    @Nonnull
    public String getProductName() {
        return this.productName;
    }

    public boolean equals(Object obj) {
        if (obj instanceof Toolkit) {
            Toolkit other = (Toolkit)obj;
            return this.licenseMappingFile.equals(other.licenseMappingFile);
        }
        return false;
    }

    public int hashCode() {
        return this.licenseMappingFile.hashCode();
    }

    @Override
    public int compareTo(Toolkit other) {
        if (other == null) {
            return 1;
        }
        return this.order - other.order;
    }

    public String toString() {
        return "Toolkit(" + this.licenseMappingFile.getAbsolutePath() + ")";
    }

    public static enum Type {
        COMMERCIAL,
        FREE,
        EVALUATION,
        UNKNOWN;

    }
}

