/*
 * Decompiled with CFR 0.152.
 */
package com.arm.licensing.toolkits;

import com.arm.licensing.ConfigFileEntry;
import com.arm.licensing.toolkits.EnvVariable;
import com.arm.licensing.toolkits.IToolkitSetting;
import com.arm.licensing.toolkits.Messages;
import com.arm.licensing.toolkits.ToolkitSelectorException;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.util.Optional;

public class EnvVariableToolkitSetting
implements IToolkitSetting {
    private final Path path;
    private final EnvVariable toolkitEnvVar;
    private final EnvVariable[] additionalEnvVars;

    public EnvVariableToolkitSetting(Path path, EnvVariable toolkitEnvVar, EnvVariable ... additionalEnvVars) {
        this.path = path;
        this.toolkitEnvVar = toolkitEnvVar;
        this.additionalEnvVars = additionalEnvVars;
    }

    @Override
    public Optional<File> get() throws ToolkitSelectorException {
        return Optional.ofNullable(this.toolkitEnvVar.get()).map(File::new);
    }

    @Override
    public boolean set(File value) throws ToolkitSelectorException {
        this.toolkitEnvVar.set(value == null ? null : value.getAbsolutePath());
        this.persist(this.toolkitEnvVar, value);
        EnvVariable[] envVariableArray = this.additionalEnvVars;
        int n = this.additionalEnvVars.length;
        int n2 = 0;
        while (n2 < n) {
            EnvVariable var = envVariableArray[n2];
            this.persist(var, value);
            ++n2;
        }
        return false;
    }

    private void persist(EnvVariable var, File value) throws ToolkitSelectorException {
        String line = var.format(value == null ? null : value.getAbsolutePath());
        try {
            this.getConfigEntry(var).setLine(line);
        }
        catch (IOException e) {
            throw new ToolkitSelectorException(Messages.ERROR_CAN_NOT_WRITE_USER_ENV_FILE.getLocalisedValue(new Object[0]), e);
        }
    }

    private ConfigFileEntry getConfigEntry(EnvVariable var) {
        return new ConfigFileEntry(this.path, var::lineContainsFormattedValue);
    }
}

