/*
 * Decompiled with CFR 0.152.
 */
package com.arm.licensing.toolkits;

import com.arm.system.ProcessEnvironment;
import java.util.Optional;

public class EnvVariable {
    private final Action action;
    private final String name;
    private final String valueFormatting;
    private transient Optional<String> processLocalValue;

    public EnvVariable(String name, String valueTemplate, Action action) {
        this.name = name;
        this.valueFormatting = valueTemplate;
        this.action = action;
        this.processLocalValue = null;
    }

    public String get() {
        if (this.processLocalValue != null) {
            return this.processLocalValue.orElse(null);
        }
        return System.getenv(this.name);
    }

    public void set(String value) {
        this.processLocalValue = Optional.ofNullable(value);
        ProcessEnvironment.getInstance().setVariable(this.name, value);
    }

    public String format(String value) {
        return this.action.format(this.formatName(), this.formatValue(value));
    }

    public boolean lineContainsFormattedValue(String line) {
        return line.contains(String.valueOf('=') + this.formatName() + '=');
    }

    protected String formatName() {
        return this.name;
    }

    protected String formatValue(String value) {
        return value == null || value.isEmpty() ? "" : String.format(this.valueFormatting, value);
    }

    public static enum Action {
        SET("SET=%1$s=%2$s"),
        PREPEND("PREPEND=%1$s=%2$s"),
        POSTPEND("POSTPEND=%1$s=%2$s");

        private final String actionFormatting;

        private Action(String actionFormatting) {
            this.actionFormatting = actionFormatting;
        }

        public String format(String name, String value) {
            return String.format(this.actionFormatting, name, value);
        }
    }
}

