/*
 * Decompiled with CFR 0.152.
 */
package com.arm.licensing.manager;

import com.arm.licensing.manager.Feature;
import com.arm.licensing.manager.ILicenseCheckoutListener;
import com.arm.licensing.manager.ILicenseGrant;
import com.arm.licensing.manager.ILicenseInfo;
import com.arm.licensing.manager.ILicensingInterface;
import com.arm.licensing.manager.LicenseException;
import com.arm.licensing.manager.LicensingConfiguration;
import com.arm.licensing.manager.LicensingInterface;
import com.arm.licensing.manager.Messages;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.GuardedBy;

public class LicensingManager
implements ILicensingInterface {
    @GuardedBy(value="LicensingManager.class")
    private static LicensingManager INSTANCE = null;
    @Nullable
    final LicensingInterface mGlobalInterface;
    private static final Set<ILicenseCheckoutListener> coListeners = new LinkedHashSet<ILicenseCheckoutListener>();

    public static synchronized ILicensingInterface getInstance() throws LicensingManagerInitialisationFailedException {
        if (INSTANCE == null) {
            INSTANCE = new LicensingManager(new LicensingConfiguration(null, null));
        }
        return INSTANCE;
    }

    public static synchronized void setConfiguration(@Nonnull LicensingConfiguration config) throws LicensingManagerInitialisationFailedException {
        if (INSTANCE == null) {
            INSTANCE = new LicensingManager(config);
        } else if (!INSTANCE.getConfiguration().equals(config)) {
            if (LicensingManager.INSTANCE.mGlobalInterface.hasActiveCheckouts()) {
                throw new LicensingManagerInitialisationFailedException(Messages.ACTIVE_LICENSING_MANAGER_PRESENT.getLocalisedValue(new Object[0]));
            }
            LicensingManager newInstance = new LicensingManager(config);
            INSTANCE.dispose();
            INSTANCE = newInstance;
        }
    }

    public static ILicensingInterface createNonGlobalInstance(@Nonnull LicensingConfiguration config) throws LicensingManagerInitialisationFailedException {
        return new LicensingInterface(config);
    }

    private LicensingManager(@Nonnull LicensingConfiguration config) throws LicensingManagerInitialisationFailedException {
        this.mGlobalInterface = new LicensingInterface(config);
    }

    @Override
    @Nonnull
    public LicensingConfiguration getConfiguration() {
        return this.mGlobalInterface.getConfiguration();
    }

    @Override
    public synchronized void dispose() {
    }

    @Override
    public void refreshLicensePath() throws LicenseException {
        this.mGlobalInterface.refreshLicensePath();
    }

    @Override
    @Nonnull
    public ILicenseGrant checkout(@Nonnull Feature feature) throws LicenseException {
        ILicenseGrant grant = null;
        try {
            grant = this.mGlobalInterface.checkout(feature);
        }
        catch (Throwable throwable) {
            LicensingManager.fireLicenseCheckoutEvent(grant);
            throw throwable;
        }
        LicensingManager.fireLicenseCheckoutEvent(grant);
        return grant;
    }

    @Override
    public void checkin(@Nonnull ILicenseGrant grant) throws LicenseException {
        this.mGlobalInterface.checkin(grant);
    }

    @Override
    public boolean isRoutable(@Nonnull Feature feature) throws LicenseException {
        return this.mGlobalInterface.isRoutable(feature);
    }

    @Override
    public boolean isFulfilledBy(@Nonnull Feature feature, @Nonnull Map<String, List<Feature>> backendFeatures) throws LicenseException {
        return this.mGlobalInterface.isFulfilledBy(feature, backendFeatures);
    }

    @Override
    @Nonnull
    public Optional<String> getInfo(@Nonnull String key) throws LicenseException {
        return this.mGlobalInterface.getInfo(key);
    }

    @Override
    @Nonnull
    public Map<String, String> getInfos() throws LicenseException {
        return this.mGlobalInterface.getInfos();
    }

    @Override
    @Nonnull
    public Map<String, List<Feature>> listBackendFeatures() throws LicenseException {
        return this.mGlobalInterface.listBackendFeatures();
    }

    @Override
    public boolean hasActiveCheckouts() {
        return this.mGlobalInterface.hasActiveCheckouts();
    }

    public static synchronized void addLicenseCheckoutListener(@Nonnull ILicenseCheckoutListener listener) {
        coListeners.add(listener);
    }

    public static synchronized void removeLicenseCheckoutListener(@Nonnull ILicenseCheckoutListener listener) {
        coListeners.remove(listener);
    }

    private static synchronized void fireLicenseCheckoutEvent(@Nullable ILicenseInfo licenseInfo) {
        if (licenseInfo == null) {
            return;
        }
        for (ILicenseCheckoutListener coListener : coListeners) {
            coListener.licenseCheckedOut(licenseInfo);
        }
    }

    public static class LicensingManagerInitialisationFailedException
    extends LicenseException {
        public LicensingManagerInitialisationFailedException(String message) {
            super(message);
        }
    }
}

