/*
 * Decompiled with CFR 0.152.
 */
package com.arm.licensing.manager;

import com.arm.licensing.licensemapping.FeatureList;
import com.arm.licensing.licensemapping.FeaturesMap;
import com.arm.licensing.licensemapping.JavaLicensingInterface;
import com.arm.licensing.licensemapping.JavaLicensingInterfaceException;
import com.arm.licensing.licensemapping.LicenseMapping;
import com.arm.licensing.licensemapping.StringMap;
import com.arm.licensing.manager.Feature;
import com.arm.licensing.manager.ILicenseGrant;
import com.arm.licensing.manager.ILicensingInterface;
import com.arm.licensing.manager.LicenseException;
import com.arm.licensing.manager.LicenseFeatureUnsupportedException;
import com.arm.licensing.manager.LicenseGrant;
import com.arm.licensing.manager.LicensingConfiguration;
import com.arm.licensing.manager.LicensingManager;
import com.arm.licensing.manager.Messages;
import com.arm.util.libs.LibLoaderHelper;
import java.io.File;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.GuardedBy;

public class LicensingInterface
implements ILicensingInterface {
    private static final String NATIVE_LIBRARY_NAME = "LicenseMapping";
    private static final Pattern FLEX_VERSION_PATTERN;
    private static final int SUPPORT_EXPIRY_WARNING = 14;
    @Nonnull
    private final LicensingConfiguration mConfiguration;
    @Nonnull
    @GuardedBy(value="this")
    private final JavaLicensingInterface mLicensingInterface;
    @GuardedBy(value="this")
    private final Thread mShutdownHook;
    @GuardedBy(value="this")
    final List<ILicenseGrant> mCheckedOutGrants = new ArrayList<ILicenseGrant>();
    @GuardedBy(value="this")
    final Map<String, String> mLicmapInfos = new HashMap<String, String>();
    @GuardedBy(value="this")
    final Map<Feature, Boolean> mIsRoutableCache = new HashMap<Feature, Boolean>();

    static {
        try {
            File path = LibLoaderHelper.resolve((String)NATIVE_LIBRARY_NAME, LicenseMapping.class);
            System.load(path.getPath());
        }
        catch (Throwable th) {
            UnsatisfiedLinkError rethrown = new UnsatisfiedLinkError("Failed to load native library LicenseMapping");
            rethrown.initCause(th);
            throw rethrown;
        }
        FLEX_VERSION_PATTERN = Pattern.compile("^\\d+\\.\\d+(\\d{6})$");
    }

    LicensingInterface(@Nonnull LicensingConfiguration config) throws LicensingManager.LicensingManagerInitialisationFailedException {
        this.mConfiguration = config;
        try {
            this.mLicensingInterface = new JavaLicensingInterface(config.getLicenseMappingFileOverride().map(File::getAbsolutePath).orElse(null), config.getFlexDefaultLicenseOverride().map(File::getAbsolutePath).orElse(null));
            StringMap infos = this.mLicensingInterface.getInfos();
            infos.forEach(k -> {
                String string = this.mLicmapInfos.put((String)k, infos.get((String)k));
            });
        }
        catch (JavaLicensingInterfaceException e) {
            throw new LicensingManager.LicensingManagerInitialisationFailedException(Messages.LICENSING_MANAGER_INITIALISATION_FAILED.getLocalisedValue(e.getMessage()));
        }
        this.mShutdownHook = new Thread("shutdown hook"){

            @Override
            public void run() {
                LicensingInterface.this.dispose();
            }
        };
        Runtime.getRuntime().addShutdownHook(this.mShutdownHook);
    }

    @Override
    @Nonnull
    public LicensingConfiguration getConfiguration() {
        return this.mConfiguration;
    }

    @Override
    public synchronized void dispose() {
        this.mLicensingInterface.dispose();
        this.mCheckedOutGrants.clear();
        this.mLicmapInfos.clear();
        this.mIsRoutableCache.clear();
    }

    @Override
    public synchronized void refreshLicensePath() throws LicenseException {
        if (this.hasActiveCheckouts()) {
            throw new LicenseException(Messages.CANNOT_REFRESH_WITH_CHECKOUTS.getLocalisedValue(new Object[0]));
        }
        try {
            this.mLicensingInterface.refreshLicensePath();
        }
        catch (JavaLicensingInterfaceException e) {
            throw new LicenseException(e);
        }
    }

    @Override
    @Nonnull
    public synchronized ILicenseGrant checkout(@Nonnull Feature feature) throws LicenseException {
        String featName = feature.getName();
        String featVers = feature.getVersion();
        try {
            this.mLicensingInterface.checkout(featName, featVers);
            Boolean isPermanent = null;
            Boolean isNodeLocked = null;
            String serialNumber = null;
            Integer daysUntilExpiry = null;
            Date licenseExpiryDate = null;
            Date supportExpiryDate = null;
            try {
                int expiryDays = this.mLicensingInterface.getExpiryDays(featName, featVers);
                isPermanent = expiryDays == 3650000;
                if (!isPermanent.booleanValue()) {
                    daysUntilExpiry = expiryDays;
                    licenseExpiryDate = LicensingInterface.computeFutureDate(expiryDays);
                }
            }
            catch (JavaLicensingInterfaceException javaLicensingInterfaceException) {}
            try {
                String actualVersion = this.mLicensingInterface.getActualVersion(featName, featVers);
                supportExpiryDate = LicensingInterface.parseFlexVersionString(actualVersion);
            }
            catch (JavaLicensingInterfaceException javaLicensingInterfaceException) {}
            try {
                serialNumber = this.mLicensingInterface.getSerialNumber(featName, featVers);
            }
            catch (JavaLicensingInterfaceException javaLicensingInterfaceException) {}
            try {
                isNodeLocked = this.mLicensingInterface.isNodeLocked(featName, featVers);
            }
            catch (JavaLicensingInterfaceException javaLicensingInterfaceException) {}
            String warning = supportExpiryDate != null ? LicensingInterface.getSMExpiryWarning(feature, supportExpiryDate) : null;
            LicenseGrant grant = new LicenseGrant(feature, isPermanent, daysUntilExpiry, licenseExpiryDate, supportExpiryDate, warning, serialNumber, isNodeLocked);
            this.mCheckedOutGrants.add(grant);
            return grant;
        }
        catch (JavaLicensingInterfaceException jlie) {
            boolean isRoutable = true;
            try {
                isRoutable = this.isRoutable(feature);
            }
            catch (LicenseException licenseException) {}
            if (!isRoutable) {
                throw new LicenseFeatureUnsupportedException(jlie);
            }
            throw new LicenseException(jlie);
        }
    }

    @Override
    public synchronized void checkin(@Nonnull ILicenseGrant grant) throws LicenseException {
        try {
            try {
                this.mLicensingInterface.checkin(grant.getFeature().getName(), grant.getFeature().getVersion());
            }
            catch (JavaLicensingInterfaceException e) {
                throw new LicenseException(e);
            }
        }
        finally {
            this.mCheckedOutGrants.remove(grant);
        }
    }

    @Override
    public synchronized boolean isRoutable(@Nonnull Feature feature) throws LicenseException {
        if (this.mIsRoutableCache.containsKey(feature)) {
            return this.mIsRoutableCache.get(feature);
        }
        try {
            boolean result = this.mLicensingInterface.isRoutable(feature.getName(), feature.getVersion());
            this.mIsRoutableCache.put(feature, result);
            return result;
        }
        catch (JavaLicensingInterfaceException e) {
            throw new LicenseException(e);
        }
    }

    @Override
    public boolean isFulfilledBy(@Nonnull Feature feature, @Nonnull Map<String, List<Feature>> backendFeatures) throws LicenseException {
        try {
            return this.mLicensingInterface.isFulfilledBy(feature.getName(), feature.getVersion(), LicensingInterface.toFeaturesMap(backendFeatures));
        }
        catch (JavaLicensingInterfaceException e) {
            throw new LicenseException(e);
        }
    }

    @Override
    @Nonnull
    public synchronized Map<String, String> getInfos() throws LicenseException {
        return this.mLicmapInfos;
    }

    @Override
    @Nonnull
    public synchronized Optional<String> getInfo(@Nonnull String key) throws LicenseException {
        return Optional.ofNullable(this.mLicmapInfos.getOrDefault(key, null));
    }

    @Override
    @Nonnull
    public Map<String, List<Feature>> listBackendFeatures() throws LicenseException {
        try {
            FeaturesMap backendFeatures = this.mLicensingInterface.listBackendFeatures();
            return LicensingInterface.fromFeaturesMap(backendFeatures);
        }
        catch (JavaLicensingInterfaceException e) {
            throw new LicenseException(e);
        }
    }

    @Override
    public synchronized boolean hasActiveCheckouts() {
        return !this.mCheckedOutGrants.isEmpty();
    }

    @Nonnull
    private static Map<String, List<Feature>> fromFeaturesMap(@Nonnull FeaturesMap swigMap) {
        HashMap<String, List<Feature>> javaMap = new HashMap<String, List<Feature>>();
        for (String backendId : swigMap) {
            FeatureList features = swigMap.get(backendId);
            ArrayList<Feature> javaList = new ArrayList<Feature>();
            for (com.arm.licensing.licensemapping.Feature swigFeature : features) {
                javaList.add(new Feature(swigFeature.getName(), swigFeature.getVersion()));
            }
            javaMap.put(backendId, javaList);
        }
        return javaMap;
    }

    @Nonnull
    private static FeaturesMap toFeaturesMap(@Nonnull Map<String, List<Feature>> javaMap) {
        FeaturesMap swigMap = new FeaturesMap();
        for (Map.Entry<String, List<Feature>> entry : javaMap.entrySet()) {
            FeatureList swigList = new FeatureList();
            for (Feature javaFeature : entry.getValue()) {
                swigList.add(new com.arm.licensing.licensemapping.Feature(javaFeature.getName(), javaFeature.getVersion()));
            }
            swigMap.put(entry.getKey(), swigList);
        }
        return swigMap;
    }

    static Date getLastDateFor(String date) throws ParseException {
        Calendar expiryCalendar = GregorianCalendar.getInstance();
        expiryCalendar.setTime(new SimpleDateFormat("yyyyMM").parse(date));
        expiryCalendar.set(5, expiryCalendar.getActualMaximum(5));
        expiryCalendar.set(11, expiryCalendar.getMaximum(11));
        expiryCalendar.set(12, expiryCalendar.getMaximum(12));
        expiryCalendar.set(13, expiryCalendar.getMaximum(13));
        return expiryCalendar.getTime();
    }

    private static Date computeFutureDate(int days) {
        Calendar calendar = GregorianCalendar.getInstance();
        calendar.add(5, days);
        calendar.set(11, calendar.getMaximum(11));
        calendar.set(12, calendar.getMaximum(12));
        calendar.set(13, calendar.getMaximum(13));
        calendar.set(14, calendar.getMaximum(14));
        return calendar.getTime();
    }

    static Date parseFlexVersionString(String version) {
        if (version == null) {
            return null;
        }
        Matcher versionMatcher = FLEX_VERSION_PATTERN.matcher(version);
        if (!versionMatcher.matches()) {
            return null;
        }
        String date = versionMatcher.group(1);
        try {
            return LicensingInterface.getLastDateFor(date);
        }
        catch (ParseException parseException) {
            return null;
        }
    }

    static String getSMExpiryWarning(Feature feature, Date expiryDate) {
        Date todaysDate = GregorianCalendar.getInstance().getTime();
        if (todaysDate.after(expiryDate)) {
            return Messages.SUPPORT_HAS_EXPIRED.getLocalisedValue(feature.getName(), new SimpleDateFormat("dd-MMM-yyyy").format(expiryDate));
        }
        Calendar futureCalendar = GregorianCalendar.getInstance();
        futureCalendar.add(5, 14);
        Date futureDate = futureCalendar.getTime();
        if (futureDate.after(expiryDate)) {
            return Messages.SUPPORT_WILL_EXPIRE.getLocalisedValue(feature.getName(), new SimpleDateFormat("dd-MMM-yyyy").format(expiryDate));
        }
        return null;
    }
}

