/*
 * Decompiled with CFR 0.152.
 */
package com.arm.licensing.manager;

import com.arm.licensing.manager.Feature;
import com.arm.licensing.manager.ILicenseGrant;
import com.arm.licensing.manager.LicenseException;
import com.arm.licensing.manager.LicensingManager;
import java.util.Date;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class LicenseGrant
implements ILicenseGrant {
    private final Feature feature;
    private final Boolean isPermanent;
    private final Integer daysTillExpiry;
    private final Date expiryDate;
    private final Date smExpiryDate;
    private final String[] warnings;
    private final String serialNumber;
    private final Boolean isNodeLocked;

    public LicenseGrant(@Nonnull Feature feature, @Nullable Boolean isPermanent, @Nullable Integer daysTillExpiry, @Nullable Date expiryDate, @Nullable Date smExpiryDate, @Nullable String warning, @Nullable String serialNumber, @Nullable Boolean isNodeLocked) {
        String[] stringArray;
        this.feature = feature;
        this.isPermanent = isPermanent;
        this.daysTillExpiry = daysTillExpiry;
        this.expiryDate = expiryDate;
        this.smExpiryDate = smExpiryDate;
        if (warning != null) {
            String[] stringArray2 = new String[1];
            stringArray = stringArray2;
            stringArray2[0] = warning;
        } else {
            stringArray = new String[]{};
        }
        this.warnings = stringArray;
        this.serialNumber = serialNumber;
        this.isNodeLocked = isNodeLocked;
    }

    @Override
    @Nonnull
    public Feature getFeature() {
        return this.feature;
    }

    @Override
    public Optional<Boolean> isNodeLocked() {
        return Optional.ofNullable(this.isNodeLocked);
    }

    @Override
    public Optional<Boolean> isPermanent() {
        return Optional.ofNullable(this.isPermanent);
    }

    @Override
    public Optional<Integer> getDaysTillExpiry() {
        return Optional.ofNullable(this.daysTillExpiry);
    }

    @Override
    public Optional<Date> getExpiryDate() {
        return Optional.ofNullable(this.expiryDate);
    }

    @Override
    public Optional<Date> getServiceAndMaintenanceExpiryDate() {
        return Optional.ofNullable(this.smExpiryDate);
    }

    @Override
    @Nonnull
    public String[] getWarnings() {
        return (String[])this.warnings.clone();
    }

    @Override
    public void dispose() {
        try {
            LicensingManager.getInstance().checkin(this);
        }
        catch (LicenseException licenseException) {}
    }

    @Override
    public Optional<String> getSerialNumber() {
        return Optional.ofNullable(this.serialNumber);
    }

    public String toString() {
        return this.feature.toString();
    }
}

