/*
 * Decompiled with CFR 0.152.
 */
package com.arm.licensing.manager;

import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.Objects;
import javax.annotation.Nonnull;

public class Feature {
    @Nonnull
    private final String name;
    @Nonnull
    private final String version;
    @Nonnull
    private final String descriptiveName;

    @Nonnull
    public static Feature create(@Nonnull String name, @Nonnull LocalDate buildDate) {
        String version = buildDate.format(DateTimeFormatter.ofPattern("yyyyMM"));
        return new Feature(name, version);
    }

    @Nonnull
    public static Feature create(@Nonnull String name, @Nonnull String descriptiveName, @Nonnull LocalDate buildDate) {
        String version = buildDate.format(DateTimeFormatter.ofPattern("yyyyMM"));
        return new Feature(name, version, descriptiveName);
    }

    public Feature(@Nonnull String name, @Nonnull String version) {
        this.name = Objects.requireNonNull(name);
        this.version = Objects.requireNonNull(version);
        this.descriptiveName = name;
    }

    public Feature(@Nonnull String name, @Nonnull String version, @Nonnull String descriptiveName) {
        this.name = Objects.requireNonNull(name);
        this.version = Objects.requireNonNull(version);
        this.descriptiveName = Objects.requireNonNull(descriptiveName);
    }

    @Nonnull
    public String getName() {
        return this.name;
    }

    @Nonnull
    public String getVersion() {
        return this.version;
    }

    @Nonnull
    public String getDescriptiveName() {
        return this.descriptiveName;
    }

    public String toString() {
        return String.valueOf(this.name) + ":" + this.version;
    }

    public int hashCode() {
        return Objects.hash(this.name, this.version);
    }

    public boolean equals(Object obj) {
        boolean equal;
        boolean bl = equal = this == obj;
        if (obj instanceof Feature) {
            Feature other = (Feature)obj;
            equal = Objects.equals(this.name, other.name) && Objects.equals(this.version, other.version);
        }
        return equal;
    }
}

