/*
 * Decompiled with CFR 0.152.
 */
package com.arm.licensing.license.reader;

import com.arm.licensing.license.provider.AppPathLicenseProvider;
import com.arm.licensing.license.provider.EnvVarLicenseProvider;
import com.arm.licensing.license.provider.FlexlmrcLicenseProvider;
import com.arm.licensing.license.reader.LicenseReader;
import com.arm.util.Platform;
import java.nio.file.Path;
import java.nio.file.Paths;

public class LicenseReaderFactory {
    public static LicenseReader getDefaultReader() {
        LicenseReader licenseReader = new LicenseReader();
        String homeEnvVar = System.getenv("HOME");
        if (homeEnvVar != null && !Platform.isWindows()) {
            Path flexlmrcPath = Paths.get(homeEnvVar, ".flexlmrc");
            licenseReader.addProvider(new EnvVarLicenseProvider(null, "ARMLMD_LICENSE_FILE"));
            licenseReader.addProvider(new AppPathLicenseProvider(null));
            licenseReader.addProvider(new FlexlmrcLicenseProvider(null, flexlmrcPath, "ARMLMD_LICENSE_FILE"));
            licenseReader.addProvider(new EnvVarLicenseProvider(null, "LM_LICENSE_FILE"));
            licenseReader.addProvider(new FlexlmrcLicenseProvider(null, flexlmrcPath, "LM_LICENSE_FILE"));
        } else {
            licenseReader.addProvider(new EnvVarLicenseProvider(null, "ARMLMD_LICENSE_FILE"));
            licenseReader.addProvider(new AppPathLicenseProvider(null));
            licenseReader.addProvider(new EnvVarLicenseProvider(null, "LM_LICENSE_FILE"));
        }
        return licenseReader;
    }
}

