/*
 * Decompiled with CFR 0.152.
 */
package com.arm.licensing.license.reader;

import com.arm.licensing.license.ILicense;
import com.arm.licensing.license.ILicenseWriter;
import com.arm.licensing.license.InvalidLicenseException;
import com.arm.licensing.license.LicenseFile;
import com.arm.licensing.license.LicenseServer;
import com.arm.licensing.license.LicenseTripleServer;
import com.arm.licensing.license.provider.AppPathLicenseProvider;
import com.arm.licensing.license.provider.DirectoryProvider;
import com.arm.licensing.license.provider.EnvVarLicenseProvider;
import com.arm.licensing.license.provider.FlexlmrcLicenseProvider;
import com.arm.licensing.license.provider.ILicenseEntity;
import com.arm.licensing.license.provider.ILicenseProvider;
import com.arm.licensing.license.provider.LicenseProviderException;
import com.arm.licensing.license.reader.Messages;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;

public class LicenseReader {
    private static final Pattern USE_SERVER = Pattern.compile("^\\s*USE_SERVER\\s*$", 2);
    private static final Pattern SERVER = Pattern.compile("^\\s*SERVER\\s+(\\S+)\\s+(\\S+)(?:\\s(\\d+))*\\s*$", 2);
    private final List<ILicenseProvider> providers = new LinkedList<ILicenseProvider>();

    public void addProvider(ILicenseProvider provider) {
        this.providers.add(provider);
    }

    public LinkedList<ILicenseProvider> getProviders() {
        return new LinkedList<ILicenseProvider>(this.providers);
    }

    public List<ILicenseProvider> getAllProviders() {
        LinkedList<ILicenseProvider> providerList = this.getProviders();
        providerList.sort(new ProviderComparator());
        int providerNum = 0;
        while (providerNum < providerList.size()) {
            List<ILicenseEntity> licenses;
            ILicenseProvider provider = providerList.get(providerNum);
            try {
                licenses = this.processFlexLicensePath(provider, provider.getLicensePaths());
            }
            catch (LicenseProviderException licenseProviderException) {
                continue;
            }
            int insertionIndex = providerNum + 1;
            for (ILicenseEntity license : licenses) {
                ILicenseProvider subProvider;
                if (!(license instanceof ILicenseProvider) || providerList.contains(subProvider = (ILicenseProvider)license)) continue;
                providerList.add(insertionIndex++, subProvider);
            }
            ++providerNum;
        }
        return providerList;
    }

    public static String getLicenseSeparator() {
        return File.pathSeparator;
    }

    public String concatenateLicensePaths(String firstPath, Object ... morePaths) {
        StringBuilder result = new StringBuilder(firstPath);
        Object[] objectArray = morePaths;
        int n = morePaths.length;
        int n2 = 0;
        while (n2 < n) {
            Object object = objectArray[n2];
            String path = (String)object;
            if (result.length() != 0 && path.length() != 0) {
                result.append(LicenseReader.getLicenseSeparator());
            }
            result.append(path);
            ++n2;
        }
        return result.toString();
    }

    @SuppressFBWarnings(value={"RV_RETURN_VALUE_IGNORED_BAD_PRACTICE"})
    private ILicenseEntity determineLicenseType(ILicenseProvider parent, String location) {
        boolean hasExt;
        File file = new File(location);
        if (file.isDirectory()) {
            return new DirectoryProvider(parent, location);
        }
        if (file.exists()) {
            List<ILicense> servers = null;
            try {
                servers = this.readServersFromLicenseFile(parent, file);
            }
            catch (IOException iOException) {}
            if (servers != null && !servers.isEmpty()) {
                String server = servers.get(0).getLicenseAsString();
                return new LicenseServer(parent, server, location);
            }
            return new LicenseFile(parent, location);
        }
        if (location.indexOf(64) != -1) {
            if (location.indexOf(44) != -1) {
                return new LicenseTripleServer(parent, location);
            }
            return new LicenseServer(parent, location);
        }
        boolean bl = hasExt = file.getName().indexOf(46) != -1;
        if (!file.exists() && !hasExt) {
            return new DirectoryProvider(parent, location);
        }
        return new LicenseFile(parent, location);
    }

    private List<ILicenseEntity> processFlexLicensePath(ILicenseProvider parent, String path) {
        String separator = LicenseReader.getLicenseSeparator();
        String[] paths = path.split(separator);
        LinkedList<ILicenseEntity> licenses = new LinkedList<ILicenseEntity>();
        String[] stringArray = paths;
        int n = paths.length;
        int n2 = 0;
        while (n2 < n) {
            String location = stringArray[n2];
            if (location.length() != 0) {
                licenses.add(this.determineLicenseType(parent, location));
            }
            ++n2;
        }
        return licenses;
    }

    public List<ILicense> readLicenses() {
        LinkedList<ILicense> licenses = new LinkedList<ILicense>();
        List<ILicenseProvider> allProviders = this.getAllProviders();
        for (ILicenseProvider provider : allProviders) {
            String path = null;
            try {
                path = provider.getLicensePaths();
            }
            catch (LicenseProviderException licenseProviderException) {}
            if (path == null) continue;
            List<ILicenseEntity> licenseEntities = this.processFlexLicensePath(provider, path);
            for (ILicenseEntity licenseEntity : licenseEntities) {
                if (!(licenseEntity instanceof ILicense)) continue;
                licenses.add((ILicense)licenseEntity);
            }
        }
        return licenses;
    }

    public List<ILicense> getValidLicenses() {
        ArrayList<ILicense> licenses = new ArrayList<ILicense>();
        for (ILicense license : this.readLicenses()) {
            try {
                license.validateAll();
                licenses.add(license);
            }
            catch (InvalidLicenseException invalidLicenseException) {}
        }
        return licenses;
    }

    /*
     * Exception decompiling
     */
    private List<ILicense> readServersFromLicenseFile(ILicenseProvider parent, File file) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [0[TRYBLOCK]], but top level block is 15[WHILELOOP]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private ILicenseProvider findMostCapableLicenseProvider() {
        ILicenseProvider mostCapable = null;
        int mostCapableSupportedTypes = 0;
        List<ILicenseProvider> allProviders = this.getAllProviders();
        for (ILicenseProvider provider : allProviders) {
            int supportedTypes;
            if (!(provider instanceof ILicenseWriter) || (supportedTypes = ((ILicenseWriter)((Object)provider)).getSupportedLicenseTypes().size()) <= mostCapableSupportedTypes) continue;
            mostCapable = provider;
            mostCapableSupportedTypes = supportedTypes;
        }
        return mostCapable;
    }

    public void addLicense(ILicense license) throws LicenseProviderException {
        ILicenseProvider provider = this.findMostCapableLicenseProvider();
        if (provider == null) {
            throw new IllegalStateException(Messages.LICENSE_READER_UNABLE_TO_ADD_NO_WRITERS.getLocalisedValue(new Object[0]));
        }
        ILicenseWriter licWriter = (ILicenseWriter)((Object)provider);
        licWriter.addLicense(license);
    }

    public void deleteLicense(ILicenseProvider provider, String licenseLocation) throws LicenseProviderException, IOException {
        if (!(provider instanceof ILicenseWriter)) {
            throw new IllegalArgumentException(Messages.LICENSE_READER_UNABLE_TO_DELETE_NO_WRITERS.getLocalisedValue(licenseLocation));
        }
        List<ILicenseEntity> licenseEntities = this.processFlexLicensePath(provider, provider.getLicensePaths());
        for (ILicenseEntity licenseEntity : licenseEntities) {
            ILicense licenseFromProvider;
            if (!(licenseEntity instanceof ILicense) || !(licenseFromProvider = (ILicense)licenseEntity).getLicenseAsString().equals(licenseLocation)) continue;
            ILicenseWriter licWriter = (ILicenseWriter)((Object)provider);
            licWriter.deleteLicense(licenseLocation);
            return;
        }
    }

    protected static class ProviderComparator
    implements Comparator<ILicenseProvider> {
        private final Map<Class<? extends ILicenseProvider>, Integer> providerRankingMap = new HashMap<Class<? extends ILicenseProvider>, Integer>();

        public ProviderComparator() {
            this.providerRankingMap.put(AppPathLicenseProvider.class, 1);
            this.providerRankingMap.put(EnvVarLicenseProvider.class, 2);
            this.providerRankingMap.put(FlexlmrcLicenseProvider.class, 3);
            this.providerRankingMap.put(DirectoryProvider.class, 4);
        }

        @Override
        public int compare(ILicenseProvider o1, ILicenseProvider o2) {
            Class<?> providerClass1 = o1.getClass();
            Class<?> providerClass2 = o2.getClass();
            if (this.providerRankingMap.containsKey(providerClass1) && this.providerRankingMap.containsKey(providerClass2)) {
                int rank2;
                int rank1 = this.providerRankingMap.get(providerClass1);
                return rank1 < (rank2 = this.providerRankingMap.get(providerClass2).intValue()) ? -1 : (rank1 > rank2 ? 1 : 0);
            }
            if (!this.providerRankingMap.containsKey(providerClass1)) {
                return 1;
            }
            if (!this.providerRankingMap.containsKey(providerClass2)) {
                return -1;
            }
            return 0;
        }
    }
}

