/*
 * Decompiled with CFR 0.152.
 */
package com.arm.licensing.license.provider;

import com.arm.licensing.ConfigFileEntry;
import com.arm.licensing.license.ILicense;
import com.arm.licensing.license.ILicenseWriter;
import com.arm.licensing.license.LicenseType;
import com.arm.licensing.license.provider.AbstractLicenseEntity;
import com.arm.licensing.license.provider.ILicenseProvider;
import com.arm.licensing.license.provider.LicenseProviderException;
import com.arm.licensing.license.provider.Messages;
import com.arm.licensing.license.reader.LicenseReader;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;

public class FlexlmrcLicenseProvider
extends AbstractLicenseEntity
implements ILicenseProvider,
ILicenseWriter {
    private final Path path;
    private final String entryName;

    public FlexlmrcLicenseProvider(ILicenseProvider parent, Path path, String entryName) {
        super(parent);
        this.path = path;
        this.entryName = entryName;
    }

    private String getLicensePathsInternal() throws IOException {
        ConfigFileEntry entry = this.getConfigEntry();
        String line = entry.getLine();
        if (line != null) {
            line = line.substring(this.entryName.length());
            if ((line = line.trim()).charAt(0) == '=') {
                return line.substring(1).trim();
            }
        }
        return null;
    }

    @Override
    public String getLicensePaths() throws LicenseProviderException {
        try {
            String paths = this.getLicensePathsInternal();
            return paths == null ? "" : paths;
        }
        catch (IOException ioe) {
            throw new LicenseProviderException(Messages.FLEX_LMRC_LICENSE_PROVIDER_FAILED_TO_READ.getLocalisedValue(this.path.toString()), ioe);
        }
    }

    private ConfigFileEntry getConfigEntry() {
        return new ConfigFileEntry(this.path, new ConfigFileEntry.EntryMatcher(){

            @Override
            public boolean matches(String line) {
                return line.toUpperCase().startsWith(FlexlmrcLicenseProvider.this.entryName);
            }
        });
    }

    private void setLicensePaths(String paths) throws LicenseProviderException {
        String newLine = paths.isEmpty() ? null : String.valueOf(this.entryName) + "=" + paths;
        ConfigFileEntry entry = this.getConfigEntry();
        try {
            entry.setLine(newLine);
        }
        catch (IOException ioe) {
            throw new LicenseProviderException(Messages.FLEX_LMRC_LICENSE_PROVIDER_FAILED_TO_WRITE.getLocalisedValue(this.path.toString()), ioe);
        }
    }

    @Override
    public Set<LicenseType> getSupportedLicenseTypes() {
        return new HashSet<LicenseType>(Arrays.asList(LicenseType.values()));
    }

    @Override
    public void addLicense(ILicense license) throws LicenseProviderException {
        String paths = this.getLicensePaths();
        if (paths.length() != 0) {
            paths = String.valueOf(paths) + LicenseReader.getLicenseSeparator();
        }
        paths = String.valueOf(paths) + license.getLicenseAsString();
        this.setLicensePaths(paths);
    }

    @Override
    public void deleteLicense(String licenseLocation) throws LicenseProviderException, IllegalArgumentException {
        String[] pathArray = this.getLicensePaths().split(LicenseReader.getLicenseSeparator());
        int licenseIndex = -1;
        int i = 0;
        while (i < pathArray.length) {
            if (pathArray[i].equals(licenseLocation)) {
                licenseIndex = i;
                break;
            }
            ++i;
        }
        if (licenseIndex == -1) {
            throw new IllegalArgumentException(Messages.FLEX_LMRC_LICENSE_PROVIDER_LICENSE_DOES_NOT_EXIST.getLocalisedValue(licenseLocation));
        }
        StringBuilder pathsString = new StringBuilder();
        int p = 0;
        while (p < pathArray.length) {
            if (licenseIndex != p) {
                if (pathsString.length() != 0) {
                    pathsString.append(LicenseReader.getLicenseSeparator());
                }
                pathsString.append(pathArray[p]);
            }
            ++p;
        }
        this.setLicensePaths(pathsString.toString());
    }

    @Override
    public String getDescription() {
        String value;
        String filePath = this.path != null ? this.path.toString() : "null";
        try {
            value = this.getLicensePathsInternal();
            value = value == null ? Messages.NOT_SET.getLocalisedValue(new Object[0]) : String.valueOf('\"') + value + '\"';
        }
        catch (IOException ioe) {
            value = String.valueOf('<') + ioe.getMessage() + '>';
        }
        return Messages.FLEX_LMRC_LICENSE_PROVIDER_DESCRIPTION.getLocalisedValue(this.entryName, filePath, value);
    }

    @Override
    public String getProviderAsString() {
        return this.path.toString();
    }

    @Override
    public boolean isDeletable() {
        return Files.isWritable(this.path);
    }
}

