/*
 * Decompiled with CFR 0.152.
 */
package com.arm.licensing.license.provider;

import com.arm.licensing.license.provider.AbstractLicenseEntity;
import com.arm.licensing.license.provider.ILicenseProvider;
import com.arm.licensing.license.provider.Messages;

public class EnvVarLicenseProvider
extends AbstractLicenseEntity
implements ILicenseProvider {
    private final String envVar;

    public EnvVarLicenseProvider(ILicenseProvider parent, String envVar) {
        super(parent);
        this.envVar = envVar;
    }

    @Override
    public String getLicensePaths() {
        String paths = System.getenv(this.envVar);
        if (paths == null) {
            paths = "";
        }
        return paths;
    }

    @Override
    public String getDescription() {
        String paths = System.getenv(this.envVar);
        paths = paths != null ? String.valueOf('\"') + paths + '\"' : Messages.NOT_SET.getLocalisedValue(new Object[0]);
        return Messages.ENV_VAR_LICENSE_PROVIDER_DESCRIPTION.getLocalisedValue(this.envVar, paths);
    }

    @Override
    public String getProviderAsString() {
        return Messages.ENV_VAR_LICENSE_PROVIDER_AS_STRING.getLocalisedValue(this.envVar);
    }

    @Override
    public boolean isDeletable() {
        return false;
    }
}

