/*
 * Decompiled with CFR 0.152.
 */
package com.arm.licensing.license.provider;

import com.arm.licensing.license.ILicense;
import com.arm.licensing.license.ILicenseFile;
import com.arm.licensing.license.ILicenseWriter;
import com.arm.licensing.license.InvalidLicenseException;
import com.arm.licensing.license.LicenseServer;
import com.arm.licensing.license.LicenseType;
import com.arm.licensing.license.provider.AbstractLicenseEntity;
import com.arm.licensing.license.provider.ILicenseProvider;
import com.arm.licensing.license.provider.LicenseProviderException;
import com.arm.licensing.license.provider.Messages;
import com.arm.licensing.license.reader.LicenseReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.InvalidPathException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;

public class DirectoryProvider
extends AbstractLicenseEntity
implements ILicenseProvider,
ILicenseWriter {
    private static final String LIC_EXT = ".lic";
    private final String dir;

    public DirectoryProvider(ILicenseProvider parent, String dir) {
        super(parent);
        this.dir = Objects.requireNonNull(dir).trim();
    }

    private ArrayList<Path> getLicenseFiles() {
        ArrayList<Path> files = new ArrayList<Path>();
        try {
            Throwable throwable = null;
            Object var3_4 = null;
            try (DirectoryStream<Path> stream = Files.newDirectoryStream(Paths.get(this.dir, new String[0]), "*.lic");){
                for (Path entry : stream) {
                    files.add(entry);
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException | InvalidPathException exception) {}
        files.sort(new Comparator<Path>(){

            @Override
            public int compare(Path path1, Path path2) {
                return path1.compareTo(path2);
            }
        });
        return files;
    }

    private void copyFile(File source, File dest) throws IOException {
        FileInputStream sourceInputStream = null;
        FileOutputStream destOutputStream = null;
        try {
            int n;
            sourceInputStream = new FileInputStream(source);
            destOutputStream = new FileOutputStream(dest);
            byte[] buffer = new byte[16384];
            do {
                if ((n = sourceInputStream.read(buffer)) <= 0) continue;
                destOutputStream.write(buffer, 0, n);
            } while (n > 0);
        }
        catch (Throwable throwable) {
            try {
                if (destOutputStream != null) {
                    destOutputStream.close();
                }
            }
            catch (IOException iOException) {}
            try {
                if (sourceInputStream != null) {
                    sourceInputStream.close();
                }
            }
            catch (IOException iOException) {}
            throw throwable;
        }
        try {
            if (destOutputStream != null) {
                destOutputStream.close();
            }
        }
        catch (IOException iOException) {}
        try {
            if (sourceInputStream != null) {
                sourceInputStream.close();
            }
        }
        catch (IOException iOException) {}
    }

    @Override
    public String getLicensePaths() {
        StringBuilder paths = new StringBuilder();
        ArrayList<Path> files = this.getLicenseFiles();
        for (Path file : files) {
            if (paths.length() != 0) {
                paths.append(LicenseReader.getLicenseSeparator());
            }
            paths.append(file.toString());
        }
        return paths.toString();
    }

    @Override
    public Set<LicenseType> getSupportedLicenseTypes() {
        return new HashSet<LicenseType>(Arrays.asList(LicenseType.File, LicenseType.Server));
    }

    private void addLicenseFile(ILicenseFile license) throws LicenseProviderException {
        File destFile;
        File sourceFile = new File(license.getLicenseAsString());
        String name = sourceFile.getName();
        int dot = name.lastIndexOf(46);
        if (dot != -1) {
            name = name.substring(0, dot);
        }
        if (!sourceFile.equals(destFile = new File(this.dir, String.valueOf(name) + LIC_EXT))) {
            int i = 2;
            while (destFile.exists()) {
                destFile = new File(this.dir, String.valueOf(name) + i + LIC_EXT);
                ++i;
            }
            try {
                this.copyFile(sourceFile, destFile);
            }
            catch (IOException ioe) {
                throw new LicenseProviderException(Messages.DIRECTORY_PROVIDER_FAILED_TO_COPY_LICENSE.getLocalisedValue(destFile.getPath()), ioe);
            }
        }
    }

    private void addLicenseServer(LicenseServer license) throws LicenseProviderException {
        int port;
        String hostname;
        try {
            hostname = license.getHostname();
            port = license.getPort();
        }
        catch (InvalidLicenseException lpe) {
            throw new LicenseProviderException(Messages.DIRECTORY_PROVIDER_FAILED_TO_PARSE_SERVER.getLocalisedValue(license.getLicenseAsString()), lpe);
        }
        File licFile = port == -1 ? new File(this.dir, String.valueOf(hostname) + LIC_EXT) : new File(this.dir, String.valueOf(port) + "_" + hostname + LIC_EXT);
        FileWriter licFileWriter = null;
        PrintWriter licFilePrinter = null;
        try {
            try {
                licFileWriter = new FileWriter(licFile);
                licFilePrinter = new PrintWriter(licFileWriter);
                licFilePrinter.print("SERVER ");
                licFilePrinter.print(hostname);
                licFilePrinter.print(" 0");
                if (port != -1) {
                    licFilePrinter.print(" ");
                    licFilePrinter.print(port);
                }
                licFilePrinter.println();
                licFilePrinter.println("USE_SERVER");
            }
            catch (IOException ioe) {
                throw new LicenseProviderException(Messages.DIRECTORY_PROVIDER_FAILED_TO_WRITE_LICENSE.getLocalisedValue(licFile.getAbsolutePath()), ioe);
            }
        }
        catch (Throwable throwable) {
            try {
                if (licFilePrinter != null) {
                    licFilePrinter.close();
                }
                if (licFileWriter != null) {
                    licFileWriter.close();
                }
            }
            catch (IOException ioe) {
                throw new LicenseProviderException(Messages.DIRECTORY_PROVIDER_FAILED_TO_WRITE_LICENSE.getLocalisedValue(licFile.getAbsolutePath()), ioe);
            }
            throw throwable;
        }
        try {
            if (licFilePrinter != null) {
                licFilePrinter.close();
            }
            if (licFileWriter != null) {
                licFileWriter.close();
            }
        }
        catch (IOException ioe) {
            throw new LicenseProviderException(Messages.DIRECTORY_PROVIDER_FAILED_TO_WRITE_LICENSE.getLocalisedValue(licFile.getAbsolutePath()), ioe);
        }
    }

    @Override
    public void addLicense(ILicense license) throws LicenseProviderException {
        File destDir = new File(this.dir);
        if (!destDir.exists() && !destDir.mkdirs()) {
            throw new LicenseProviderException(Messages.DIRECTORY_PROVIDER_FAILED_TO_CREATE_DIR.getLocalisedValue(destDir.getAbsolutePath()));
        }
        if (license instanceof ILicenseFile) {
            this.addLicenseFile((ILicenseFile)license);
        } else if (license instanceof LicenseServer) {
            this.addLicenseServer((LicenseServer)license);
        } else {
            throw new LicenseProviderException(Messages.DIRECTORY_PROVIDER_FAILED_TO_ADD_LICENSE.getLocalisedValue(license.getLicenseAsString()));
        }
    }

    @Override
    public void deleteLicense(String licenseLocation) throws LicenseProviderException, IllegalArgumentException, IOException {
        ArrayList<Path> paths = this.getLicenseFiles();
        for (Path path : paths) {
            if (!path.toString().equals(licenseLocation)) continue;
            try {
                if (!Files.deleteIfExists(path)) {
                    throw new LicenseProviderException(Messages.DIRECTORY_PROVIDER_FAILED_TO_DELETE_LICENSE.getLocalisedValue(licenseLocation));
                }
            }
            catch (IOException iOException) {
                throw new IOException(Messages.DIRECTORY_PROVIDER_FAILED_TO_DELETE_LICENSE.getLocalisedValue(licenseLocation));
            }
            return;
        }
        throw new IllegalArgumentException(Messages.DIRECTORY_PROVIDER_LICENSE_DOES_NOT_EXIST.getLocalisedValue(licenseLocation));
    }

    @Override
    public String getDescription() {
        return Messages.DIRECTORY_PROVIDER_DESCRIPTION.getLocalisedValue(this.dir, this.getLicensePaths());
    }

    @Override
    public String getProviderAsString() {
        return Messages.DIRECTORY_PROVIDER_AS_STRING.getLocalisedValue(this.dir);
    }

    @Override
    public boolean isDeletable() {
        return Files.isWritable(Paths.get(this.dir, new String[0]));
    }

    public int hashCode() {
        return Objects.hashCode(this.dir);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        DirectoryProvider other = (DirectoryProvider)obj;
        return new File(this.dir).equals(new File(other.dir));
    }
}

