/*
 * Decompiled with CFR 0.152.
 */
package com.arm.licensing.license;

import com.arm.text.FormattedMessage;
import com.arm.text.IFormattedMessage;
import com.arm.text.ILayer;
import com.arm.text.IMessage;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.Locale;
import java.util.ResourceBundle;
import javax.annotation.Nullable;

public enum Messages implements IMessage
{
    LICENSE_TRIPLE_SERVER_WRONG_NUMBER_OF_SERVERS("001_LICENSE_TRIPLE_SERVER_WRONG_NUMBER_OF_SERVERS", 1),
    LICENSE_FILE_DOES_NOT_EXIST("010_LICENSE_FILE_DOES_NOT_EXIST", 10),
    LICENSE_FILE_EXPIRED("011_LICENSE_FILE_EXPIRED", 11),
    LICENSE_FILE_INVALID("012_LICENSE_FILE_INVALID", 12),
    LICENSE_FILE_IOERROR("013_LICENSE_FILE_IOERROR", 13),
    LICENSE_FILE_NO_FEATURES("014_LICENSE_FILE_NO_FEATURES", 14),
    LICENSE_FILE_DESCRIPTION("015_LICENSE_FILE_DESCRIPTION", 15),
    LICENSE_SERVER_FAILED_TO_CONNECT_TO_PORT("020_LICENSE_SERVER_FAILED_TO_CONNECT_TO_PORT", 20),
    LICENSE_SERVER_FAILED_TO_CONNECT_TO_PORT_RANGE("021_LICENSE_SERVER_FAILED_TO_CONNECT_TO_PORT_RANGE", 21),
    LICENSE_SERVER_FAILED_TO_RESOLVE("022_LICENSE_SERVER_FAILED_TO_RESOLVE", 22),
    LICENSE_SERVER_INVALID_HOST("023_LICENSE_SERVER_INVALID_HOST", 23),
    LICENSE_SERVER_INVALID_PORT("024_LICENSE_SERVER_INVALID_PORT", 24),
    LICENSE_SERVER_INVALID_SERVER("025_LICENSE_SERVER_INVALID_SERVER", 25),
    LICENSE_SERVER_UNABLE_TO_CONNECT_TO_PORT("026_LICENSE_SERVER_UNABLE_TO_CONNECT_TO_PORT", 26),
    LICENSE_SERVER_UNABLE_TO_RESOLVE_HOST("027_LICENSE_SERVER_UNABLE_TO_RESOLVE_HOST", 27);

    private static final ResourceBundle RESOURCE_BUNDLE_ENGLISH;
    private static ResourceBundle RESOURCE_BUNDLE_LOCALISED;
    private final String key;
    private final int code;

    static {
        RESOURCE_BUNDLE_ENGLISH = ResourceBundle.getBundle("com/arm/licensing/license/messages", Locale.ROOT);
        Messages.refreshLocalized();
    }

    public static void refreshLocalized() {
        RESOURCE_BUNDLE_LOCALISED = ResourceBundle.getBundle("com/arm/licensing/license/messages");
    }

    private Messages(String key, int code) {
        this.key = key;
        this.code = code;
    }

    public int getCode() {
        return this.code;
    }

    public String getEnglishValue(Object ... args) {
        String englishMessage = RESOURCE_BUNDLE_ENGLISH.getString(this.key);
        englishMessage = Messages.removeParameterNames(englishMessage);
        return (args = Messages.removeNesting(args, false)) != null && args.length > 0 ? MessageFormat.format(englishMessage, args) : englishMessage;
    }

    public String getLocalisedValue(Object ... args) {
        String localMessage = RESOURCE_BUNDLE_LOCALISED.getString(this.key);
        localMessage = Messages.removeParameterNames(localMessage);
        return (args = Messages.removeNesting(args, true)) != null && args.length > 0 ? MessageFormat.format(localMessage, args) : localMessage;
    }

    private static Object[] removeNesting(@Nullable Object[] args, boolean localise) {
        if (args != null) {
            boolean isCopy = false;
            int i = 0;
            while (i < args.length) {
                Object a = args[i];
                if (a instanceof IFormattedMessage || a instanceof IMessage) {
                    if (!isCopy) {
                        isCopy = true;
                        args = Arrays.copyOf(args, args.length);
                    }
                    args[i] = a instanceof IFormattedMessage ? (localise ? ((IFormattedMessage)a).getLocalisedValue() : ((IFormattedMessage)a).getEnglishValue()) : (localise ? ((IMessage)a).getLocalisedValue(new Object[0]) : ((IMessage)a).getEnglishValue(new Object[0]));
                }
                ++i;
            }
        }
        return args;
    }

    private static String removeParameterNames(String message) {
        if (message.indexOf(123) < 0) {
            return message;
        }
        StringBuilder builder = new StringBuilder();
        boolean strip = false;
        boolean quoted = false;
        int i = 0;
        while (i < message.length()) {
            char current = message.charAt(i);
            switch (current) {
                case '\'': {
                    builder.append(current);
                    if (quoted) {
                        quoted = false;
                        break;
                    }
                    quoted = true;
                    break;
                }
                case '{': {
                    builder.append(current);
                    if (!quoted) {
                        int end = message.indexOf(125, i);
                        int colon = message.indexOf(58, i);
                        if (colon > 0 && colon < end) {
                            strip = true;
                        }
                    }
                    quoted = false;
                    break;
                }
                case ':': {
                    if (!strip) {
                        builder.append(current);
                    }
                    strip = false;
                    quoted = false;
                    break;
                }
                default: {
                    if (!strip) {
                        builder.append(current);
                    }
                    quoted = false;
                }
            }
            ++i;
        }
        return builder.toString();
    }

    public IFormattedMessage format(Object ... args) {
        return new FormattedMessage((IMessage)this, args);
    }

    public ILayer getLayer() {
        return null;
    }
}

