/*
 * Decompiled with CFR 0.152.
 */
package com.arm.licensing.license;

import com.arm.licensing.license.ILicense;
import com.arm.licensing.license.InvalidLicenseException;
import com.arm.licensing.license.LicenseServer;
import com.arm.licensing.license.Messages;
import com.arm.licensing.license.provider.AbstractLicenseEntity;
import com.arm.licensing.license.provider.ILicenseProvider;

public class LicenseTripleServer
extends AbstractLicenseEntity
implements ILicense {
    private final String location;

    public LicenseTripleServer(ILicenseProvider parent, String location) {
        super(parent);
        this.location = location;
    }

    @Override
    public String getLicenseAsString() {
        return this.location;
    }

    private String[] getSeparateServers() {
        return this.location.split(",");
    }

    @Override
    public void validateSyntax() throws InvalidLicenseException {
        String[] servers = this.getSeparateServers();
        if (servers.length != 3) {
            throw new InvalidLicenseException(Messages.LICENSE_TRIPLE_SERVER_WRONG_NUMBER_OF_SERVERS.getLocalisedValue(servers.length));
        }
        String[] stringArray = servers;
        int n = servers.length;
        int n2 = 0;
        while (n2 < n) {
            String server = stringArray[n2];
            new LicenseServer(null, server).validateSyntax();
            ++n2;
        }
    }

    @Override
    public void validateAll() throws InvalidLicenseException {
        String[] servers;
        String[] stringArray = servers = this.getSeparateServers();
        int n = servers.length;
        int n2 = 0;
        while (n2 < n) {
            String server = stringArray[n2];
            new LicenseServer(null, server).validateAll();
            ++n2;
        }
    }

    @Override
    public String getDescription() {
        return this.location;
    }

    @Override
    public boolean isDeletable() {
        return this.getParentProvider().isDeletable();
    }
}

