/*
 * Decompiled with CFR 0.152.
 */
package com.arm.licensing.license;

import com.arm.licensing.license.ILicense;
import com.arm.licensing.license.InvalidLicenseException;
import com.arm.licensing.license.Messages;
import com.arm.licensing.license.provider.AbstractLicenseEntity;
import com.arm.licensing.license.provider.ILicenseProvider;
import java.io.IOException;
import java.io.Serializable;
import java.net.ConnectException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.SocketTimeoutException;
import java.net.UnknownHostException;

public class LicenseServer
extends AbstractLicenseEntity
implements ILicense {
    public static final int NO_PORT = -1;
    private static final int MIN_DEFAULT_PORT = 27000;
    private static final int MAX_DEFAULT_PORT = 27009;
    private static final int RESOLVE_TIMEOUT = 5000;
    private static final int SOCKET_TIMEOUT_MS = 5000;
    private final String server;
    private final String location;

    public LicenseServer(ILicenseProvider parent, String server) {
        this(parent, server, server);
    }

    public LicenseServer(ILicenseProvider parent, String server, String location) {
        super(parent);
        this.server = server;
        this.location = location;
    }

    private String[] splitLocationIntoPortAndHostname() throws InvalidLicenseException {
        String[] parts = this.getDescription().split("@");
        if (parts.length != 2) {
            throw new InvalidLicenseException(Messages.LICENSE_SERVER_INVALID_SERVER.getLocalisedValue(this.getDescription()));
        }
        return parts;
    }

    @Override
    public String getLicenseAsString() {
        return this.location;
    }

    public String getHostname() throws InvalidLicenseException {
        String[] parts = this.splitLocationIntoPortAndHostname();
        return parts[1];
    }

    public int getPort() throws InvalidLicenseException {
        String[] parts = this.splitLocationIntoPortAndHostname();
        int port = -1;
        if (parts[0].length() != 0) {
            try {
                port = Integer.parseInt(parts[0]);
            }
            catch (NumberFormatException nfe) {
                throw new InvalidLicenseException(Messages.LICENSE_SERVER_INVALID_PORT.getLocalisedValue(Integer.toString(port)), nfe);
            }
            if (port < 0 || port > 65535) {
                throw new InvalidLicenseException(Messages.LICENSE_SERVER_INVALID_PORT.getLocalisedValue(Integer.toString(port)));
            }
        }
        return port;
    }

    @Override
    public void validateSyntax() throws InvalidLicenseException {
        this.getPort();
        String hostname = this.getHostname();
        if (!hostname.matches("[0-9a-zA-Z-\\._]+")) {
            throw new InvalidLicenseException(Messages.LICENSE_SERVER_INVALID_HOST.getLocalisedValue(hostname));
        }
    }

    private InetAddress resolveHostname(final String hostname, int timeout) throws UnknownHostException {
        final Object[] result = new Object[]{new UnknownHostException(Messages.LICENSE_SERVER_FAILED_TO_RESOLVE.getLocalisedValue(hostname))};
        Thread resolver = new Thread("Resolving hostname " + hostname){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                Serializable tempResult;
                try {
                    tempResult = InetAddress.getByName(hostname);
                }
                catch (UnknownHostException uhe) {
                    tempResult = uhe;
                }
                Object[] objectArray = result;
                synchronized (result) {
                    result[0] = tempResult;
                    result.notify();
                    // ** MonitorExit[var2_3] (shouldn't be in output)
                    return;
                }
            }
        };
        resolver.setDaemon(true);
        Object[] objectArray = result;
        synchronized (result) {
            resolver.start();
            try {
                result.wait(timeout);
            }
            catch (InterruptedException interruptedException) {}
            if (result[0] instanceof InetAddress) {
                // ** MonitorExit[var5_5] (shouldn't be in output)
                return (InetAddress)result[0];
            }
            throw (UnknownHostException)result[0];
        }
    }

    private void validateHostAndPort(String hostname, int port) throws InvalidLicenseException {
        Socket socket = null;
        try {
            try {
                InetAddress address = this.resolveHostname(hostname, 5000);
                InetSocketAddress socketAddress = new InetSocketAddress(address, port);
                socket = new Socket();
                socket.connect(socketAddress, 5000);
            }
            catch (UnknownHostException uhe) {
                throw new InvalidLicenseException(Messages.LICENSE_SERVER_UNABLE_TO_RESOLVE_HOST.getLocalisedValue(hostname), uhe);
            }
            catch (ConnectException ce) {
                throw new InvalidLicenseException(Messages.LICENSE_SERVER_UNABLE_TO_CONNECT_TO_PORT.getLocalisedValue(Integer.toString(port), hostname), ce);
            }
            catch (IOException ioe) {
                throw new InvalidLicenseException(Messages.LICENSE_SERVER_FAILED_TO_CONNECT_TO_PORT.getLocalisedValue(Integer.toString(port), hostname), ioe);
            }
        }
        catch (Throwable throwable) {
            if (socket != null) {
                try {
                    socket.close();
                }
                catch (IOException iOException) {}
            }
            throw throwable;
        }
        if (socket != null) {
            try {
                socket.close();
            }
            catch (IOException iOException) {}
        }
    }

    @Override
    public void validateAll() throws InvalidLicenseException {
        String hostname = this.getHostname();
        int port = this.getPort();
        if (port == -1) {
            port = 27000;
            while (port < 27009) {
                block4: {
                    try {
                        this.validateHostAndPort(hostname, port);
                    }
                    catch (InvalidLicenseException ile) {
                        Throwable cause = ile.getCause();
                        if (cause instanceof ConnectException || cause instanceof SocketTimeoutException) break block4;
                        throw ile;
                    }
                }
                ++port;
            }
            throw new InvalidLicenseException(Messages.LICENSE_SERVER_FAILED_TO_CONNECT_TO_PORT_RANGE.getLocalisedValue(hostname, Integer.toString(27000), Integer.toString(27009)));
        }
        this.validateHostAndPort(hostname, port);
    }

    @Override
    public String getDescription() {
        return this.server;
    }

    @Override
    public boolean isDeletable() {
        return this.getParentProvider().isDeletable();
    }
}

