/*
 * Decompiled with CFR 0.152.
 */
package com.arm.licensing.license;

import com.arm.io.TextFileUtils;
import com.arm.licensing.flex.FlexFeature;
import com.arm.licensing.flex.Upgrade;
import com.arm.licensing.license.ILicenseFile;
import com.arm.licensing.license.InvalidLicenseException;
import com.arm.licensing.license.Messages;
import com.arm.licensing.license.provider.AbstractLicenseEntity;
import com.arm.licensing.license.provider.ILicenseProvider;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class LicenseFile
extends AbstractLicenseEntity
implements ILicenseFile {
    private final String location;
    private static final String FEATURE = "FEATURE";
    private static final String INCREMENT = "INCREMENT";
    private static final String UPGRADE = "UPGRADE";
    private static final Pattern FEATURE_PATTERN = Pattern.compile("^(\\S+)\\s+(\\S+)\\s+(\\S+)\\s+(\\S+)\\s+(\\S+)\\s+(\\S+)\\s+(.*)");
    private static final Pattern UPGRADE_PATTERN = Pattern.compile("^(\\S+)\\s+(\\S+)\\s+(\\S+)\\s+(\\S+)\\s+(\\S+)\\s+(\\S+)\\s+(\\S+)\\s+(.*)");

    public LicenseFile(ILicenseProvider parent, String location) {
        super(parent);
        this.location = location;
    }

    @Override
    public String getLicenseAsString() {
        return this.location;
    }

    private List<String> readFile() throws IOException {
        List lines = TextFileUtils.readContent((File)new File(this.location));
        LinkedList<String> result = new LinkedList<String>();
        String previousLine = null;
        for (String line : lines) {
            if (previousLine != null && previousLine.endsWith("\\") && line.startsWith("\t")) {
                previousLine = String.valueOf(previousLine.substring(0, previousLine.length() - 1)) + line.substring(1);
                continue;
            }
            if (previousLine != null) {
                result.add(previousLine);
            }
            previousLine = line;
        }
        if (previousLine != null) {
            result.add(previousLine);
        }
        return result;
    }

    private Map<String, String> splitExtraArgs(String args) {
        HashMap<String, String> results = new HashMap<String, String>();
        String key = "";
        String value = "";
        int state = 0;
        int n = 0;
        while (n < args.length()) {
            char c = args.charAt(n);
            switch (state) {
                case 0: {
                    if (Character.isWhitespace(c)) break;
                    state = 1;
                    key = String.valueOf(key) + c;
                    break;
                }
                case 1: {
                    if (c == '=') {
                        state = 2;
                        break;
                    }
                    if (Character.isWhitespace(c)) {
                        state = 0;
                        results.put("", key);
                        value = "";
                        key = "";
                        break;
                    }
                    key = String.valueOf(key) + c;
                    break;
                }
                case 2: {
                    if (c == '\"') {
                        state = 4;
                        break;
                    }
                    state = 3;
                    value = String.valueOf(value) + c;
                    break;
                }
                case 3: {
                    if (Character.isWhitespace(c)) {
                        state = 0;
                        results.put(key, value);
                        value = "";
                        key = "";
                        break;
                    }
                    value = String.valueOf(value) + c;
                    break;
                }
                case 4: {
                    if (c == '\"') {
                        state = 0;
                        results.put(key, value);
                        value = "";
                        key = "";
                        break;
                    }
                    value = String.valueOf(value) + c;
                }
            }
            ++n;
        }
        if (!key.isEmpty() || !value.isEmpty()) {
            results.put(key, value);
        }
        return results;
    }

    public List<FlexFeature> getFeatures() throws IOException, InvalidLicenseException {
        LinkedList<FlexFeature> features = new LinkedList<FlexFeature>();
        List<String> lines = this.readFile();
        if (lines.isEmpty()) {
            throw new InvalidLicenseException(Messages.LICENSE_FILE_INVALID.getLocalisedValue(this.location));
        }
        for (String line : lines) {
            String vendor;
            String feature;
            Matcher matcher = FEATURE_PATTERN.matcher(line);
            if (!matcher.matches()) continue;
            String command = matcher.group(1);
            if (command.equals(FEATURE) || command.equals(INCREMENT)) {
                feature = matcher.group(2);
                vendor = matcher.group(3);
                String version = matcher.group(4);
                String date = matcher.group(5);
                String count = matcher.group(6);
                Map<String, String> extraArgs = this.splitExtraArgs(matcher.group(7));
                features.add(new FlexFeature(feature, vendor, version, date, count, extraArgs));
                continue;
            }
            matcher = UPGRADE_PATTERN.matcher(line);
            if (!matcher.matches() || !(command = matcher.group(1)).equals(UPGRADE)) continue;
            feature = matcher.group(2);
            vendor = matcher.group(3);
            String fromVersion = matcher.group(4);
            String toVersion = matcher.group(5);
            String date = matcher.group(6);
            String count = matcher.group(7);
            Map<String, String> extraArgs = this.splitExtraArgs(matcher.group(8));
            features.add(new Upgrade(feature, vendor, fromVersion, toVersion, date, count, extraArgs));
        }
        return features;
    }

    @Override
    public void validateSyntax() throws InvalidLicenseException {
        if (this.location.endsWith(File.separator)) {
            throw new InvalidLicenseException(Messages.LICENSE_FILE_INVALID.getLocalisedValue(this.location));
        }
    }

    @Override
    public void validateAll() throws InvalidLicenseException {
        List<FlexFeature> features;
        File licenseFile = new File(this.location);
        if (!licenseFile.isFile()) {
            throw new InvalidLicenseException(Messages.LICENSE_FILE_DOES_NOT_EXIST.getLocalisedValue(this.location));
        }
        try {
            features = this.getFeatures();
        }
        catch (IOException ioe) {
            throw new InvalidLicenseException(Messages.LICENSE_FILE_IOERROR.getLocalisedValue(new Object[0]), ioe);
        }
        for (FlexFeature feature : features) {
            if (!feature.isExpired()) continue;
            throw new InvalidLicenseException(Messages.LICENSE_FILE_EXPIRED.getLocalisedValue(new Object[0]));
        }
    }

    @Override
    public String getDescription() {
        return new File(this.location).getName();
    }

    @Override
    public boolean isDeletable() {
        return new File(this.location).canWrite();
    }
}

