/*
 * Decompiled with CFR 0.152.
 */
package com.arm.licensing.flex;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Map;

public class FlexFeature {
    public static final String DATE_FORMAT = "dd-MMM-yyyy";
    public static final String PERMANENT = "permanent";
    private final String feature;
    private final String vendor;
    private final String version;
    private final String date;
    private final String count;
    private final Map<String, String> extras;

    public FlexFeature(String feature, String vendor, String version, String date, String count, Map<String, String> extras) {
        this.feature = feature;
        this.vendor = vendor;
        this.version = version;
        this.date = date;
        this.count = count;
        this.extras = extras;
    }

    public String getFeature() {
        return this.feature;
    }

    public String getVendor() {
        return this.vendor;
    }

    public String getVersion() {
        return this.version;
    }

    public String getDate() {
        return this.date;
    }

    private boolean isDatePermanent() {
        return this.date.equals(PERMANENT) || this.date.endsWith("-0") || this.date.endsWith("-00") || this.date.endsWith("-000") || this.date.endsWith("-0000");
    }

    private Calendar getDateAsCalendar() {
        Calendar expiry = Calendar.getInstance();
        SimpleDateFormat dateFormat = new SimpleDateFormat(DATE_FORMAT);
        try {
            expiry.setTime(dateFormat.parse(this.date));
        }
        catch (ParseException parseException) {
            return null;
        }
        expiry.set(11, 23);
        expiry.set(12, 59);
        expiry.set(13, 59);
        expiry.set(14, 999);
        return expiry;
    }

    public String getCount() {
        return this.count;
    }

    public boolean isExpired() {
        if (this.isDatePermanent()) {
            return false;
        }
        Calendar expiry = this.getDateAsCalendar();
        if (expiry == null) {
            return false;
        }
        Calendar today = Calendar.getInstance();
        return today.after(expiry);
    }

    public String getHostID() {
        if (this.extras != null) {
            return this.extras.get("HOSTID");
        }
        return null;
    }

    public String getNotice() {
        if (this.extras != null) {
            return this.extras.get("NOTICE");
        }
        return null;
    }

    public String getSerialNumber() {
        if (this.extras != null) {
            return this.extras.get("SN");
        }
        return null;
    }
}

