/*
 * Decompiled with CFR 0.152.
 */
package com.arm.licensing.defaults;

import com.arm.licensing.manager.Feature;
import com.arm.licensing.manager.ILicensingInterface;
import com.arm.licensing.manager.LicenseException;
import com.arm.licensing.manager.LicensingConfiguration;
import com.arm.licensing.manager.LicensingManager;
import com.arm.licensing.toolkits.IToolkitFilter;
import com.arm.licensing.toolkits.Toolkit;
import java.io.File;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;

public class AvailableToolkitFilter
implements IToolkitFilter {
    private final Function<File, ? extends LicensingConfiguration> configFactory;
    private final Feature[] coreToolFeatures;

    public AvailableToolkitFilter(Function<File, ? extends LicensingConfiguration> configFactory, Feature ... coreToolFeatures) {
        this.configFactory = configFactory;
        this.coreToolFeatures = coreToolFeatures;
    }

    @Override
    public Set<Toolkit> filter(Set<Toolkit> toolkits) {
        Map<String, List<Feature>> backendFeatures = null;
        HashSet<Toolkit> filtered = new HashSet<Toolkit>();
        for (Toolkit toolkit : toolkits) {
            try {
                ILicensingInterface toolkitInterface = LicensingManager.createNonGlobalInstance(this.configFactory.apply(toolkit.getLicenseMappingFile()));
                if (backendFeatures == null) {
                    backendFeatures = toolkitInterface.listBackendFeatures();
                }
                boolean allMatch = true;
                Feature[] featureArray = this.coreToolFeatures;
                int n = this.coreToolFeatures.length;
                int n2 = 0;
                while (n2 < n) {
                    Feature f = featureArray[n2];
                    if (!toolkitInterface.isFulfilledBy(f, backendFeatures)) {
                        allMatch = false;
                        break;
                    }
                    ++n2;
                }
                if (!allMatch) continue;
                filtered.add(toolkit);
            }
            catch (LicenseException licenseException) {}
        }
        return filtered;
    }
}

